/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.SWE.dp.binary;

import com.mapinfo.mapmarker.SWE.dp.binary.SWE_GeoInfoIndexFile;
import com.mapinfo.mapmarker.SWE.dp.binary.SWE_GeoInfoPreLoadedDataHelper;
import com.mapinfo.mapmarker.SWE.dp.binary.SWE_MMJRangeRecord;
import com.mapinfo.mapmarker.common.Address;
import com.mapinfo.mapmarker.common.dp.binary.DataCreationException;
import com.mapinfo.mapmarker.common.dp.binary.DataCreationLogger;
import com.mapinfo.mapmarker.common.dp.binary.GenericRange;
import com.mapinfo.mapmarker.common.dp.binary.GenericSegment;
import com.mapinfo.mapmarker.common.dp.binary.GenericStreet;
import com.mapinfo.mapmarker.common.dp.binary.GenericStreetBuilder;
import com.mapinfo.mapmarker.common.dp.binary.GeoInfoRecord;
import com.mapinfo.mapmarker.common.dp.binary.IDataFileDataItem;
import com.mapinfo.mapmarker.common.dp.binary.MMJComplexDataFileMetadata;
import com.mapinfo.mapmarker.common.dp.binary.MMJETypeArraySizeExceededException;
import com.mapinfo.mapmarker.common.dp.binary.MMJRangeRecord;
import com.mapinfo.mapmarker.common.dp.binary.MMJSegmentRecord;
import com.mapinfo.mapmarker.common.dp.binary.MultiSegmentStreet;
import com.mapinfo.mapmarker.common.dp.binary.index.GeoInfoIndexFile;
import com.mapinfo.mapmarker.common.dp.binary.index.MapMarkerIndexKey;
import com.mapinfo.mapmarker.common.dp.binary.index.MapMarkerIndexSingleValue;
import com.mapinfo.mapmarker.common.dp.binary.index.MiStringIndexKey;
import com.mapinfo.mapmarker.utils.StringUtilities;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;

public class SWE_StreetBuilder
extends GenericStreetBuilder {
    protected GeoInfoIndexFile m_geoIndex;
    private static Set<String> m_missingGeoInfoKeys = new HashSet<String>();
    protected SWE_GeoInfoPreLoadedDataHelper m_geoInfoHelper = new SWE_GeoInfoPreLoadedDataHelper();

    protected void populateLocalStreetInfo(MultiSegmentStreet record, IDataFileDataItem street, MMJComplexDataFileMetadata metadata) throws DataCreationException {
        Address address = record.getAddress();
        try {
            HashMap fields;
            String value;
            if (address.hasAdditionalFields() && (value = (String)(fields = address.getAdditionalFields()).get("POST_STREET_TYPE_SEPARATOR")) != null) {
                ((GenericStreet)street).putBoolean(32, true);
            }
        }
        catch (MMJETypeArraySizeExceededException MMJETASEEx) {
            DataCreationLogger.getLogger().logError("Unable to add to the street: " + address.toString());
            throw new DataCreationException((Throwable)MMJETASEEx);
        }
    }

    protected String buildAreaNameString(MMJSegmentRecord record, boolean isLeft) {
        String tmp;
        StringBuilder sb = new StringBuilder();
        String string = tmp = isLeft ? record.getLeftAreaName1() : record.getRightAreaName1();
        if (tmp != null) {
            sb.append(tmp);
        }
        String string2 = tmp = isLeft ? record.getLeftAreaName2() : record.getRightAreaName2();
        if (tmp != null) {
            sb.append(tmp);
        }
        String string3 = tmp = isLeft ? record.getLeftAreaName3() : record.getRightAreaName3();
        if (tmp != null) {
            sb.append(tmp);
        }
        String string4 = tmp = isLeft ? record.getLeftAreaName4() : record.getRightAreaName4();
        if (tmp != null) {
            sb.append(tmp);
        }
        return sb.toString();
    }

    private void removeCommonAreaStrings(GenericSegment segment) throws MMJETypeArraySizeExceededException {
        this.removeSegmentString(segment, 14);
        this.removeSegmentString(segment, 15);
        this.removeSegmentString(segment, 16);
        this.removeSegmentString(segment, 17);
    }

    private String removeSegmentString(GenericSegment segment, int field) throws MMJETypeArraySizeExceededException {
        if (segment.hasString(field)) {
            return segment.removeString(field);
        }
        return null;
    }

    protected void populateLocalRangeInfo(MMJRangeRecord record, IDataFileDataItem rangeItem, MMJComplexDataFileMetadata metadata) throws DataCreationException {
        if (((SWE_MMJRangeRecord)record).isArtificialRange()) {
            GenericRange range = (GenericRange)rangeItem;
            try {
                boolean bHouseCounts = ((SWE_MMJRangeRecord)record).isCountsAsSingleArtificialHouse();
                range.putBoolean(32, bHouseCounts);
            }
            catch (MMJETypeArraySizeExceededException e) {
                DataCreationLogger.getLogger().logInternalError("Unable to populate artificial range data.");
                DataCreationLogger.getLogger().logInternalError(e.getMessage());
                DataCreationLogger.getLogger().logStackTrace((Throwable)e);
                throw new DataCreationException(107, (Throwable)e);
            }
        }
    }

    protected void populateLocalSegmentInfo(MMJSegmentRecord segmentRecord, IDataFileDataItem segmentItem, MMJComplexDataFileMetadata metadata) throws DataCreationException {
        GenericSegment segment = (GenericSegment)segmentItem;
        try {
            String leftPostCode1 = segmentRecord.getLeftPostalCode1();
            String rightPostCode1 = segmentRecord.getRightPostalCode1();
            int leftPost = 0;
            int rightPost = 0;
            try {
                if (leftPostCode1 != null) {
                    leftPost = Integer.parseInt(leftPostCode1);
                }
                if (rightPostCode1 != null) {
                    rightPost = Integer.parseInt(rightPostCode1);
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (leftPost == rightPost && leftPost != 0) {
                this.removeSegmentString(segment, 12);
                this.removeSegmentString(segment, 0);
                this.removeSegmentString(segment, 1);
                if (leftPost < Short.MAX_VALUE) {
                    segment.putShort(32, (short)leftPost);
                } else {
                    segment.putInt(32, leftPost);
                }
            } else {
                if (leftPost != 0) {
                    this.removeSegmentString(segment, 0);
                    if (leftPost < Short.MAX_VALUE) {
                        segment.putShort(33, (short)leftPost);
                    } else {
                        segment.putInt(33, leftPost);
                    }
                }
                if (rightPost != 0) {
                    this.removeSegmentString(segment, 1);
                    if (rightPost < Short.MAX_VALUE) {
                        segment.putShort(34, (short)rightPost);
                    } else {
                        segment.putInt(34, rightPost);
                    }
                }
            }
            if (this.m_geoIndex != null) {
                String leftAreaNameKey = this.buildAreaNameString(segmentRecord, true);
                String rightAreaNameKey = this.buildAreaNameString(segmentRecord, false);
                MapMarkerIndexSingleValue leftval = (MapMarkerIndexSingleValue)this.m_geoIndex.search((MapMarkerIndexKey)new MiStringIndexKey(leftAreaNameKey));
                MapMarkerIndexSingleValue rightval = (MapMarkerIndexSingleValue)this.m_geoIndex.search((MapMarkerIndexKey)new MiStringIndexKey(rightAreaNameKey));
                if (leftval != null && rightval != null && leftval.getOffset() != 0L && leftval.getOffset() == rightval.getOffset()) {
                    segment.putLong(0, leftval.getOffset());
                    this.removeCommonAreaStrings(segment);
                } else {
                    if (leftval == null) {
                        if (!StringUtilities.isEmpty((String)leftAreaNameKey)) {
                            m_missingGeoInfoKeys.add(leftAreaNameKey + " (" + segmentRecord.getLeftAreaName1() + "," + segmentRecord.getLeftAreaName2() + "," + segmentRecord.getLeftAreaName3() + "," + segmentRecord.getLeftAreaName4() + "," + segmentRecord.getLeftPostalCode1() + ")");
                        }
                    } else {
                        DataCreationLogger.getLogger().logInternalError("\n\nERROR: Unable to get offset for geoinfo record with left key: " + leftAreaNameKey + " (" + segmentRecord.getLeftAreaName1() + "," + segmentRecord.getLeftAreaName2() + "," + segmentRecord.getLeftAreaName3() + "," + segmentRecord.getLeftAreaName4() + "," + segmentRecord.getLeftPostalCode1() + ")");
                    }
                    if (rightval == null) {
                        if (!StringUtilities.isEmpty((String)rightAreaNameKey)) {
                            m_missingGeoInfoKeys.add(rightAreaNameKey + " (" + segmentRecord.getRightAreaName1() + "," + segmentRecord.getRightAreaName2() + "," + segmentRecord.getRightAreaName3() + "," + segmentRecord.getRightAreaName4() + "," + segmentRecord.getRightPostalCode1() + ")");
                        }
                    } else {
                        DataCreationLogger.getLogger().logInternalError("\n\nERROR: Unable to get offset for geoinfo record with right key: " + rightAreaNameKey + " (" + segmentRecord.getRightAreaName1() + "," + segmentRecord.getRightAreaName2() + "," + segmentRecord.getRightAreaName3() + "," + segmentRecord.getRightAreaName4() + "," + segmentRecord.getRightPostalCode1() + ")");
                    }
                }
            }
        }
        catch (MMJETypeArraySizeExceededException e) {
            DataCreationLogger.getLogger().logInternalError("Unable to populate segment data.");
            DataCreationLogger.getLogger().logInternalError(e.getMessage());
            DataCreationLogger.getLogger().logStackTrace((Throwable)e);
            throw new DataCreationException(106, (Throwable)e);
        }
        catch (IOException e) {
            DataCreationLogger.getLogger().logInternalError("Problem building generic segment.  Unable to lookup areaName in geoinfo.");
            DataCreationLogger.getLogger().logStackTrace((Throwable)e);
            throw new DataCreationException(106, (Throwable)e);
        }
    }

    protected void populateLocalGeoInfo(GeoInfoRecord record, IDataFileDataItem geoInfoItem, MMJComplexDataFileMetadata metadata) throws DataCreationException {
        this.m_geoInfoHelper.populateLocalGeoInfo(record, geoInfoItem, metadata);
    }

    public void initGeoInfoExactLookupIndex(String dataSetPath) {
        try {
            this.m_geoIndex = new SWE_GeoInfoIndexFile();
            this.m_geoIndex.open(StringUtilities.appendToPath((String)dataSetPath, (String)"geoinfo.jdx"));
        }
        catch (IOException IOEx) {
            DataCreationLogger.getLogger().logInternalError("ERROR: Unable to open geoinfo files.");
            DataCreationLogger.getLogger().logInternalError(IOEx.getMessage());
            DataCreationLogger.getLogger().logStackTrace((Throwable)IOEx);
            throw new RuntimeException("ERROR: Unable to open geoinfo files.", IOEx);
        }
    }

    public static Set<String> getMissingGeoInfoKeys() {
        return m_missingGeoInfoKeys;
    }
}

