/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.SWE.dp.binary.index;

import com.mapinfo.mapmarker.SWE.SWELanguageSoundex;
import com.mapinfo.mapmarker.common.ISoundexKey;
import com.mapinfo.mapmarker.common.dp.binary.DataCreationException;
import com.mapinfo.mapmarker.common.dp.binary.DataCreationLogger;
import com.mapinfo.mapmarker.common.dp.binary.GeoInfoDataItem;
import com.mapinfo.mapmarker.common.dp.binary.MMJComplexDataFileMetadata;
import com.mapinfo.mapmarker.common.dp.binary.MMJETypeArraySizeExceededException;
import com.mapinfo.mapmarker.common.dp.binary.index.GeoInfoSoundexIndexer;
import com.mapinfo.mapmarker.utils.BlobUtilities;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;

public class SWE_GeoInfoSoundexIndexer
extends GeoInfoSoundexIndexer {
    public SWE_GeoInfoSoundexIndexer() {
        this.sndx = new SWELanguageSoundex();
    }

    protected ArrayList makeKeys(GeoInfoDataItem item, MMJComplexDataFileMetadata metadata) throws DataCreationException {
        return this.makeKeys(item);
    }

    protected ArrayList makeKeys(GeoInfoDataItem item) {
        String[] altValues;
        if (item == null) {
            DataCreationLogger.getLogger().logError("Error: No soundex key made for null item");
            return null;
        }
        String keyBase = this.getValue(item, 3);
        if (keyBase != null) {
            altValues = this.getValueBlob(item, 35);
        } else {
            keyBase = this.getValue(item, 2);
            altValues = this.getValueBlob(item, 34);
        }
        if (keyBase == null) {
            keyBase = this.getValue(item, 1);
            altValues = this.getValueBlob(item, 33);
        }
        if (keyBase == null) {
            keyBase = this.getValue(item, 0);
            altValues = this.getValueBlob(item, 32);
        }
        if (keyBase == null) {
            DataCreationLogger.getLogger().logError("Error: No soundex key made for item " + item.toString());
            return null;
        }
        HashSet<ISoundexKey> set = new HashSet<ISoundexKey>();
        keyBase = keyBase.toUpperCase();
        keyBase = this.handleParens(set, keyBase);
        set.add(this.sndx.getSoundex(keyBase));
        if (altValues != null) {
            for (String alternate : altValues) {
                alternate = alternate.toUpperCase();
                alternate = this.handleParens(set, alternate);
                set.add(this.sndx.getSoundex(alternate));
            }
        }
        return new ArrayList<ISoundexKey>(set);
    }

    protected String getValue(GeoInfoDataItem item, int key) {
        try {
            if (item.hasString(key)) {
                return item.getString(key);
            }
            return null;
        }
        catch (MMJETypeArraySizeExceededException ex) {
            return null;
        }
    }

    protected String[] getValueBlob(GeoInfoDataItem item, int key) {
        try {
            if (item.hasBlob(key)) {
                byte[] blob = item.getBlob(key);
                return BlobUtilities.decodeStringArray((byte[])blob);
            }
            return null;
        }
        catch (MMJETypeArraySizeExceededException ex) {
            return null;
        }
        catch (IOException ioEx) {
            DataCreationLogger.getLogger().logError("Error: cannot decode alternates");
            return null;
        }
    }

    protected String handleParens(HashSet<ISoundexKey> set, String orig) {
        int idx = orig.indexOf(40);
        if (idx < 0) {
            return orig;
        }
        if (orig.indexOf("DELEN", idx) < 0) {
            ISoundexKey key = this.sndx.getSoundex(orig);
            set.add(key);
        }
        return orig.substring(0, idx).trim();
    }
}

