/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.SWE.filters;

import com.mapinfo.mapmarker.common.Address;
import com.mapinfo.mapmarker.common.ICandidate;
import com.mapinfo.mapmarker.common.InternalCandidateAddress;
import com.mapinfo.mapmarker.common.filters.ICloseMatchFilterRule;
import com.mapinfo.mapmarker.utils.StringUtilities;

public class LocalityStreetFilter
implements ICloseMatchFilterRule {
    public boolean demoteOther(Address[] inputAddresses, ICandidate bestCloseMatch, ICandidate otherCloseMatch) {
        boolean bInputLocality;
        boolean bOtherLocality;
        InternalCandidateAddress best = (InternalCandidateAddress)bestCloseMatch;
        InternalCandidateAddress other = (InternalCandidateAddress)otherCloseMatch;
        if (best.getDictionaryPriority() != other.getDictionaryPriority()) {
            return false;
        }
        if (!StringUtilities.equalStrings((String)best.getAreaName3(), (String)other.getAreaName3())) {
            return false;
        }
        boolean bBestLocality = !StringUtilities.isEmpty((String)best.getAreaName4());
        boolean bl = bOtherLocality = !StringUtilities.isEmpty((String)other.getAreaName4());
        if (bBestLocality == bOtherLocality) {
            return false;
        }
        if (best.getMainAddressScore() < other.getMainAddressScore()) {
            return false;
        }
        if (best.getAddressNumberScore() < other.getAddressNumberScore()) {
            return false;
        }
        if (best.getAreaName3Score() < other.getAreaName3Score()) {
            return false;
        }
        if (best.getPreDirectionalScore() < 1.0 && other.getPreDirectionalScore() == 1.0) {
            return false;
        }
        if (best.getPostThoroughfareTypeScore() < 1.0 && other.getPostThoroughfareTypeScore() == 1.0) {
            return false;
        }
        if (best.getPreDirectionalScore() == other.getPreDirectionalScore() && best.getPreDirectionalScore() == 1.0 && StringUtilities.isEmpty((String)best.getPreDirectional()) != StringUtilities.isEmpty((String)other.getPreDirectional())) {
            return false;
        }
        boolean bl2 = bInputLocality = !StringUtilities.isEmpty((String)inputAddresses[0].getAreaName4());
        if (bInputLocality) {
            return false;
        }
        if (best.getAreaName4Score() != other.getAreaName4Score()) {
            return false;
        }
        return !bBestLocality && bOtherLocality;
    }
}

