/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.SWE.parser;

import com.mapinfo.mapmarker.IConstraints;
import com.mapinfo.mapmarker.SWE.SWE_AddressUtils;
import com.mapinfo.mapmarker.SWE.parser.SWE_ThoroughfareTypes;
import com.mapinfo.mapmarker.SWE.parser.SWE_UnitTypes;
import com.mapinfo.mapmarker.common.Address;
import com.mapinfo.mapmarker.common.ParsedNumber;
import com.mapinfo.mapmarker.core.parser.IParseRule;
import com.mapinfo.mapmarker.core.parser.ParserException;
import com.mapinfo.mapmarker.utils.StringUtilities;
import com.mapinfo.mapmarker.utils.StringWithTokens;

public class SWE_ParseMainAddressRule
implements IParseRule {
    public static final String STREET_SUFFIX = "street_suffix";
    public static final String KEY_ORIG_MAIN = "KEY_ORIG_MAIN";
    protected static final String NON_TOKENIZING_SEPARATORS = "-_+";

    public void parse(Address ura, Address pa, IConstraints constraints) throws ParserException {
        String last;
        if (ura == null) {
            throw new ParserException(2000);
        }
        if (pa == null) {
            throw new ParserException(2001);
        }
        String main = pa.getMainAddress();
        pa.setMainAddress(null);
        if (StringUtilities.isEmpty((String)main)) {
            return;
        }
        main = main.toUpperCase();
        String newMain = SWE_AddressUtils.expandAbbreviations(main = this.cleanParens(pa, main));
        if (newMain != null && !StringUtilities.equalStrings((String)newMain, (String)main)) {
            pa.getAdditionalFields().put(KEY_ORIG_MAIN, main);
        }
        StringWithTokens swt = new StringWithTokens(main, " \t,;./\\");
        this.cleanBox(pa, swt);
        this.handleUnits(pa, swt);
        this.findHouse(pa, swt);
        this.findDirectional(pa, swt);
        if (swt.size() > 0) {
            main = swt.toString();
            if (main.length() > 1 || main.charAt(0) != 'G' && main.charAt(0) != 'V') {
                main = SWE_AddressUtils.expandAbbreviations(swt.toString());
            }
            if (!StringUtilities.equalStrings((String)main, (String)swt.toString())) {
                swt = new StringWithTokens(main, " \t,;./\\");
            }
        }
        boolean bDataBuilding = constraints.containsCustomObjectKey((Object)"DATA_CONSTRUCTION_PARSER");
        this.findStreet(pa, swt, bDataBuilding);
        if (swt.isEmpty()) {
            if (pa.getMainAddress() == null && pa.getPostThoroughfareType() != null) {
                if (pa.getPreDirectional() != null) {
                    pa.setMainAddress(pa.getPreDirectional());
                    pa.setPreDirectional(null);
                } else {
                    pa.setMainAddress(pa.getPostThoroughfareType());
                    pa.setPostThoroughfareType(null);
                }
            }
            pa.setMainAddress(SWE_AddressUtils.expandAbbreviations(pa.getMainAddress()));
            return;
        }
        String possibleHouse = swt.removeFirst();
        if (pa.getAddressNumber() == null && (possibleHouse.length() == 1 || StringUtilities.hasNumeric((String)possibleHouse))) {
            if (StringUtilities.isNumeric((String)possibleHouse) && !swt.isEmpty()) {
                String possibleSecond = swt.getFirstToken();
                if (StringUtilities.hasNumeric((String)possibleSecond)) {
                    pa.setAddressNumber(possibleSecond);
                    pa.getAdditionalFields().put(STREET_SUFFIX, possibleHouse);
                    swt.removeFirst();
                    possibleHouse = null;
                } else if (possibleSecond.length() == 1) {
                    ParsedNumber number = new ParsedNumber(possibleHouse);
                    if (number.isPureNumeric()) {
                        number.setAddressSuffix(possibleSecond);
                    }
                    swt.removeFirst();
                    possibleHouse = number.getCombinedAddressNumber();
                }
            }
            if (possibleHouse != null) {
                pa.setAddressNumber(possibleHouse);
                possibleHouse = null;
            }
        }
        if (pa.getAddressNumber() == null && !swt.isEmpty() && StringUtilities.hasNumeric((String)(last = swt.getLastToken()))) {
            pa.setAddressNumber(last);
            swt.removeLast();
        }
        StringBuilder stringBuilder = new StringBuilder();
        if (possibleHouse != null) {
            stringBuilder.append(possibleHouse);
        }
        if (!swt.isEmpty()) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(' ');
            }
            stringBuilder.append(swt.toString());
        }
        if (stringBuilder.length() > 0) {
            String prefix = (String)pa.getAdditionalFields().get(STREET_SUFFIX);
            if (prefix != null) {
                stringBuilder.insert(0, ' ');
                stringBuilder.insert(0, prefix);
            }
            pa.getAdditionalFields().put(STREET_SUFFIX, stringBuilder.toString());
        }
        if (pa.getMainAddress() == null && pa.getPostThoroughfareType() != null) {
            pa.setMainAddress(pa.getPostThoroughfareType());
            pa.setPostThoroughfareType(null);
        }
    }

    protected void findHouse(Address pa, StringWithTokens swt) {
        if (!StringUtilities.isEmpty((String)pa.getAddressNumber())) {
            return;
        }
        String tok = swt.getLastToken();
        if (StringUtilities.hasNumeric((String)tok)) {
            pa.setAddressNumber(tok);
            swt.removeLast();
        }
    }

    protected void findDirectional(Address pa, StringWithTokens swt) {
        if (!StringUtilities.isEmpty((String)pa.getPreDirectional())) {
            return;
        }
        if (swt.size() == 1) {
            return;
        }
        String tok = swt.getFirstToken();
        if (SWE_AddressUtils.isDirectional(tok)) {
            pa.setPreDirectional(SWE_AddressUtils.expandDirectional(tok));
            swt.removeFirst();
        }
    }

    protected String cleanParens(Address pa, String line) {
        if (line == null) {
            return line;
        }
        int idx = line.indexOf(40);
        if (idx < 0) {
            return line;
        }
        StringBuilder sb = new StringBuilder(line.length());
        sb.append(line.substring(0, idx));
        int endIdx = line.lastIndexOf(41);
        if (endIdx < 0) {
            pa.setGenericField2(line.substring(idx + 1));
        } else {
            pa.setGenericField2(line.substring(idx + 1, endIdx));
            if (endIdx < line.length() - 1) {
                if (sb.length() > 0 && sb.charAt(sb.length() - 1) != ' ') {
                    sb.append(' ');
                }
                sb.append(line.substring(endIdx + 1));
            }
        }
        return sb.toString().trim();
    }

    protected void cleanBox(Address pa, StringWithTokens swt) {
        for (int i = 0; i < swt.size(); ++i) {
            String tok;
            if (!"BOX".equalsIgnoreCase(swt.getToken(i))) continue;
            if (i < swt.size() - 1 && StringUtilities.hasNumeric((String)(tok = swt.getToken(i + 1)))) {
                StringBuilder sb = new StringBuilder("BOX ");
                sb.append(tok);
                pa.getAdditionalFields().put("BOX", sb.toString());
                swt.remove(i + 1);
                swt.remove(i);
                return;
            }
            pa.getAdditionalFields().put("BOX", "BOX");
            swt.remove(i);
            return;
        }
    }

    protected void findStreet(Address pa, StringWithTokens swt, boolean bIsDataConstruction) {
        StringBuilder sb = new StringBuilder();
        while (swt.size() > 0) {
            String token = swt.getFirstToken();
            if (SWE_ThoroughfareTypes.isStreetType(token)) {
                swt.removeFirst();
                pa.getAdditionalFields().put("POST_STREET_TYPE_SEPARATOR", "true");
                pa.setPostThoroughfareType(token);
                pa.setMainAddress(sb.toString());
                return;
            }
            String type = SWE_ThoroughfareTypes.findAttachedType(token);
            if (!(type == null || StringUtilities.equalStrings((String)type, (String)"TORG") && token.length() - type.length() <= 1)) {
                char c;
                swt.removeFirst();
                if (sb.length() != 0) {
                    sb.append(' ');
                }
                sb.append(token.substring(0, token.length() - type.length()));
                pa.setPostThoroughfareType(type);
                int len = sb.length();
                if (len > 1 && NON_TOKENIZING_SEPARATORS.indexOf(c = sb.charAt(len - 1)) >= 0) {
                    sb.setLength(len - 1);
                }
                pa.setMainAddress(sb.toString());
                return;
            }
            if (StringUtilities.hasNumeric((String)token) && sb.length() > 0) {
                if (pa.getAddressNumber() == null) {
                    pa.setMainAddress(sb.toString());
                    break;
                }
                if (swt.size() > 1) {
                    swt.insert(swt.size(), pa.getAddressNumber());
                    pa.setAddressNumber((String)null);
                    pa.setMainAddress(sb.toString());
                    break;
                }
            }
            if (sb.length() != 0) {
                sb.append(' ');
            }
            sb.append(token);
            swt.removeFirst();
        }
        this.checkForSingleCharTypeAbbreviation(pa, sb, bIsDataConstruction);
        pa.setMainAddress(sb.toString());
    }

    protected void checkForSingleCharTypeAbbreviation(Address pa, StringBuilder sb, boolean bIsDataConstruction) {
        int len = sb.length();
        if (len > 3 && !bIsDataConstruction) {
            char c = sb.charAt(len - 1);
            if (c == 'g' || c == 'G') {
                pa.setPostThoroughfareType("GATAN");
                sb.deleteCharAt(len - 1);
            } else if (c == 'v' || c == 'V') {
                pa.setPostThoroughfareType("VAGEN");
                sb.deleteCharAt(len - 1);
            }
        } else if (len == 1 && !bIsDataConstruction) {
            char c = sb.charAt(0);
            if (c == 'g' || c == 'G') {
                pa.setPostThoroughfareType("GATAN");
                sb.deleteCharAt(0);
            } else if (c == 'v' || c == 'V') {
                pa.setPostThoroughfareType("VAGEN");
                sb.deleteCharAt(0);
            }
        }
    }

    private void handleUnits(Address parsed, StringWithTokens tokens) {
        for (int i = tokens.size() - 1; i > 0; --i) {
            int j;
            if (!SWE_UnitTypes.isUnitType(tokens.getToken(i))) continue;
            parsed.setUnitType(tokens.getToken(i));
            StringBuilder unitValue = new StringBuilder();
            for (j = i + 1; j < tokens.size() - 1; ++j) {
                unitValue.append(tokens.getToken(j));
                unitValue.append(' ');
            }
            unitValue.append(tokens.getToken(j));
            parsed.setUnitValue(unitValue.toString());
            for (int k = i - 1; k < tokens.size(); ++k) {
                tokens.removeLast();
            }
            return;
        }
    }
}

