/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.SWE.parser;

import com.mapinfo.mapmarker.utils.StringUtilities;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;

public class SWE_ThoroughfareTypes {
    private static Properties m_streetTypes = null;
    private static HashMap<String, KeyInfo> m_keys = new HashMap();
    private static List<String> m_sortedKeys;

    public static String lookupProperName(String key) {
        if (key == null) {
            return null;
        }
        KeyInfo o = m_keys.get(key);
        if (o == null && (o = m_keys.get(key = key.toUpperCase())) == null) {
            return null;
        }
        return o.getProperTypeName();
    }

    public static String lookupPreferredName(String key) {
        if (key == null) {
            return null;
        }
        KeyInfo o = m_keys.get(key);
        if (o == null && (o = m_keys.get(key = key.toUpperCase())) == null) {
            return null;
        }
        return o.getPreferredTypeName();
    }

    public static boolean isStreetType(String aTerm) {
        boolean temp = false;
        temp = m_keys.containsKey(aTerm);
        if (!temp) {
            temp = m_keys.containsKey(aTerm.toUpperCase());
        }
        return temp;
    }

    public static Set<String> getAllStreetTypes() {
        return m_keys.keySet();
    }

    public static String findAttachedType(String possibleStreet) {
        if (StringUtilities.isEmpty((String)possibleStreet)) {
            return null;
        }
        String upper = possibleStreet.toUpperCase();
        for (String type : m_sortedKeys) {
            if (!upper.endsWith(type)) continue;
            return possibleStreet.substring(possibleStreet.length() - type.length());
        }
        return null;
    }

    static {
        try {
            if (m_streetTypes == null) {
                m_streetTypes = new Properties();
                m_streetTypes.load(SWE_ThoroughfareTypes.class.getResourceAsStream("SWE_ThoroughfareTypes.properties"));
                Enumeration<?> e = m_streetTypes.propertyNames();
                while (e.hasMoreElements()) {
                    KeyInfo key = new KeyInfo();
                    String type = (String)e.nextElement();
                    key.loadKey(m_streetTypes, type);
                    m_keys.put(type.toUpperCase(), key);
                }
            }
        }
        catch (Throwable T) {
            throw new RuntimeException("Unable to load required files for SWE_Parser.");
        }
        Object[] keyList = m_keys.keySet().toArray();
        Arrays.sort(keyList, new KeyComparator());
        ArrayList<String> tmp = new ArrayList<String>(keyList.length);
        for (Object key : keyList) {
            tmp.add((String)key);
        }
        m_sortedKeys = Collections.unmodifiableList(tmp);
    }

    protected static class KeyComparator
    implements Comparator<Object> {
        protected KeyComparator() {
        }

        @Override
        public int compare(Object first, Object second) {
            int secondLen;
            int firstLen = ((String)first).length();
            if (firstLen == (secondLen = ((String)second).length())) {
                return 0;
            }
            if (firstLen > secondLen) {
                return -1;
            }
            return 1;
        }
    }

    static class KeyInfo {
        private String m_type = "";
        private String m_preferredType = "";
        private String m_properName = "";
        private boolean m_canStart = false;
        private boolean m_canEnd = false;

        KeyInfo() {
        }

        public String getTypeName() {
            return this.m_type;
        }

        public String getPreferredTypeName() {
            return this.m_preferredType;
        }

        public String getProperTypeName() {
            return this.m_properName;
        }

        public boolean canStart() {
            return this.m_canStart;
        }

        public boolean canEnd() {
            return this.m_canEnd;
        }

        public void loadKey(Properties p, String k) {
            String val = p.getProperty(k);
            StringTokenizer tokens = new StringTokenizer(val, ",");
            this.m_preferredType = tokens.nextToken();
            this.m_properName = tokens.nextToken();
            this.m_canStart = Boolean.valueOf(tokens.nextToken());
            this.m_canEnd = Boolean.valueOf(tokens.nextToken());
        }
    }
}

