/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.SWE.postal;

import com.mapinfo.mapmarker.DictionaryUsagePreference;
import com.mapinfo.mapmarker.IConstraints;
import com.mapinfo.mapmarker.common.Address;
import com.mapinfo.mapmarker.common.FieldScores;
import com.mapinfo.mapmarker.common.InternalMatcherConstants;
import com.mapinfo.mapmarker.common.InternalPostalCandidate;
import com.mapinfo.mapmarker.core.IRetrievedCandidates;
import com.mapinfo.mapmarker.core.matcher.IMatchPreferences;
import com.mapinfo.mapmarker.core.matcher.MatcherException;
import com.mapinfo.mapmarker.core.postal.IPostalMatcher;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

public final class SWE_PostalMatcher
implements IPostalMatcher {
    public void decideCloseMatch(IMatchPreferences preferences, InternalPostalCandidate candidate) {
        if (candidate.getPostCode1Score() < 0.9) {
            candidate.setCloseMatchOff();
        }
        if (candidate.getPostCode2Score() != 1.0 && preferences.getExactMatchPostalCode2()) {
            candidate.setCloseMatchOff();
        }
    }

    public List matchPostal(IConstraints constraints, Address parsedAddress, IRetrievedCandidates candidateInfo) throws MatcherException {
        List candidates = candidateInfo.getCandidates();
        ListIterator iterator = candidates.listIterator();
        if (iterator.hasNext()) {
            InternalMatcherConstants matchConstants = constraints.getHandler().getMatcherConstants().getPostalMatcherConstants();
            IMatchPreferences preferences = constraints.getHandler().getMatchConstraintsConverter().repackageGeocodingConstraints(constraints, parsedAddress);
            double maxScore = this.computeMaximumPostalScore(parsedAddress, matchConstants);
            while (iterator.hasNext()) {
                InternalPostalCandidate candidate = (InternalPostalCandidate)iterator.next();
                this.scoreCandidate(candidate, parsedAddress, matchConstants, maxScore);
                this.decideCloseMatch(preferences, candidate);
                if (constraints.getDictionaryUsage() == DictionaryUsagePreference.PREFER_UD && candidate.fromUserDictionary()) {
                    candidate.setDictionaryBonus();
                    continue;
                }
                if (constraints.getDictionaryUsage() != DictionaryUsagePreference.PREFER_AD || candidate.fromUserDictionary()) continue;
                candidate.setDictionaryBonus();
            }
            if (candidates != null) {
                Iterator candidateIterator = candidates.iterator();
                while (candidateIterator.hasNext()) {
                    InternalPostalCandidate candidate = (InternalPostalCandidate)candidateIterator.next();
                    if (candidate.isCloseMatch()) continue;
                    candidateIterator.remove();
                }
            }
        } else {
            return null;
        }
        this.orderCandidates(candidates);
        return candidates;
    }

    private double computeMaximumPostalScore(Address parsedAddress, InternalMatcherConstants constants) {
        double m_maximumAddressScore = 0.0;
        FieldScores matchedConstants = constants.getMatched();
        FieldScores blankConstants = constants.getBlank();
        m_maximumAddressScore = SWE_PostalMatcher.fieldExists(parsedAddress.getPostCode1()) ? (m_maximumAddressScore += matchedConstants.getPostalCode1()) : (m_maximumAddressScore += blankConstants.getPostalCode1());
        m_maximumAddressScore = SWE_PostalMatcher.fieldExists(parsedAddress.getPostCode2()) ? (m_maximumAddressScore += matchedConstants.getPostalCode2()) : (m_maximumAddressScore += blankConstants.getPostalCode2());
        return m_maximumAddressScore;
    }

    private static boolean fieldExists(String str) {
        return str != null && str.length() != 0;
    }

    public void scoreCandidate(InternalPostalCandidate candidate, Address parsedAddress, InternalMatcherConstants constants, double maximumScore) {
        candidate.scoreCandidate(parsedAddress);
        FieldScores matchedConstants = constants.getMatched();
        FieldScores blankConstants = constants.getBlank();
        double score = 0.0;
        score = SWE_PostalMatcher.fieldExists(parsedAddress.getPostCode1()) ? (score += matchedConstants.getPostalCode1() * candidate.getPostCode1Score()) : (score += blankConstants.getPostalCode1() * candidate.getPostCode1Score());
        score = SWE_PostalMatcher.fieldExists(parsedAddress.getPostCode2()) ? (score += matchedConstants.getPostalCode2() * candidate.getPostCode2Score()) : (score += blankConstants.getPostalCode2() * candidate.getPostCode2Score());
        candidate.setCombinedScore(score / maximumScore);
    }

    private void orderCandidates(List candidateList) {
        Collections.sort(candidateList);
        Collections.reverse(candidateList);
    }
}

