/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.XWG;

import com.mapinfo.mapmarker.CandidateAddress;
import com.mapinfo.mapmarker.MapMarkerInternalException;
import com.mapinfo.mapmarker.XWG.utils.AlternatesProviderFactory;
import com.mapinfo.mapmarker.utils.StringUtilities;
import com.mapinfo.mapmarker.utils.StringWithTokens;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class XWGUtils {
    private static Set<String> AUS_STATES = new HashSet<String>();
    private static List<String> Special_AN1_Countries = new ArrayList<String>();
    private static List<String> Special_AN2_Countries = new ArrayList<String>();

    public static void setFormattedLocationAdddress(CandidateAddress candidateAddress) {
        StringBuilder sb = new StringBuilder();
        XWGUtils.doAppend(sb, candidateAddress.getAreaName4());
        XWGUtils.doAppend(sb, candidateAddress.getAreaName3());
        XWGUtils.doAppend(sb, candidateAddress.getAreaName2());
        XWGUtils.doAppend(sb, candidateAddress.getAreaName1());
        XWGUtils.doAppend(sb, candidateAddress.getPostCode1());
        XWGUtils.doAppend(sb, candidateAddress.getCountry());
        candidateAddress.setFormattedLocationAddress(sb.toString());
    }

    protected static void doAppend(StringBuilder stringBuilder, String toAppend) {
        if (stringBuilder != null && !StringUtilities.isEmpty((String)toAppend)) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(toAppend);
        }
    }

    public static String replaceSTWithSANT(String input) {
        if (StringUtilities.isEmpty((String)input)) {
            return null;
        }
        boolean bUpdated = false;
        StringWithTokens swt = new StringWithTokens(input, " \t.,-");
        for (int i = 0; i < swt.size() && !bUpdated; ++i) {
            if (!"ST".equalsIgnoreCase(swt.getToken(i))) continue;
            swt.setToken(i, "SANT");
            bUpdated = true;
            break;
        }
        if (bUpdated) {
            return swt.toString();
        }
        return null;
    }

    public static String returnCountryIso3FromString(String ctryStr) {
        if (StringUtilities.isEmpty((String)ctryStr)) {
            return null;
        }
        try {
            return AlternatesProviderFactory.getCountryAlternatesProvider().getKeyForAlternate(ctryStr);
        }
        catch (MapMarkerInternalException ex) {
            throw new RuntimeException(ex.getCause());
        }
    }

    public static boolean containsAN1orAN2AbbrevAlt(String ctry, String alt) {
        if (StringUtilities.isEmpty((String)ctry) || StringUtilities.isEmpty((String)alt)) {
            return false;
        }
        String ctrystr = ctry.toString().trim().toUpperCase();
        try {
            Collection<String> alts = null;
            if (Special_AN1_Countries.contains(ctrystr)) {
                alts = AlternatesProviderFactory.getAreaName1AlternatesProvider(ctry).getAlternates(alt);
            } else if (Special_AN2_Countries.contains(ctrystr)) {
                alts = AlternatesProviderFactory.getAreaName2AlternatesProvider(ctry).getAlternates(alt);
            }
            if (!alts.isEmpty()) {
                return true;
            }
        }
        catch (MapMarkerInternalException ex) {
            throw new RuntimeException(ex.getCause());
        }
        return false;
    }

    public static String getAN1AltsForCustomCountry(String value, StringBuilder ctry) {
        String ctrystr;
        if (StringUtilities.isEmpty((String)value)) {
            return null;
        }
        if (ctry != null && ctry.length() > 0 && !Special_AN1_Countries.contains(ctrystr = ctry.toString().trim().toUpperCase())) {
            return null;
        }
        try {
            Collection<Object> alts = Collections.emptyList();
            Iterator<String> itr = Special_AN1_Countries.iterator();
            String lookup = value.trim().toUpperCase();
            String country = "";
            for (int i = 0; i < Special_AN1_Countries.size() && (alts = AlternatesProviderFactory.getAreaName1AlternatesProvider(country = Special_AN1_Countries.get(i)).getAlternates(lookup)).isEmpty(); ++i) {
            }
            if (!alts.isEmpty()) {
                if (ctry != null) {
                    ctry.append(country);
                }
                if (country.equals("USA") && lookup.length() == 2 || country.equals("AUS") && AUS_STATES.contains(lookup) || country.equals("CAN") && lookup.length() == 2 || country.equals("BRA") && lookup.length() > 2 || country.equals("DEU")) {
                    return lookup;
                }
                return (String)((List)alts).get(0);
            }
        }
        catch (MapMarkerInternalException ex) {
            throw new RuntimeException(ex.getCause());
        }
        return null;
    }

    static {
        AUS_STATES.add("WA");
        AUS_STATES.add("QLD");
        AUS_STATES.add("TAS");
        AUS_STATES.add("VIC");
        AUS_STATES.add("SA");
        AUS_STATES.add("NT");
        AUS_STATES.add("NSW");
        AUS_STATES.add("ACT");
        AUS_STATES = Collections.unmodifiableSet(AUS_STATES);
        Special_AN1_Countries.add("USA");
        Special_AN1_Countries.add("AUS");
        Special_AN1_Countries.add("CAN");
        Special_AN1_Countries.add("DEU");
        Special_AN1_Countries.add("BRA");
        Special_AN1_Countries.add("MEX");
        Special_AN2_Countries.add("ITA");
        Special_AN2_Countries.add("NLD");
        Special_AN1_Countries = Collections.unmodifiableList(Special_AN1_Countries);
        Special_AN2_Countries = Collections.unmodifiableList(Special_AN2_Countries);
    }
}

