/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.XWG;

import com.mapinfo.mapmarker.GeocodeResult;
import com.mapinfo.mapmarker.IConstraints;
import com.mapinfo.mapmarker.MMInternalFatalException;
import com.mapinfo.mapmarker.MapMarkerInternalException;
import com.mapinfo.mapmarker.XWG.XWG_InternalGeographicCandidate;
import com.mapinfo.mapmarker.core.address.IAddressGeocoder;
import com.mapinfo.mapmarker.core.address.ICoreAddressGeocoder;
import com.mapinfo.mapmarker.core.geographic.IGeographicGeocoder;
import java.util.List;
import java.util.ResourceBundle;

public class XWG_FallbackGeocoder
implements IAddressGeocoder {
    public GeocodeResult geocode(IConstraints preferences, ResourceBundle bundle) throws MMInternalFatalException, MapMarkerInternalException {
        if (preferences == null) {
            return new GeocodeResult();
        }
        boolean bGeoFallback = preferences.isFallbackToGeographic();
        boolean bPostalFallback = preferences.isFallbackToPostal();
        GeocodeResult result = null;
        if (bGeoFallback && bPostalFallback) {
            result = this.handleDoubleFallback(preferences);
        } else if (bGeoFallback) {
            result = this.handleGeographicFallback(preferences);
        } else if (bPostalFallback) {
            result = this.handlePostalFallback(preferences);
        }
        if (result == null) {
            return new GeocodeResult();
        }
        return result;
    }

    protected GeocodeResult handleDoubleFallback(IConstraints preferences) throws MapMarkerInternalException, MMInternalFatalException {
        XWG_InternalGeographicCandidate cand;
        int precision;
        GeocodeResult geoGR = this.handleGeographicFallback(preferences);
        List geoCandidates = preferences.getHandler().getMatchResults();
        if (geoGR != null && geoGR.getNumberCloseCandidates() > 0 && (precision = (cand = (XWG_InternalGeographicCandidate)((Object)geoCandidates.get(0))).getPrecision()) >= 10) {
            return geoGR;
        }
        GeocodeResult postalGR = this.handlePostalFallback(preferences);
        if (postalGR != null && postalGR.getNumberCloseCandidates() > 0) {
            return postalGR;
        }
        preferences.getHandler().setMatchResults(geoCandidates);
        preferences.getHandler().setGeocodeResult(geoGR);
        return geoGR;
    }

    protected GeocodeResult handlePostalFallback(IConstraints preferences) throws MapMarkerInternalException, MMInternalFatalException {
        GeocodeResult fallbackResult = preferences.getHandler().getPostalGeocoder().geocodePostal(preferences);
        if (fallbackResult.getNumberCloseCandidates() == 0) {
            preferences.getHandler().setMatchResults(null);
            return null;
        }
        ((ICoreAddressGeocoder)preferences.getHandler()).setPostalFallbackOccured(true);
        return fallbackResult;
    }

    protected GeocodeResult handleGeographicFallback(IConstraints constraints) throws MapMarkerInternalException, MMInternalFatalException {
        IGeographicGeocoder geo = constraints.getHandler().getGeographicGeocoder();
        if (geo == null) {
            return null;
        }
        GeocodeResult fallbackResult = geo.geocodeGeographic(constraints);
        if (fallbackResult.getNumberCloseCandidates() == 0) {
            constraints.getHandler().setMatchResults(null);
            return null;
        }
        ((ICoreAddressGeocoder)constraints.getHandler()).setGeoFallbackOccured(true);
        return fallbackResult;
    }
}

