/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.XWG;

import com.mapinfo.mapmarker.GeocodeResult;
import com.mapinfo.mapmarker.IConstraints;
import com.mapinfo.mapmarker.IHandler;
import com.mapinfo.mapmarker.MMInternalFatalException;
import com.mapinfo.mapmarker.MapMarkerInternalException;
import com.mapinfo.mapmarker.XWG.XWGUtils;
import com.mapinfo.mapmarker.XWG.XWG_Constraints;
import com.mapinfo.mapmarker.XWG.XWG_InternalGeographicCandidate;
import com.mapinfo.mapmarker.common.Address;
import com.mapinfo.mapmarker.common.AddressImpl;
import com.mapinfo.mapmarker.common.ICandidate;
import com.mapinfo.mapmarker.core.CoreHandler;
import com.mapinfo.mapmarker.core.address.ICoreAddressGeocoder;
import com.mapinfo.mapmarker.core.geographic.CoreGeographicGeocoder;
import com.mapinfo.mapmarker.core.geographic.IGeographicGeocoder;
import com.mapinfo.mapmarker.utils.ISO3166;
import com.mapinfo.mapmarker.utils.StringUtilities;
import com.mapinfo.mapmarker.utils.StringWithTokens;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class XWG_GeographicGeocoder
implements IGeographicGeocoder {
    CoreGeographicGeocoder m_coreGeocoder = new CoreGeographicGeocoder();
    protected boolean m_resetParsedAddress;
    protected Address m_savedParsedAddress = null;
    protected boolean m_resetSearchParsedAddress;
    protected Address m_savedSearchParsedAddress = null;
    protected int retry = 0;
    Address m_originalParsedAddress;
    CoreHandler m_handler;
    private boolean m_originalMustMatchCountrySetting;

    public XWG_GeographicGeocoder(IHandler handler) {
        this.m_handler = (CoreHandler)handler;
    }

    public GeocodeResult geocodeGeographic(IConstraints constraints) throws MapMarkerInternalException, MMInternalFatalException {
        IHandler handler = constraints.getHandler();
        XWG_Constraints xwgCons = new XWG_Constraints(constraints);
        xwgCons.setUseCountryKeys(true);
        xwgCons.setUseStringKeys(true);
        GeocodeResult firstResult = this.m_coreGeocoder.geocodeGeographic((IConstraints)xwgCons);
        if (firstResult.getNumberCloseCandidates() < 1) {
            return this.handleRetries(firstResult, xwgCons);
        }
        XWG_InternalGeographicCandidate cand = (XWG_InternalGeographicCandidate)((Object)this.m_handler.getMatchResults().get(0));
        int precision = cand.getPrecision();
        Address input = this.m_handler.getInputAddress();
        if (!StringUtilities.isEmpty((String)input.getAreaName3()) && precision < 10) {
            return this.handleRetries(firstResult, xwgCons);
        }
        if (constraints.getHandler().getMatchResults() != null) {
            XWG_InternalGeographicCandidate candidate;
            Iterator unfilteredCandsIterator = constraints.getHandler().getMatchResults().iterator();
            while (unfilteredCandsIterator.hasNext() && (candidate = (XWG_InternalGeographicCandidate)((Object)unfilteredCandsIterator.next())).isCloseMatch()) {
                candidate.setIsInitialCloseMatch(true);
            }
        }
        List filteredCands = ((ICoreAddressGeocoder)handler).getGeographicCentroidFilter().filterGeographicCloseMatches(handler);
        this.countCandidates(filteredCands, firstResult);
        this.countCloseMatches(filteredCands, firstResult);
        handler.setGeocodeResult(firstResult);
        return firstResult;
    }

    protected GeocodeResult handleRetries(GeocodeResult orig, IConstraints constraints) throws MapMarkerInternalException, MMInternalFatalException {
        if (this.m_originalParsedAddress == null) {
            this.m_originalParsedAddress = new AddressImpl(this.m_handler.getParsedAddress());
            this.setSearchParsedAddress(this.m_originalParsedAddress);
            String inCity = this.m_originalParsedAddress.getAreaName3();
            if (!StringUtilities.isEmpty((String)inCity) && inCity.indexOf(44) >= 0) {
                StringWithTokens swt = new StringWithTokens(inCity, " .,\t");
                inCity = swt.toString();
                this.m_originalParsedAddress.setAreaName3(inCity);
            }
        }
        List res = this.m_handler.getMatchResults();
        ArrayList origResults = new ArrayList();
        if (res != null) {
            origResults.addAll(res);
        }
        boolean tryMoreCases = true;
        List interimResults = new ArrayList();
        if (!constraints.isReturnCloseCandidatesOnly()) {
            interimResults.addAll(origResults);
        }
        while (tryMoreCases) {
            tryMoreCases = this.generateNewCase(constraints);
            if (!tryMoreCases) continue;
            GeocodeResult nextResult = this.m_coreGeocoder.geocodeGeographic(constraints);
            if (nextResult != null && nextResult.getNumberCandidates() > 0 && !constraints.isReturnCloseCandidatesOnly()) {
                res = this.m_handler.getMatchResults();
                interimResults = this.udpateInterimResults(interimResults, constraints, this.m_handler.getMatchResults());
                if (nextResult.getNumberCloseCandidates() <= 0) continue;
                return nextResult;
            }
            if (nextResult == null || nextResult.getNumberCloseCandidates() <= 0) continue;
            return nextResult;
        }
        if (!interimResults.isEmpty()) {
            this.m_handler.setMatchResults(interimResults);
            orig.setNumberCandidates(interimResults.size());
            int numClose = 0;
            for (int i = 0; i < interimResults.size() && ((XWG_InternalGeographicCandidate)((Object)interimResults.get(i))).isCloseMatch(); ++i) {
                ++numClose;
            }
            orig.setNumberCloseCandidates(numClose);
        } else {
            this.m_handler.setMatchResults(origResults);
        }
        this.m_handler.setGeocodeResult(orig);
        return orig;
    }

    public void setSearchParsedAddress(Address pa) {
        this.m_handler.setSearchParsedAddress(pa);
    }

    public void setParsedAddress(Address pa) {
        this.m_handler.setParsedAddress(pa);
    }

    protected List udpateInterimResults(List interimResults, IConstraints constraints, List additionalResults) {
        boolean bInterimWasEmpty = interimResults.isEmpty();
        int maxToKeep = constraints.getMaxCandidates();
        if (maxToKeep < 0) {
            maxToKeep = 10;
        }
        for (int i = 0; i < additionalResults.size() && i < maxToKeep; ++i) {
            XWG_InternalGeographicCandidate candidate = (XWG_InternalGeographicCandidate)((Object)additionalResults.get(i));
            interimResults.add(candidate);
        }
        if (bInterimWasEmpty) {
            return interimResults;
        }
        Collections.sort(interimResults);
        Collections.reverse(interimResults);
        return this.reduceToUniqueCandidates(interimResults, maxToKeep);
    }

    protected List reduceToUniqueCandidates(List<XWG_InternalGeographicCandidate> interimResults, int maxToKeep) {
        if (interimResults.isEmpty()) {
            return interimResults;
        }
        ArrayList<XWG_InternalGeographicCandidate> returnList = new ArrayList<XWG_InternalGeographicCandidate>(maxToKeep);
        returnList.add(interimResults.get(0));
        for (int candidateIdx = 1; candidateIdx < interimResults.size() && returnList.size() != maxToKeep; ++candidateIdx) {
            XWG_InternalGeographicCandidate candidate = interimResults.get(candidateIdx);
            long currentRecordID = candidate.getRecordID();
            boolean okToAdd = true;
            for (int returCandIdx = 0; returCandIdx < returnList.size(); ++returCandIdx) {
                XWG_InternalGeographicCandidate previousCandidate = (XWG_InternalGeographicCandidate)((Object)returnList.get(returCandIdx));
                if (previousCandidate.getRecordID() != currentRecordID) continue;
                okToAdd = false;
                break;
            }
            if (!okToAdd) continue;
            returnList.add(candidate);
        }
        return returnList;
    }

    public boolean generateNewCase(IConstraints constraints) throws MapMarkerInternalException {
        boolean tryAgain;
        XWG_Constraints xwg_constraints = (XWG_Constraints)constraints;
        if (this.m_resetParsedAddress) {
            this.setParsedAddress(this.m_savedParsedAddress);
            this.m_resetParsedAddress = false;
        }
        if (this.m_resetSearchParsedAddress) {
            this.setSearchParsedAddress(this.m_savedSearchParsedAddress);
            this.m_resetSearchParsedAddress = false;
        }
        if (this.retry == 0) {
            this.m_originalMustMatchCountrySetting = constraints.isMustMatchCountry();
        } else {
            constraints.setMustMatchCountry(this.m_originalMustMatchCountrySetting);
        }
        xwg_constraints.removeCustomObject("KEY_BUILD_ALL_GEOINFO_KEYS");
        xwg_constraints.removeCustomObject("KEY_ALTERNATE_SOUNDEX_CODES");
        xwg_constraints.removeCustomObject("KEY_SWAPPED_INPUT_AN1_AN3");
        xwg_constraints.removeCustomObject("KEY_SWAPPED_INPUT_AN3_AN4");
        boolean bIsStringKeys = xwg_constraints.useStringKeys();
        Address pa = this.m_handler.getParsedAddress();
        Address spa = this.m_handler.getSearchParsedAddress();
        String inCity = pa.getAreaName3();
        switch (this.retry) {
            case 0: {
                int lastSpace;
                int firstSpace;
                ++this.retry;
                if (inCity != null && inCity.indexOf(39) >= 0) {
                    xwg_constraints.setUseStringKeys(false);
                    tryAgain = true;
                    break;
                }
                if (bIsStringKeys && inCity != null && StringUtilities.isEmpty((String)pa.getAreaName1()) && (firstSpace = inCity.indexOf(32)) > 0 && (firstSpace != (lastSpace = inCity.lastIndexOf(32)) || firstSpace > 2 || !inCity.startsWith("ST"))) {
                    String newCity = inCity.substring(0, lastSpace);
                    String newAn1 = inCity.substring(lastSpace + 1);
                    this.m_savedSearchParsedAddress = new AddressImpl(spa);
                    spa.setAreaName3(newCity);
                    spa.setAreaName1(newAn1);
                    spa.setGenericField3(newCity);
                    this.m_resetSearchParsedAddress = true;
                    this.m_savedParsedAddress = new AddressImpl(pa);
                    pa.setAreaName3(newCity);
                    pa.setAreaName1(newAn1);
                    pa.setGenericField3(newCity);
                    pa.setGenericField1(newAn1);
                    this.m_resetParsedAddress = true;
                    tryAgain = true;
                    break;
                }
            }
            case 1: {
                ++this.retry;
                if (xwg_constraints.useCountryKeys() && !StringUtilities.isEmpty((String)pa.getCountry())) {
                    if (!xwg_constraints.isMustMatchCountry()) {
                        this.m_savedParsedAddress = new AddressImpl(pa);
                        this.m_savedSearchParsedAddress = new AddressImpl(spa);
                        this.m_resetSearchParsedAddress = true;
                        pa.setCountry(null);
                        spa.setCountry(null);
                        this.m_resetParsedAddress = true;
                        tryAgain = true;
                        break;
                    }
                    ISO3166 iso3166 = null;
                    String country = pa.getCountry();
                    if (country.length() == 2) {
                        iso3166 = ISO3166.findCountryByISO2((String)country);
                    }
                    if (iso3166 == null && country.length() != 3) {
                        iso3166 = ISO3166.findCountryByName((String)country);
                    }
                    if (iso3166 != null) {
                        this.m_savedParsedAddress = new AddressImpl(pa);
                        this.m_savedSearchParsedAddress = new AddressImpl(spa);
                        this.m_resetSearchParsedAddress = true;
                        spa.setCountry(iso3166.getISO3Country());
                        pa.setCountry(iso3166.getISO3Country());
                        this.m_resetParsedAddress = true;
                        tryAgain = true;
                        break;
                    }
                }
            }
            case 2: {
                int lastSpace;
                int firstSpace;
                ++this.retry;
                if (inCity != null && StringUtilities.isEmpty((String)pa.getAreaName1()) && (firstSpace = inCity.indexOf(32)) > 0 && StringUtilities.equalStringsIgnoreCase((String)inCity, (String)pa.getGenericField3()) && (firstSpace != (lastSpace = inCity.lastIndexOf(32)) || !inCity.startsWith("ST") || firstSpace > 2)) {
                    String newAn1;
                    String newCity;
                    int lastTokenLen = inCity.length() - (lastSpace + 1);
                    if (firstSpace > lastTokenLen) {
                        newCity = inCity.substring(0, lastSpace);
                        newAn1 = inCity.substring(lastSpace + 1);
                    } else {
                        newCity = inCity.substring(firstSpace + 1);
                        newAn1 = inCity.substring(0, firstSpace);
                    }
                    this.m_savedSearchParsedAddress = new AddressImpl(spa);
                    spa.setAreaName3(newCity);
                    spa.setAreaName1(newAn1);
                    spa.setGenericField3(newCity);
                    this.m_resetSearchParsedAddress = true;
                    this.m_savedParsedAddress = new AddressImpl(pa);
                    pa.setAreaName3(newCity);
                    pa.setAreaName1(newAn1);
                    pa.setGenericField3(newCity);
                    pa.setGenericField1(newAn1);
                    this.m_resetParsedAddress = true;
                    tryAgain = true;
                    break;
                }
            }
            case 3: {
                ++this.retry;
                Iterator<String> endTokens = this.grabEndTokens(inCity, 2);
                if (endTokens != null) {
                    String newCity = endTokens.next();
                    this.m_savedSearchParsedAddress = new AddressImpl(spa);
                    spa.setAreaName3(newCity);
                    this.m_resetSearchParsedAddress = true;
                    this.m_savedParsedAddress = new AddressImpl(pa);
                    pa.setAreaName3(newCity);
                    this.m_resetParsedAddress = true;
                    if (!xwg_constraints.isSingleLineInput() && StringUtilities.isEmpty((String)pa.getAreaName1()) && StringUtilities.isEmpty((String)pa.getAreaName2())) {
                        String newArea = endTokens.next();
                        pa.setAreaName1(newArea);
                        spa.setAreaName1(newArea);
                    }
                    tryAgain = true;
                    break;
                }
            }
            case 4: {
                ++this.retry;
                Iterator<String> startTokens = this.grabStartTokens(inCity, 2);
                if (startTokens != null) {
                    String newCity = startTokens.next();
                    this.m_savedSearchParsedAddress = new AddressImpl(spa);
                    spa.setAreaName3(newCity);
                    this.m_resetSearchParsedAddress = true;
                    this.m_savedParsedAddress = new AddressImpl(pa);
                    pa.setAreaName3(newCity);
                    this.m_resetParsedAddress = true;
                    tryAgain = true;
                    break;
                }
            }
            case 5: {
                ++this.retry;
                Iterator<String> startTokens = this.grabStartTokens(inCity, 1);
                if (startTokens != null) {
                    String newCity = startTokens.next();
                    this.m_savedSearchParsedAddress = new AddressImpl(spa);
                    spa.setAreaName3(newCity);
                    this.m_resetSearchParsedAddress = true;
                    this.m_savedParsedAddress = new AddressImpl(pa);
                    pa.setAreaName3(newCity);
                    this.m_resetParsedAddress = true;
                    if (StringUtilities.isEmpty((String)pa.getAreaName1()) && StringUtilities.isEmpty((String)pa.getAreaName2())) {
                        String newArea = startTokens.next();
                        pa.setAreaName1(newArea);
                        spa.setAreaName1(newArea);
                    }
                    tryAgain = true;
                    break;
                }
            }
            case 6: {
                Iterator<String> endTokens;
                ++this.retry;
                if (StringUtilities.isEmpty((String)pa.getAreaName1()) && StringUtilities.isEmpty((String)pa.getAreaName2()) && (endTokens = this.grabEndTokens(inCity, 1)) != null) {
                    String newCity = endTokens.next();
                    this.m_savedSearchParsedAddress = new AddressImpl(spa);
                    spa.setAreaName3(newCity);
                    this.m_resetSearchParsedAddress = true;
                    this.m_savedParsedAddress = new AddressImpl(pa);
                    pa.setAreaName3(newCity);
                    this.m_resetParsedAddress = true;
                    tryAgain = true;
                    break;
                }
            }
            case 7: {
                String city;
                ++this.retry;
                if (!bIsStringKeys) {
                    city = XWGUtils.replaceSTWithSANT(pa.getAreaName3());
                    String locality = XWGUtils.replaceSTWithSANT(pa.getAreaName4());
                    if (city != null || locality != null) {
                        this.m_savedParsedAddress = new AddressImpl(pa);
                        this.m_savedSearchParsedAddress = new AddressImpl(spa);
                        if (city != null) {
                            pa.setAreaName3(city);
                            spa.setAreaName3(city);
                        }
                        if (locality != null) {
                            pa.setAreaName4(locality);
                            spa.setAreaName4(locality);
                        }
                        this.m_resetParsedAddress = true;
                        this.m_resetSearchParsedAddress = true;
                        tryAgain = true;
                        break;
                    }
                }
            }
            case 8: {
                String city;
                ++this.retry;
                if (!(constraints.isMustMatchArea3() || constraints.isMustMatchArea4() || StringUtilities.equalStrings((String)pa.getAreaName3(), (String)pa.getAreaName4()))) {
                    this.m_savedParsedAddress = new AddressImpl(pa);
                    this.m_savedSearchParsedAddress = new AddressImpl(spa);
                    city = pa.getAreaName3();
                    pa.setAreaName3(pa.getAreaName4());
                    spa.setAreaName3(pa.getAreaName4());
                    pa.setAreaName4(city);
                    spa.setAreaName4(city);
                    this.m_resetParsedAddress = true;
                    this.m_resetSearchParsedAddress = true;
                    constraints.setCustomObject((Object)"KEY_SWAPPED_INPUT_AN3_AN4", (Object)"TRUE");
                    tryAgain = true;
                    break;
                }
            }
            case 9: {
                ++this.retry;
                String an3 = pa.getAreaName3();
                String an1 = pa.getAreaName1();
                if (!StringUtilities.isEmpty((String)an3) && !StringUtilities.isEmpty((String)an1) && !StringUtilities.equalStrings((String)an1, (String)an3) && StringUtilities.isEmpty((String)this.m_handler.getInputAddress().getAreaName1()) && StringUtilities.isEmpty((String)this.m_handler.getInputAddress().getAreaName3())) {
                    this.m_savedSearchParsedAddress = new AddressImpl(spa);
                    this.m_savedParsedAddress = new AddressImpl(pa);
                    pa.setAreaName3(an1);
                    pa.setAreaName1(an3);
                    spa.setAreaName3(an1);
                    spa.setAreaName1(an3);
                    this.m_resetParsedAddress = true;
                    this.m_resetSearchParsedAddress = true;
                    constraints.setCustomObject((Object)"KEY_SWAPPED_INPUT_AN1_AN3", (Object)"TRUE");
                    tryAgain = true;
                    break;
                }
            }
            case 10: {
                ++this.retry;
                if (!(bIsStringKeys || StringUtilities.isEmpty((String)pa.getAreaName3()) || xwg_constraints.isMustMatchArea3())) {
                    constraints.setCustomObject((Object)"KEY_ALTERNATE_SOUNDEX_CODES", (Object)"TRUE");
                    constraints.setMustMatchCountry(true);
                    tryAgain = true;
                    break;
                }
            }
            case 11: {
                ++this.retry;
                if (!bIsStringKeys) {
                    xwg_constraints.setCustomString("KEY_BUILD_ALL_GEOINFO_KEYS", "true");
                    tryAgain = true;
                    break;
                }
            }
            case 12: {
                ++this.retry;
                if (!(!xwg_constraints.isMustMatchCountry() || StringUtilities.isEmpty((String)pa.getAreaName4()) || xwg_constraints.isMustMatchArea4() || StringUtilities.isEmpty((String)pa.getAreaName3()) && StringUtilities.isEmpty((String)pa.getAreaName2()) && StringUtilities.isEmpty((String)pa.getAreaName1()))) {
                    this.m_savedParsedAddress = new AddressImpl(pa);
                    this.m_savedSearchParsedAddress = new AddressImpl(spa);
                    pa.setAreaName4(null);
                    spa.setAreaName4(null);
                    this.m_resetParsedAddress = true;
                    this.m_resetSearchParsedAddress = true;
                    tryAgain = true;
                    break;
                }
            }
            case 13: {
                ++this.retry;
                if (!(bIsStringKeys || !xwg_constraints.isMustMatchCountry() || StringUtilities.isEmpty((String)pa.getAreaName3()) || xwg_constraints.isMustMatchArea4() || xwg_constraints.isMustMatchArea3() || StringUtilities.isEmpty((String)pa.getAreaName2()) && StringUtilities.isEmpty((String)pa.getAreaName1()))) {
                    this.m_savedParsedAddress = new AddressImpl(pa);
                    this.m_savedSearchParsedAddress = new AddressImpl(spa);
                    pa.setAreaName4(null);
                    pa.setAreaName3(null);
                    spa.setAreaName3(null);
                    spa.setAreaName4(null);
                    this.m_resetParsedAddress = true;
                    this.m_resetSearchParsedAddress = true;
                    tryAgain = true;
                    break;
                }
            }
            case 14: {
                ++this.retry;
                if (bIsStringKeys && xwg_constraints.useCountryKeys() && !xwg_constraints.isMustMatchCountry() && !StringUtilities.isEmpty((String)pa.getCountry())) {
                    xwg_constraints.setUseCountryKeys(false);
                    tryAgain = true;
                    break;
                }
            }
            case 15: {
                ++this.retry;
                if (!bIsStringKeys && !constraints.isMustMatchArea3() && StringUtilities.isEmpty((String)pa.getAreaName1()) && !StringUtilities.isEmpty((String)pa.getAreaName3())) {
                    this.m_savedParsedAddress = new AddressImpl(pa);
                    this.m_savedSearchParsedAddress = new AddressImpl(spa);
                    pa.setAreaName1(pa.getAreaName3());
                    pa.setGenericField1(pa.getGenericField3());
                    pa.setAreaName3(null);
                    pa.setGenericField3(null);
                    this.m_resetParsedAddress = true;
                    tryAgain = true;
                    break;
                }
            }
            case 16: {
                ++this.retry;
                if (bIsStringKeys) {
                    xwg_constraints.setUseStringKeys(false);
                    tryAgain = true;
                    this.retry = 0;
                    break;
                }
            }
            default: {
                tryAgain = false;
                this.setParsedAddress((Address)new AddressImpl(this.m_originalParsedAddress));
            }
        }
        return tryAgain;
    }

    protected Iterator<String> grabEndTokens(String inCity, int count) {
        if (inCity != null) {
            int lastSpace;
            int firstSpace = inCity.indexOf(32);
            if (firstSpace == (lastSpace = inCity.lastIndexOf(32)) && (inCity.startsWith("ST ") || inCity.startsWith("ST. "))) {
                return null;
            }
            if (firstSpace > 0) {
                int idx;
                ArrayList<String> values = new ArrayList<String>(2);
                if (lastSpace != firstSpace && count > 1 && (idx = inCity.lastIndexOf(32, lastSpace - 1)) >= firstSpace) {
                    values.add(inCity.substring(idx + 1));
                    values.add(inCity.substring(0, idx));
                    return values.iterator();
                }
                values.add(inCity.substring(lastSpace + 1));
                values.add(inCity.substring(0, lastSpace));
                return values.iterator();
            }
        }
        return null;
    }

    protected Iterator<String> grabStartTokens(String inCity, int count) {
        if (inCity != null) {
            int lastSpace;
            int firstSpace = inCity.indexOf(32);
            if (firstSpace == (lastSpace = inCity.lastIndexOf(32)) && (inCity.startsWith("ST ") || inCity.startsWith("ST. "))) {
                return null;
            }
            if (firstSpace > 0) {
                int idx;
                ArrayList<String> values = new ArrayList<String>(2);
                if (lastSpace != firstSpace && count > 1 && (idx = inCity.indexOf(32, firstSpace + 1)) <= lastSpace) {
                    values.add(inCity.substring(0, idx));
                    values.add(inCity.substring(idx + 1));
                    return values.iterator();
                }
                values.add(inCity.substring(0, firstSpace));
                values.add(inCity.substring(firstSpace + 1));
                return values.iterator();
            }
        }
        return null;
    }

    private void countCandidates(List candidateList, GeocodeResult geocodeResult) {
        if (candidateList == null || candidateList.isEmpty()) {
            return;
        }
        geocodeResult.setNumberCandidates(candidateList.size());
    }

    private void countCloseMatches(List candidateList, GeocodeResult geocodeResult) {
        ICandidate candidate;
        int closeMatchCount = 0;
        if (candidateList == null || candidateList.isEmpty()) {
            return;
        }
        Iterator candidateIterator = candidateList.iterator();
        while (candidateIterator.hasNext() && (candidate = (ICandidate)candidateIterator.next()).isCloseMatch()) {
            ++closeMatchCount;
        }
        geocodeResult.setNumberCloseCandidates(closeMatchCount);
    }
}

