/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.XWG.dp;

import com.mapinfo.mapmarker.MapMarkerInternalException;
import com.mapinfo.mapmarker.XWG.dp.XWG_IPostInfoDataSourceRecord;
import com.mapinfo.mapmarker.XWG.dp.binary.XWG_PostInfoRecord;
import com.mapinfo.mapmarker.XWG.utils.AlternatesProviderFactory;
import com.mapinfo.mapmarker.common.dp.DataSourceException;
import com.mapinfo.mapmarker.common.dp.IPostInfoDataSourceRecord;
import com.mapinfo.mapmarker.common.dp.PostInfoDataSourceRecordConvertorImpl;
import com.mapinfo.mapmarker.common.dp.binary.PostInfoRecord;
import com.mapinfo.mapmarker.common.dp.binary.index.MapMarkerIndexKey;
import com.mapinfo.mapmarker.common.dp.binary.index.MiStringIndexKey;
import com.mapinfo.mapmarker.utils.StringUtilities;
import java.util.Collection;
import java.util.Properties;

public class XWG_PostInfoDataSourceRecordConvertorImpl
extends PostInfoDataSourceRecordConvertorImpl {
    public XWG_PostInfoDataSourceRecordConvertorImpl(Properties dataProperties) {
        super(dataProperties);
    }

    protected PostInfoRecord makePostInfoRecordType() {
        return new XWG_PostInfoRecord();
    }

    protected PostInfoRecord makePostInfoRecord(IPostInfoDataSourceRecord srcRecIn) throws DataSourceException {
        XWG_PostInfoRecord record = (XWG_PostInfoRecord)super.makePostInfoRecord(srcRecIn);
        if (record != null) {
            XWG_IPostInfoDataSourceRecord xwgRecIn = (XWG_IPostInfoDataSourceRecord)srcRecIn;
            record.setCountry(xwgRecIn.getCountry().toUpperCase());
            try {
                Collection<String> alternates = AlternatesProviderFactory.getCountryAlternatesProvider().getAlternates(record.getCountry());
                if (!alternates.isEmpty()) {
                    String[] array = new String[alternates.size()];
                    record.setAlternateCountryArray(alternates.toArray(array));
                }
                if (!StringUtilities.isEmpty((String)record.getAreaName1())) {
                    record.setAreaName1(record.getAreaName1().toUpperCase());
                }
                if (!StringUtilities.isEmpty((String)record.getAreaName2())) {
                    record.setAreaName2(record.getAreaName2().toUpperCase());
                }
                if (!StringUtilities.isEmpty((String)record.getAreaName3())) {
                    record.setAreaName3(record.getAreaName3().toUpperCase());
                }
                if (!StringUtilities.isEmpty((String)record.getAreaName4())) {
                    record.setAreaName4(record.getAreaName4().toUpperCase());
                }
            }
            catch (MapMarkerInternalException MMIEx) {
                throw new DataSourceException(-1, (Throwable)MMIEx);
            }
        }
        return record;
    }

    protected MapMarkerIndexKey makePostInfoIndexKey(PostInfoRecord record) {
        XWG_PostInfoRecord rec = (XWG_PostInfoRecord)record;
        StringBuilder sb = new StringBuilder();
        String tmp = rec.getCountry();
        if (tmp != null) {
            sb.append(tmp);
        }
        if ((tmp = rec.getPostalCode1()) != null) {
            sb.append(tmp);
        }
        if ((tmp = rec.getAreaName1()) != null) {
            sb.append(tmp);
        }
        if ((tmp = rec.getAreaName2()) != null) {
            sb.append(tmp);
        }
        if ((tmp = rec.getAreaName3()) != null) {
            sb.append(tmp);
        }
        if ((tmp = rec.getAreaName4()) != null) {
            sb.append(tmp);
        }
        return new MiStringIndexKey(sb.toString().toUpperCase());
    }
}

