/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.XWG.dp.binary;

import com.mapinfo.mapmarker.XWG.dp.binary.index.XWG_MultiLevelNoCountrySoundexIndexFileConvertor;
import com.mapinfo.mapmarker.XWG.dp.binary.index.XWG_MultiLevelSoundexIndexFileConvertor;
import com.mapinfo.mapmarker.XWG.dp.binary.index.XWG_PostInfoIndexer;
import com.mapinfo.mapmarker.common.dp.binary.DataCreationException;
import com.mapinfo.mapmarker.common.dp.binary.DataCreationLogger;
import com.mapinfo.mapmarker.common.dp.binary.DataCreator;
import com.mapinfo.mapmarker.common.dp.binary.IDataProvider;
import com.mapinfo.mapmarker.utils.StringUtilities;
import java.io.File;
import java.util.HashSet;
import java.util.Properties;

public class XWG_DataCreator
extends DataCreator {
    private HashSet<String> filesToBeDeleted = new HashSet();
    private boolean bDelayDelete = false;

    protected XWG_DataCreator(boolean logInternalErrors) {
        super(logInternalErrors);
        this.m_dataProviderBaseClass = "_DataProvider";
    }

    protected void createGeoInfoIndexes(Properties processingProperties) throws DataCreationException {
        super.createGeoInfoIndexes(processingProperties);
        String geoInfoFileBaseName = processingProperties.getProperty("geoInfo_outputFile");
        String geoInfoPathAndBaseName = StringUtilities.appendToPath((String)this.m_dataProvider.getGeoInfoFilePath(), (String)geoInfoFileBaseName);
        this.deleteSingleFile(geoInfoPathAndBaseName + ".cdx");
        DataCreationLogger.getLogger().logStatus("Creating temporary country based geoInfo soundex index file.");
        DataCreationLogger.getLogger().logStatus("Finished creating temporary country based geoInfo soundex index file.");
        XWG_MultiLevelNoCountrySoundexIndexFileConvertor geoInfoSoundexConvertor = new XWG_MultiLevelNoCountrySoundexIndexFileConvertor(geoInfoPathAndBaseName + ".tsx", geoInfoPathAndBaseName + ".cdx");
        try {
            DataCreationLogger.getLogger().logStatus("*** ***Creating geoInfo no-country soundex index file.");
            geoInfoSoundexConvertor.convert();
            this.deleteFile(geoInfoPathAndBaseName + ".tsx");
            DataCreationLogger.getLogger().logStatus("Finished creating no-country soundex geoInfo index file.");
            this.doDelete();
        }
        catch (DataCreationException e) {
            throw new DataCreationException(400, (Throwable)e);
        }
    }

    protected void createPostInfoIndexes(Properties processingProperties) throws DataCreationException {
        String postInfoFileBaseName = processingProperties.getProperty("postInfo_outputFile");
        String postInfoFilePathAndBaseName = StringUtilities.appendToPath((String)this.m_dataProvider.getPostInfoFilePath(), (String)postInfoFileBaseName);
        if (postInfoFileBaseName == null || postInfoFileBaseName.length() == 0) {
            throw new DataCreationException(600);
        }
        XWG_PostInfoIndexer indexer = new XWG_PostInfoIndexer();
        this.deleteSingleFile(postInfoFilePathAndBaseName + ".tdx");
        if (indexer != null) {
            indexer.processPostInfoFile(postInfoFilePathAndBaseName);
            XWG_MultiLevelSoundexIndexFileConvertor convertor = new XWG_MultiLevelSoundexIndexFileConvertor(postInfoFilePathAndBaseName + ".tdx", postInfoFilePathAndBaseName + ".jdx");
            if (convertor != null) {
                try {
                    convertor.convert();
                    this.deleteFile(postInfoFilePathAndBaseName + ".tdx");
                }
                catch (DataCreationException e) {
                    throw new DataCreationException(600, (Throwable)e);
                }
            } else {
                this.deleteFile(postInfoFilePathAndBaseName + ".tdx");
            }
        }
        this.deleteSingleFile(postInfoFilePathAndBaseName + ".cdx");
        XWG_MultiLevelNoCountrySoundexIndexFileConvertor noCtryConvertor = new XWG_MultiLevelNoCountrySoundexIndexFileConvertor(postInfoFilePathAndBaseName + ".tdx", postInfoFilePathAndBaseName + ".cdx");
        try {
            DataCreationLogger.getLogger().logStatus("*** ***Creating postInfo no-country index file.");
            noCtryConvertor.convert();
            this.deleteFile(postInfoFilePathAndBaseName + ".tdx");
            DataCreationLogger.getLogger().logStatus("Finished creating no-country postInfo index file.");
            this.doDelete();
        }
        catch (DataCreationException e) {
            throw new DataCreationException(600, (Throwable)e);
        }
    }

    protected void createGeoInfo(IDataProvider provider) throws DataCreationException {
        this.bDelayDelete = true;
        provider.processGeoInfo(this.m_internalProcess);
    }

    protected void createPostInfo(IDataProvider provider) throws DataCreationException {
        this.bDelayDelete = true;
        provider.processPostInfo(this.m_internalProcess);
    }

    protected void deleteFile(String fileToDelete) throws DataCreationException {
        if (fileToDelete == null) {
            return;
        }
        if (this.bDelayDelete) {
            DataCreationLogger.getLogger().logInternalError("Delaying request to delete file: " + fileToDelete);
            this.filesToBeDeleted.add(fileToDelete);
            return;
        }
        DataCreationLogger.getLogger().logInternalError("Deleting file: " + fileToDelete);
        this.deleteSingleFile(fileToDelete);
    }

    protected void doDelete() throws DataCreationException {
        for (String fileToDelete : this.filesToBeDeleted) {
            DataCreationLogger.getLogger().logInternalError("Attempting delete file: " + fileToDelete);
            this.deleteSingleFile(fileToDelete);
        }
        this.filesToBeDeleted.clear();
    }

    private void deleteSingleFile(String fileToDelete) throws DataCreationException {
        File fileRef = new File(fileToDelete);
        if (fileRef.exists() && !fileRef.delete()) {
            DataCreationLogger.getLogger().logInternalError("Unable to remove file: " + fileToDelete);
            throw new DataCreationException(-1);
        }
    }

    public static void main(String[] args) {
        if (args.length != 1) {
            System.err.println("Usage: DataCreator <processing properties>");
            System.exit(1);
        }
        Properties processingProperties = DataCreator.loadPropertiesFile((String)args[0]);
        XWG_DataCreator creator = new XWG_DataCreator(true);
        try {
            creator.runProcess(processingProperties);
        }
        catch (DataCreationException DCEx) {
            System.err.println("Unable to create data.");
            DataCreationLogger.getLogger().logError("Unable to create data.");
            System.err.println("ERROR: " + DCEx.getMessage());
            DataCreationLogger.getLogger().logInternalError("ERROR: " + DCEx.getMessage());
            DCEx.printStackTrace(System.err);
            DataCreationLogger.getLogger().logStackTrace((Throwable)DCEx);
            System.exit(-1);
        }
        catch (Throwable t) {
            System.err.println("Unable to create data.");
            DataCreationLogger.getLogger().logError("Unable to create data.");
            System.err.println("ERROR: " + t.getMessage());
            DataCreationLogger.getLogger().logInternalError("ERROR: " + t.getMessage());
            t.printStackTrace(System.err);
            DataCreationLogger.getLogger().logStackTrace(t);
            System.exit(-2);
        }
    }
}

