/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.XWG.dp.binary;

import com.mapinfo.mapmarker.IConstraints;
import com.mapinfo.mapmarker.XWG.XWGSoundex;
import com.mapinfo.mapmarker.XWG.XWG_DictionaryGeographyInfo;
import com.mapinfo.mapmarker.XWG.XWG_IConstraints;
import com.mapinfo.mapmarker.XWG.dp.binary.XWG_GeoBase;
import com.mapinfo.mapmarker.XWG.dp.binary.XWG_GeoInfoFetcherImpl;
import com.mapinfo.mapmarker.XWG.dp.binary.XWG_PostInfoFetcherImpl;
import com.mapinfo.mapmarker.XWG.dp.binary.XWG_SoundexKey;
import com.mapinfo.mapmarker.common.Address;
import com.mapinfo.mapmarker.common.IDictionaryGeographyInfo;
import com.mapinfo.mapmarker.common.ISoundexKey;
import com.mapinfo.mapmarker.common.Soundex;
import com.mapinfo.mapmarker.common.dp.DataAccessException;
import com.mapinfo.mapmarker.common.dp.binary.AbstractDataDictionary;
import com.mapinfo.mapmarker.common.dp.binary.DataDictionaryIntializationException;
import com.mapinfo.mapmarker.common.dp.binary.IGeoBase;
import com.mapinfo.mapmarker.common.dp.binary.IGeoInfoFetcher;
import com.mapinfo.mapmarker.common.dp.binary.IPostInfoFetcher;
import com.mapinfo.mapmarker.common.dp.binary.IPostalBase;
import com.mapinfo.mapmarker.common.dp.binary.MMJGeo2SacData;
import com.mapinfo.mapmarker.common.dp.binary.StandardPostalBase;
import com.mapinfo.mapmarker.common.dp.binary.index.MapMarkerIndexKey;
import com.mapinfo.mapmarker.utils.ISO3166;
import com.mapinfo.mapmarker.utils.MappedSeekableDataInputStream;
import com.mapinfo.mapmarker.utils.StringUtilities;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;

public class XWG_DataDictionary
extends AbstractDataDictionary {
    private static final Soundex m_soundex = new XWGSoundex();

    public XWG_DataDictionary(int dictionaryNumber, Properties dataManagerSettings) throws DataDictionaryIntializationException {
        super(dictionaryNumber, dataManagerSettings);
    }

    public void close() throws DataAccessException {
        super.close();
        MappedSeekableDataInputStream.releaseAllStreams();
    }

    protected Soundex getSoundex() {
        return m_soundex;
    }

    protected IGeoInfoFetcher initGeoInfoFetcher() throws DataDictionaryIntializationException {
        XWG_GeoInfoFetcherImpl fetcher = null;
        if (!this.isUserDictionary()) {
            fetcher = new XWG_GeoInfoFetcherImpl(this.getDictionaryPath(), this.getDataManagerSettings(), null);
        }
        return fetcher;
    }

    protected IPostInfoFetcher initPostInfoFetcher() throws DataDictionaryIntializationException {
        XWG_PostInfoFetcherImpl fetcher = null;
        if (!this.isUserDictionary()) {
            fetcher = new XWG_PostInfoFetcherImpl(this.getDictionaryPath(), this.getDataManagerSettings(), null);
        }
        return fetcher;
    }

    protected MMJGeo2SacData initGeo2SacData() throws DataDictionaryIntializationException {
        return null;
    }

    protected boolean isGeo2SacRequired() {
        return false;
    }

    protected boolean isPost2SacRequired() {
        return false;
    }

    public IGeoBase[] getGeoBases(Address addr, IConstraints preferences) {
        ISO3166 iso;
        boolean useStringKeys = ((XWG_IConstraints)preferences).useStringKeys();
        String country = addr.getCountry();
        int countryIsoNum = -1;
        if (!StringUtilities.isEmpty((String)country) && ((XWG_IConstraints)preferences).useCountryKeys() && (iso = ISO3166.findCountryByISO3((String)country)) != null) {
            try {
                countryIsoNum = Integer.valueOf(iso.getCountryNumber());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        HashSet<IGeoBase> bases = new HashSet<IGeoBase>();
        IGeoBase base = this.makeGeoBase(addr.getAreaName3(), useStringKeys, countryIsoNum);
        if (base != null) {
            bases.add(base);
        }
        if (Boolean.parseBoolean(preferences.getCustomString("KEY_GEOBASE_FOR_AREA4")) && (base = this.makeGeoBase(addr.getAreaName4(), useStringKeys, countryIsoNum)) != null) {
            bases.add(base);
        }
        if (Boolean.parseBoolean(preferences.getCustomString("KEY_GEOBASE_FOR_AREA2")) && (base = this.makeGeoBase(addr.getAreaName2(), useStringKeys, countryIsoNum)) != null) {
            bases.add(base);
        }
        return bases.toArray(new IGeoBase[bases.size()]);
    }

    public IGeoBase[] getAlternateGeoBases(Address pa, IConstraints preferences, int i) {
        IGeoBase[] bases = null;
        switch (i) {
            case 0: {
                if (!Boolean.parseBoolean(preferences.getCustomString("KEY_GEOBASE_FOR_AREA4"))) {
                    preferences.setCustomString("KEY_GEOBASE_FOR_AREA4", "TRUE");
                    bases = this.getGeoBases(pa, preferences);
                    preferences.removeCustomObject((Object)"KEY_GEOBASE_FOR_AREA4");
                    if (bases != null && bases.length > 0) break;
                }
            }
            case 1: {
                if (Boolean.parseBoolean(preferences.getCustomString("KEY_GEOBASE_FOR_AREA2"))) break;
                preferences.setCustomString("KEY_GEOBASE_FOR_AREA2", "TRUE");
                bases = this.getGeoBases(pa, preferences);
                preferences.removeCustomObject((Object)"KEY_GEOBASE_FOR_AREA2");
                if (bases != null && bases.length <= 0) break;
            }
        }
        return bases;
    }

    private IGeoBase makeGeoBase(String areaName, boolean useStringKey, int countryIsoNum) {
        if (StringUtilities.isEmpty((String)areaName)) {
            return null;
        }
        ISoundexKey key = useStringKey ? XWGSoundex.getStringKey(areaName) : m_soundex.getSoundex(areaName);
        if (key != null) {
            return new XWG_GeoBase((XWG_SoundexKey)key, countryIsoNum);
        }
        return null;
    }

    protected IPostalBase[] getPostalBases(Address addr, IConstraints constraints) {
        String postcode = addr.getPostCode1();
        if (postcode == null || postcode.length() < 3) {
            return null;
        }
        return new IPostalBase[]{new StandardPostalBase(postcode.substring(0, 3))};
    }

    public MapMarkerIndexKey[] makeBrowseBases(Address addr, IConstraints constraints) {
        return null;
    }

    public ISoundexKey[] makeStreetBases(Address addr, IConstraints constraints) {
        return null;
    }

    public IDictionaryGeographyInfo getDictionaryGeographyInfo() {
        XWG_DictionaryGeographyInfo info = new XWG_DictionaryGeographyInfo();
        info.setDictionaryPath(this.getDictionaryPath());
        info.setIsUserDictionary(this.isUserDictionary());
        info.setDictionaryNumber(this.getDictionaryNumber() + 1);
        return info;
    }

    public int[] getSacList(Address addr, IConstraints constraints, boolean bDoIntersectionOnly) {
        return null;
    }

    protected List getGeoSacs(Address addr, IConstraints constraints) {
        return Collections.EMPTY_LIST;
    }

    protected boolean isSac2FnRequired() {
        return false;
    }
}

