/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.XWG.dp.binary;

import com.mapinfo.mapmarker.EngineThreadingModel;
import com.mapinfo.mapmarker.IConstraints;
import com.mapinfo.mapmarker.XWG.XWGThreadingModel;
import com.mapinfo.mapmarker.XWG.dp.binary.XWG_DataDictionary;
import com.mapinfo.mapmarker.common.Address;
import com.mapinfo.mapmarker.common.CountryGeographyInfoImpl;
import com.mapinfo.mapmarker.common.ICountryGeographyInfo;
import com.mapinfo.mapmarker.common.IDictionarySearchOrder;
import com.mapinfo.mapmarker.common.InternalGeographicCandidate;
import com.mapinfo.mapmarker.common.InternalPostalCandidate;
import com.mapinfo.mapmarker.common.ScoringAddress;
import com.mapinfo.mapmarker.common.dp.DataAccessException;
import com.mapinfo.mapmarker.common.dp.DataManagerSettingsProvider;
import com.mapinfo.mapmarker.common.dp.FatalDataAccessException;
import com.mapinfo.mapmarker.common.dp.binary.AbstractDataManager;
import com.mapinfo.mapmarker.common.dp.binary.DataDictionaryIntializationException;
import com.mapinfo.mapmarker.common.dp.binary.IDataDictionary;
import com.mapinfo.mapmarker.common.dp.binary.IGeoInfoFetcher;
import com.mapinfo.mapmarker.common.dp.binary.IPostInfoFetcher;
import com.mapinfo.mapmarker.common.dp.binary.IPostalBase;
import com.mapinfo.mapmarker.common.dp.binary.LocalizationException;
import com.mapinfo.mapmarker.common.dp.binary.MMJEDataCorruptedException;
import com.mapinfo.mapmarker.common.dp.binary.MMJEDataManagerInitializationException;
import com.mapinfo.mapmarker.common.dp.binary.StandardPostalBase;
import com.mapinfo.mapmarker.common.dp.binary.index.PostInfoIndexKey;
import com.mapinfo.mapmarker.common.dp.binary.index.StandardPostInfoIndexKey;
import com.mapinfo.mapmarker.core.CoreRetrievedCandidates;
import com.mapinfo.mapmarker.core.IRetrievedCandidates;
import com.mapinfo.mapmarker.licensing.LicenseFilter;
import com.mapinfo.mapmarker.utils.MMJLog;
import com.mapinfo.mapmarker.utils.StringUtilities;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

public final class XWG_DataManager
extends AbstractDataManager {
    private static Throwable m_SetupException;
    private static final String LSTRING_FILE = "com.mapinfo.mapmarker.common.dp.binary.DataManagerMessageStrings";
    private static final String ERROR_LOAD_DICT_MSG = "exception.error.reading.dictionaries";
    public static final String KEY_GEOBASE_FOR_AREA1 = "KEY_GEOBASE_FOR_AREA1";
    public static final String KEY_GEOBASE_FOR_AREA2 = "KEY_GEOBASE_FOR_AREA2";
    public static final String KEY_GEOBASE_FOR_AREA3 = "KEY_GEOBASE_FOR_AREA3";
    public static final String KEY_GEOBASE_FOR_AREA4 = "KEY_GEOBASE_FOR_AREA4";
    public static final String KEY_ALTERNATE_SOUNDEX_CODES = "KEY_ALTERNATE_SOUNDEX_CODES";
    public static final String KEY_BUILD_ALL_GEOINFO_KEYS = "KEY_BUILD_ALL_GEOINFO_KEYS";
    public static final String POSTAL_REVERSE_DICTIONARY_FILE = "POSTAL_REVERSE_DICTIONARY_FILE";
    public static final String GEOGRAPHIC_REVERSE_DICTIONARY_FILE = "GEOGRAPHIC_REVERSE_DICTIONARY_FILE";
    public static final String POSTAL_REVERSE_DICTIONARY_PATH = "POSTAL_REVERSE_DICTIONARY_PATH";
    public static final String GEOGRAPHIC_REVERSE_DICTIONARY_PATH = "GEOGRAPHIC_REVERSE_DICTIONARY_PATH";
    static IDataDictionary[] m_dataDicts;
    private static String reversePostalDictFile;
    private static String reverseGeoDictFile;
    private static String reversePostalDictPath;
    private static String reverseGeoDictPath;
    static int m_numDicts;
    static Properties m_DataResources;
    private static ExecutorService threads;

    public XWG_DataManager() throws MMJEDataManagerInitializationException {
        if (m_SetupException != null) {
            ResourceBundle rb = XWG_DataManager.loadBundleForLocale(null, (String)LSTRING_FILE);
            throw new MMJEDataManagerInitializationException(rb.getString(ERROR_LOAD_DICT_MSG), m_SetupException);
        }
    }

    public static String getReversePostalDictFile() {
        return reversePostalDictFile;
    }

    public static String getReverseGeoDictFile() {
        return reverseGeoDictFile;
    }

    public static String getReversePostalDictPath() {
        return reversePostalDictPath;
    }

    public static String getReverseGeoDictPath() {
        return reverseGeoDictPath;
    }

    public void reset() throws MMJEDataManagerInitializationException {
        if (!EngineThreadingModel.isThreadsafe()) {
            try {
                this.shutdown();
            }
            catch (DataAccessException DAEx) {
                throw new MMJEDataManagerInitializationException(DAEx.getMessage(), (Throwable)DAEx);
            }
            XWG_DataManager.start();
            if (m_SetupException != null) {
                throw new MMJEDataManagerInitializationException(m_SetupException.getMessage(), m_SetupException);
            }
        }
    }

    private void shutdown() throws DataAccessException {
        for (int i = 0; i < m_numDicts; ++i) {
            IDataDictionary dict = m_dataDicts[i];
            dict.close();
            XWG_DataManager.m_dataDicts[i] = null;
        }
        m_dataDicts = null;
    }

    public PostInfoIndexKey makePostInfoIndexKey(IPostalBase base) {
        return new StandardPostInfoIndexKey((StandardPostalBase)base);
    }

    public int getDictionaryCount() {
        return m_numDicts;
    }

    public IRetrievedCandidates retrieveCandidates(Address pa, ScoringAddress scoringAddress, IConstraints preferences) throws DataAccessException, FatalDataAccessException {
        IRetrievedCandidates retCandidates;
        try {
            retCandidates = super.retrieveCandidates(pa, scoringAddress, preferences);
        }
        catch (DataAccessException e) {
            if (e.getErrorCode() == 2104) {
                retCandidates = new CoreRetrievedCandidates(new ArrayList());
            }
            throw e;
        }
        return retCandidates;
    }

    public IRetrievedCandidates retrieveGeographicCentroids(Address pa, IConstraints preferences) throws FatalDataAccessException, DataAccessException {
        if (threads != null) {
            return this.threadedRetrieveGeographicCentroids(pa, preferences);
        }
        return super.retrieveGeographicCentroids(pa, preferences);
    }

    public IRetrievedCandidates retrievePostalCentroids(Address pa, IConstraints preferences) throws DataAccessException, FatalDataAccessException {
        if (threads != null) {
            return this.threadedRetrievePostalCentroids(pa, preferences);
        }
        return super.retrievePostalCentroids(pa, preferences);
    }

    public IRetrievedCandidates threadedRetrieveGeographicCentroids(Address pa, IConstraints preferences) throws FatalDataAccessException, DataAccessException {
        LicenseFilter filter;
        ArrayList candList = new ArrayList();
        int dictCount = this.getDictionaryCount();
        boolean foundUsableDictionary = dictCount > 0;
        AbstractDataManager.DictionaryIterator dictIterator = this.getDictionariesIterator(preferences);
        ArrayList<CallableDictionary> callList = new ArrayList<CallableDictionary>(dictCount);
        while (dictIterator.hasNext()) {
            IDataDictionary dict = dictIterator.next().getDictionary();
            if (dict.getGeoInfoFetcher() == null) continue;
            callList.add(new CallableDictionary(dict, pa, preferences, true));
        }
        try {
            List futures = threads.invokeAll(callList);
            for (Future fut : futures) {
                List cands = (List)fut.get();
                if (cands == null || cands.isEmpty()) continue;
                candList.addAll(cands);
            }
        }
        catch (InterruptedException ex) {
            ex.printStackTrace();
            throw new FatalDataAccessException(2102, (Throwable)ex);
        }
        catch (ExecutionException ex) {
            ex.printStackTrace();
            throw new FatalDataAccessException(2102, (Throwable)ex);
        }
        if ((candList == null || candList.isEmpty()) && !foundUsableDictionary) {
            throw new DataAccessException(2103);
        }
        IRetrievedCandidates result = this.buildRetrievedCandidates(candList);
        if (result.getCandidates().size() > 0 && (filter = this.getLicenseFilter()) != null && (result = filter.filterCandidates(result, 3)).getCandidates().size() == 0) {
            result.setDataLicensed(false);
        }
        return result;
    }

    public IRetrievedCandidates threadedRetrievePostalCentroids(Address pa, IConstraints preferences) throws DataAccessException, FatalDataAccessException {
        LicenseFilter filter;
        ArrayList candList = new ArrayList();
        int dictCount = this.getDictionaryCount();
        boolean foundUsableDictionary = dictCount > 0;
        AbstractDataManager.DictionaryIterator dictIterator = this.getDictionariesIterator(preferences);
        ArrayList<CallableDictionary> callList = new ArrayList<CallableDictionary>(dictCount);
        while (dictIterator.hasNext()) {
            IDataDictionary dict = dictIterator.next().getDictionary();
            if (dict.getPostInfoFetcher() == null) continue;
            callList.add(new CallableDictionary(dict, pa, preferences, false));
        }
        try {
            List futures = threads.invokeAll(callList);
            for (Future fut : futures) {
                List cands = (List)fut.get();
                if (cands == null || cands.isEmpty()) continue;
                candList.addAll(cands);
            }
        }
        catch (InterruptedException ex) {
            ex.printStackTrace();
            throw new FatalDataAccessException(2102, (Throwable)ex);
        }
        catch (ExecutionException ex) {
            ex.printStackTrace();
            throw new FatalDataAccessException(2102, (Throwable)ex);
        }
        if (candList.isEmpty() && !foundUsableDictionary) {
            throw new DataAccessException(2103);
        }
        IRetrievedCandidates result = this.buildRetrievedCandidates(candList);
        if (result.getCandidates().size() > 0 && (filter = this.getLicenseFilter()) != null && (result = filter.filterCandidates(result, 2)).getCandidates().size() == 0) {
            result.setDataLicensed(false);
        }
        return result;
    }

    protected ICountryGeographyInfo getCountryGeographyInfoObject() {
        return new CountryGeographyInfoImpl("XWG");
    }

    protected LicenseFilter getLicenseFilter() {
        return null;
    }

    public IDataDictionary getDictionary(int idx) {
        return m_dataDicts[idx];
    }

    private static void start() {
        m_SetupException = null;
        try {
            m_DataResources = DataManagerSettingsProvider.getInstance().getSettingsForCountry("XWG");
        }
        catch (IOException e) {
            MMJLog.getLog().error(e.getMessage(), (Throwable)e);
            m_SetupException = e;
        }
        if (m_DataResources != null) {
            String str = m_DataResources.getProperty(GEOGRAPHIC_REVERSE_DICTIONARY_FILE);
            if (!StringUtilities.isEmpty((String)str)) {
                reverseGeoDictFile = str;
            }
            if (!StringUtilities.isEmpty((String)(str = m_DataResources.getProperty(GEOGRAPHIC_REVERSE_DICTIONARY_PATH)))) {
                reverseGeoDictPath = str;
            }
            if (!StringUtilities.isEmpty((String)(str = m_DataResources.getProperty(POSTAL_REVERSE_DICTIONARY_FILE)))) {
                reversePostalDictFile = str;
            }
            if (!StringUtilities.isEmpty((String)(str = m_DataResources.getProperty(POSTAL_REVERSE_DICTIONARY_PATH)))) {
                reversePostalDictPath = str;
            }
        }
        try {
            m_numDicts = Integer.parseInt(m_DataResources.getProperty("DICTIONARY_COUNT"));
            if (m_numDicts < 1) {
                m_numDicts = 1;
            }
        }
        catch (Exception e) {
            m_numDicts = 1;
        }
        m_dataDicts = new XWG_DataDictionary[m_numDicts];
        try {
            for (int i = 0; i < m_numDicts; ++i) {
                try {
                    XWG_DataManager.m_dataDicts[i] = new XWG_DataDictionary(i, m_DataResources);
                    continue;
                }
                catch (DataDictionaryIntializationException DDIEx) {
                    MMJLog.getLog().error(DDIEx.getMessage(), (Throwable)DDIEx);
                    m_SetupException = DDIEx;
                }
            }
        }
        catch (Exception e) {
            MMJLog.getLog().error(e.getMessage(), (Throwable)e);
            m_SetupException = e;
        }
    }

    static {
        int count;
        threads = null;
        if (EngineThreadingModel.isThreadsafe() && (count = XWGThreadingModel.getThreadCount()) > 1) {
            threads = Executors.newFixedThreadPool(count);
        }
        XWG_DataManager.start();
    }

    private class CallableDictionary
    implements Callable<List> {
        Address input;
        IConstraints preferences;
        XWG_DataDictionary dictionary;
        boolean isGeographic;

        public CallableDictionary(IDataDictionary dict, Address in, IConstraints prefs, boolean isGeographic) {
            this.dictionary = (XWG_DataDictionary)dict;
            this.input = in;
            this.preferences = prefs;
            this.isGeographic = isGeographic;
        }

        private List getCandidates() throws LocalizationException, MMJEDataCorruptedException, IOException {
            if (this.dictionary == null) {
                return null;
            }
            if (this.isGeographic) {
                IGeoInfoFetcher fetcher = this.dictionary.getGeoInfoFetcher();
                if (fetcher == null) {
                    return null;
                }
                return fetcher.getGeoInfoCandidates(this.input, this.preferences);
            }
            IPostInfoFetcher fetcher = this.dictionary.getPostInfoFetcher();
            if (fetcher == null) {
                return null;
            }
            return fetcher.getPostInfoCandidates(this.input, this.preferences);
        }

        private void updateCandidateDictOrder(IDictionarySearchOrder order, Object candidateObj) {
            if (this.isGeographic) {
                InternalGeographicCandidate candidate = (InternalGeographicCandidate)candidateObj;
                candidate.setDictionaryPriority(this.dictionary.getDictionaryNumber());
                if (order != null) {
                    candidate.setUserDictionaryPriority(order.getSearchOrderForDictionary(this.dictionary.getDictionaryNumber() + 1));
                } else {
                    candidate.setUserDictionaryPriority(this.dictionary.getDictionaryNumber() + 1);
                }
            } else {
                InternalPostalCandidate candidate = (InternalPostalCandidate)candidateObj;
                candidate.setDictionaryPriority(this.dictionary.getDictionaryNumber());
                if (order != null) {
                    candidate.setUserDictionaryPriority(order.getSearchOrderForDictionary(this.dictionary.getDictionaryNumber() + 1));
                } else {
                    candidate.setUserDictionaryPriority(this.dictionary.getDictionaryNumber() + 1);
                }
            }
        }

        @Override
        public List call() throws FatalDataAccessException {
            try {
                List candidates = this.getCandidates();
                if (candidates != null) {
                    IDictionarySearchOrder order = this.preferences.getDictionarySearchOrder();
                    Iterator candidateIter = candidates.iterator();
                    while (candidateIter.hasNext()) {
                        this.updateCandidateDictOrder(order, candidateIter.next());
                    }
                }
                return candidates;
            }
            catch (LocalizationException LEx) {
                throw new FatalDataAccessException(2100, (Throwable)LEx);
            }
            catch (MMJEDataCorruptedException MMJEDCEx) {
                throw new FatalDataAccessException(2101, (Throwable)MMJEDCEx);
            }
            catch (IOException e) {
                throw new FatalDataAccessException(2102, (Throwable)e);
            }
        }
    }
}

