/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.XWG.dp.binary;

import com.mapinfo.mapmarker.XWG.dp.binary.XWG_GeoInfoRecord;
import com.mapinfo.mapmarker.common.dp.binary.FrequentDataFileStrings;
import com.mapinfo.mapmarker.common.dp.binary.GenericDataItem;
import com.mapinfo.mapmarker.common.dp.binary.GenericDataItemAccessor;
import com.mapinfo.mapmarker.common.dp.binary.GeoInfoPreLoadedDataHelper;
import com.mapinfo.mapmarker.common.dp.binary.GeoInfoRecord;
import com.mapinfo.mapmarker.common.dp.binary.IDataFileDataItem;
import com.mapinfo.mapmarker.common.dp.binary.LocalizationException;
import com.mapinfo.mapmarker.common.dp.binary.MMJComplexDataFileMetadata;
import com.mapinfo.mapmarker.common.dp.binary.MMJDataFileMetadata;
import com.mapinfo.mapmarker.utils.BlobUtilities;
import com.mapinfo.mapmarker.utils.ISO3166;
import com.mapinfo.mapmarker.utils.StringUtilities;
import java.io.IOException;

public class XWG_GeoInfoPreLoadedDataHelper
extends GeoInfoPreLoadedDataHelper {
    public MMJDataFileMetadata getMetadataType() {
        return new MMJComplexDataFileMetadata();
    }

    protected GeoInfoRecord makeGeoInfoRecord() {
        return new XWG_GeoInfoRecord();
    }

    public Object makeDataRecord(IDataFileDataItem item, MMJDataFileMetadata metadata) throws LocalizationException {
        byte[] bytes;
        XWG_GeoInfoRecord record = (XWG_GeoInfoRecord)((Object)super.makeDataRecord(item, metadata));
        GenericDataItem genericItem = (GenericDataItem)item;
        MMJComplexDataFileMetadata complexMetadata = (MMJComplexDataFileMetadata)metadata;
        FrequentDataFileStrings geoinfoFrequentStrings = complexMetadata.getFrequentStrings();
        String value = this.lookupValue(0, 32, genericItem, geoinfoFrequentStrings);
        if (value != null) {
            record.setAreaName1(value);
        }
        if ((value = this.lookupValue(1, 33, genericItem, geoinfoFrequentStrings)) != null) {
            record.setAreaName2(value);
        }
        if ((value = this.lookupValue(2, 34, genericItem, geoinfoFrequentStrings)) != null) {
            record.setAreaName3(value);
        }
        if ((value = this.lookupValue(3, 35, genericItem, geoinfoFrequentStrings)) != null) {
            record.setAreaName4(value);
        }
        this.lookupCountryCode(genericItem, record);
        if (genericItem.hasBlob(36)) {
            record.setAlternateCountryArray(this.decodeStringArray(GenericDataItemAccessor.getDataBlob((int)36, (GenericDataItem)genericItem)));
        }
        record.setCityRank(GenericDataItemAccessor.getDataByte((int)37, (GenericDataItem)genericItem));
        if (genericItem.hasBlob(32)) {
            bytes = GenericDataItemAccessor.getDataBlob((int)32, (GenericDataItem)genericItem);
            record.setAltAreaName1Array(this.decodeStringArray(bytes));
        }
        if (genericItem.hasBlob(33)) {
            bytes = GenericDataItemAccessor.getDataBlob((int)33, (GenericDataItem)genericItem);
            record.setAltAreaName2Array(this.decodeStringArray(bytes));
        }
        if (genericItem.hasBlob(34)) {
            bytes = GenericDataItemAccessor.getDataBlob((int)34, (GenericDataItem)genericItem);
            record.setAltAreaName3Array(this.decodeStringArray(bytes));
        }
        if (genericItem.hasBlob(35)) {
            bytes = GenericDataItemAccessor.getDataBlob((int)35, (GenericDataItem)genericItem);
            record.setAltAreaName4Array(this.decodeStringArray(bytes));
        }
        record.setAltAreaName1(null);
        record.setAltAreaName2(null);
        record.setAltAreaName3(null);
        record.setAltAreaName4(null);
        if (genericItem.hasInteger(32)) {
            int pc = GenericDataItemAccessor.getDataInt((int)32, (GenericDataItem)genericItem);
            StringBuilder sb = new StringBuilder(String.valueOf(pc));
            while (sb.length() < 5) {
                sb.insert(0, '0');
            }
            record.setPostCode(sb.toString());
        }
        return record;
    }

    protected void lookupCountryCode(GenericDataItem genericItem, XWG_GeoInfoRecord record) throws LocalizationException {
        ISO3166 isoRec;
        int isoNumCode = -1;
        if (genericItem.hasByte(36)) {
            isoNumCode = GenericDataItemAccessor.getDataByte((int)36, (GenericDataItem)genericItem);
        }
        if (genericItem.hasShort(32)) {
            isoNumCode = GenericDataItemAccessor.getDataShort((int)32, (GenericDataItem)genericItem);
        }
        if (isoNumCode != -1 && (isoRec = ISO3166.findCountryByNumber((String)StringUtilities.intToLeadingZeroString((int)3, (int)isoNumCode))) != null) {
            record.setCountry(isoRec.getISO3Country());
            return;
        }
        if (genericItem.hasString(32)) {
            record.setCountry(GenericDataItemAccessor.getDataString((int)32, (GenericDataItem)genericItem));
        }
    }

    private String lookupValue(int stringKey, int byteKey, GenericDataItem genericItem, FrequentDataFileStrings geoinfoFrequentStrings) throws LocalizationException {
        if (genericItem.hasString(stringKey)) {
            return GenericDataItemAccessor.getDataString((int)stringKey, (GenericDataItem)genericItem);
        }
        if (genericItem.hasString(byteKey)) {
            byte key = GenericDataItemAccessor.getDataByte((int)byteKey, (GenericDataItem)genericItem);
            return geoinfoFrequentStrings.getFrequentString(byteKey, (int)key);
        }
        return null;
    }

    private String[] decodeStringArray(byte[] bytes) throws LocalizationException {
        try {
            String[] strs = BlobUtilities.decodeStringArray((byte[])bytes);
            return strs;
        }
        catch (IOException e) {
            throw new LocalizationException((Throwable)e);
        }
    }
}

