/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.XWG.dp.binary;

import com.mapinfo.mapmarker.XWG.dp.binary.XWG_PostInfoRecord;
import com.mapinfo.mapmarker.common.dp.binary.GenericDataItem;
import com.mapinfo.mapmarker.common.dp.binary.GenericDataItemAccessor;
import com.mapinfo.mapmarker.common.dp.binary.IDataAccessHelper;
import com.mapinfo.mapmarker.common.dp.binary.IDataFileDataItem;
import com.mapinfo.mapmarker.common.dp.binary.LocalizationException;
import com.mapinfo.mapmarker.common.dp.binary.MMJComplexDataFileMetadata;
import com.mapinfo.mapmarker.common.dp.binary.MMJDataFileMetadata;
import com.mapinfo.mapmarker.common.dp.binary.PostInfoDataItem;
import com.mapinfo.mapmarker.utils.BlobUtilities;
import com.mapinfo.mapmarker.utils.ISO3166;
import com.mapinfo.mapmarker.utils.StringUtilities;
import com.mapinfo.midev.geometry.DirectPosition;
import java.io.IOException;

public class XWG_PostInfoPreLoadedDataHelper
implements IDataAccessHelper {
    public MMJDataFileMetadata getMetadataType() {
        return new MMJComplexDataFileMetadata();
    }

    public IDataFileDataItem getDataItemType() {
        return new PostInfoDataItem();
    }

    public XWG_PostInfoRecord makeDataRecord(IDataFileDataItem item, MMJDataFileMetadata metadata) throws LocalizationException {
        XWG_PostInfoRecord record = new XWG_PostInfoRecord();
        GenericDataItem genericItem = (GenericDataItem)item;
        if (genericItem.hasString(0)) {
            record.setPostalCode1(GenericDataItemAccessor.getDataString((int)0, (GenericDataItem)genericItem));
        }
        if (genericItem.hasString(2)) {
            record.setAreaName1(GenericDataItemAccessor.getDataString((int)2, (GenericDataItem)genericItem));
        }
        if (genericItem.hasString(3)) {
            record.setAreaName2(GenericDataItemAccessor.getDataString((int)3, (GenericDataItem)genericItem));
        }
        if (genericItem.hasString(4)) {
            record.setAreaName3(GenericDataItemAccessor.getDataString((int)4, (GenericDataItem)genericItem));
        }
        if (genericItem.hasString(5)) {
            record.setAreaName4(GenericDataItemAccessor.getDataString((int)5, (GenericDataItem)genericItem));
        }
        if (genericItem.hasLong(0)) {
            long xCoord = GenericDataItemAccessor.getDataLong((int)0, (GenericDataItem)genericItem);
            if (genericItem.hasLong(1)) {
                long yCoord = GenericDataItemAccessor.getDataLong((int)1, (GenericDataItem)genericItem);
                DirectPosition pnt = new DirectPosition((double)xCoord / Math.pow(10.0, metadata.getXPow10()), (double)yCoord / Math.pow(10.0, metadata.getYPow10()));
                record.setCentroid(pnt);
                if (genericItem.hasByte(0)) {
                    record.setPrecision(GenericDataItemAccessor.getDataByte((int)0, (GenericDataItem)genericItem));
                }
            }
        }
        MMJComplexDataFileMetadata complexMetadata = (MMJComplexDataFileMetadata)metadata;
        this.lookupCountryCode(genericItem, record);
        if (genericItem.hasBlob(32)) {
            try {
                record.setAlternateCountryArray(BlobUtilities.decodeStringArray((byte[])GenericDataItemAccessor.getDataBlob((int)32, (GenericDataItem)genericItem)));
            }
            catch (IOException IOEx) {
                throw new LocalizationException((Throwable)IOEx);
            }
        }
        return record;
    }

    protected void lookupCountryCode(GenericDataItem genericItem, XWG_PostInfoRecord record) throws LocalizationException {
        ISO3166 isoRec;
        int isoNumCode = -1;
        if (genericItem.hasByte(32)) {
            isoNumCode = GenericDataItemAccessor.getDataByte((int)32, (GenericDataItem)genericItem);
        }
        if (genericItem.hasShort(32)) {
            isoNumCode = GenericDataItemAccessor.getDataShort((int)32, (GenericDataItem)genericItem);
        }
        if (isoNumCode != -1 && (isoRec = ISO3166.findCountryByNumber((String)StringUtilities.intToLeadingZeroString((int)3, (int)isoNumCode))) != null) {
            record.setCountry(isoRec.getISO3Country());
            return;
        }
        if (genericItem.hasString(32)) {
            record.setCountry(GenericDataItemAccessor.getDataString((int)32, (GenericDataItem)genericItem));
        }
    }
}

