/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.XWG.filters;

import com.mapinfo.mapmarker.XWG.XWG_InternalGeographicCandidate;
import com.mapinfo.mapmarker.common.Address;
import com.mapinfo.mapmarker.common.ICandidate;
import com.mapinfo.mapmarker.common.filters.ICloseMatchFilterRule;
import com.mapinfo.mapmarker.utils.StringUtilities;

public class LowerPrecisionBetterMatchFilterRule
implements ICloseMatchFilterRule {
    static double BLANK_MATCH_SCORE = 0.7;

    public boolean demoteOther(Address[] inputAddresses, ICandidate bestCandidate, ICandidate otherCandidate) {
        XWG_InternalGeographicCandidate best = (XWG_InternalGeographicCandidate)bestCandidate;
        XWG_InternalGeographicCandidate other = (XWG_InternalGeographicCandidate)otherCandidate;
        if (best.getPrecision() >= other.getPrecision()) {
            return false;
        }
        if (best.getPrecision() == 8 && best.getAreaName1Score() != 1.0) {
            return false;
        }
        if (best.getPrecision() == 9 && best.getAreaName2Score() != 1.0) {
            return false;
        }
        if (best.getPrecision() == 10 && best.getAreaName3Score() != 1.0) {
            return false;
        }
        if (other.getAreaName1Score() != 1.0 || !StringUtilities.equalStrings((String)best.getAreaName1(), (String)other.getAreaName1())) {
            return false;
        }
        return other.getAreaName2Score() < BLANK_MATCH_SCORE || other.getAreaName3Score() < BLANK_MATCH_SCORE || other.getAreaName4Score() < BLANK_MATCH_SCORE;
    }
}

