/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.XWG.geographic;

import com.mapinfo.mapmarker.IConstraints;
import com.mapinfo.mapmarker.XWG.XWG_Constraints;
import com.mapinfo.mapmarker.XWG.XWG_InternalGeographicCandidate;
import com.mapinfo.mapmarker.common.Address;
import com.mapinfo.mapmarker.common.FieldScores;
import com.mapinfo.mapmarker.common.InternalGeographicCandidate;
import com.mapinfo.mapmarker.common.InternalMatcherConstants;
import com.mapinfo.mapmarker.core.IRetrievedCandidates;
import com.mapinfo.mapmarker.core.geographic.IGeographicMatcher;
import com.mapinfo.mapmarker.core.matcher.IMatchPreferences;
import com.mapinfo.mapmarker.utils.StringUtilities;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;

public class XWG_GeographicMatcher
implements IGeographicMatcher {
    public List matchGeographic(IConstraints constraints, Address parsedAddress, IRetrievedCandidates candidateInfo) {
        if (candidateInfo != null) {
            List candidateList = candidateInfo.getCandidates();
            if (candidateList != null && !candidateList.isEmpty()) {
                InternalMatcherConstants matcherConstants = constraints.getHandler().getMatcherConstants().getGeographicMatcherConstants();
                double maxScore = this.computeMaximumGeographicScore(parsedAddress, matcherConstants);
                IMatchPreferences preferences = constraints.getHandler().getMatchConstraintsConverter().repackageGeocodingConstraints(constraints, parsedAddress);
                ListIterator candidateIterator = candidateList.listIterator();
                while (candidateIterator.hasNext()) {
                    InternalGeographicCandidate candidate = (InternalGeographicCandidate)candidateIterator.next();
                    this.scoreCandidate(candidate, parsedAddress, matcherConstants, maxScore);
                    this.decideCloseMatch(preferences, (XWG_InternalGeographicCandidate)candidate, parsedAddress, matcherConstants, constraints);
                }
                this.orderCandidates(candidateList);
            }
            return candidateList;
        }
        return null;
    }

    private void decideCloseMatch(IMatchPreferences preferences, XWG_InternalGeographicCandidate candidate, Address pa, InternalMatcherConstants constants, IConstraints constraints) {
        if (candidate.getCombinedScore() < constants.getCloseMatchCutOff()) {
            candidate.setCloseMatchStatus(false);
            return;
        }
        if (preferences.getExactMatchAreaName1() && candidate.getAreaName1Score() != 1.0) {
            candidate.setCloseMatchStatus(false);
            return;
        }
        if (preferences.getExactMatchAreaName2() && candidate.getAreaName2Score() != 1.0) {
            candidate.setCloseMatchStatus(false);
            return;
        }
        if (preferences.getExactMatchAreaName3() && candidate.getAreaName3Score() != 1.0) {
            candidate.setCloseMatchStatus(false);
            return;
        }
        if (preferences.getExactMatchAreaName4() && candidate.getAreaName4Score() != 1.0) {
            candidate.setCloseMatchStatus(false);
            return;
        }
        if (preferences.getExactMatchCountry() && candidate.getCountryScore() != 1.0) {
            candidate.setCloseMatchStatus(false);
            return;
        }
        if (candidate.getCombinedScore() < 0.8 && (candidate.getAreaName1Score() < 0.5 && candidate.getAreaName3Score() < 0.9 || candidate.getAreaName3Score() < 0.5 && candidate.getAreaName1Score() < 0.9)) {
            candidate.setCloseMatchStatus(false);
            return;
        }
        if (((XWG_Constraints)constraints).useStringKeys()) {
            boolean bInputAN2;
            int matchLevel = candidate.getPrecision();
            Address input = constraints.getHandler().getInputAddress();
            boolean bInputAN4 = !StringUtilities.isEmpty((String)input.getAreaName4());
            boolean bInputAN3 = !StringUtilities.isEmpty((String)input.getAreaName3());
            boolean bl = bInputAN2 = !StringUtilities.isEmpty((String)input.getAreaName2());
            if (bInputAN2 | bInputAN3 | bInputAN4 && matchLevel < 9) {
                candidate.setCloseMatchStatus(false);
                return;
            }
            if (bInputAN3 | bInputAN4 && matchLevel < 10) {
                candidate.setCloseMatchStatus(false);
                return;
            }
            if (bInputAN4 && matchLevel < 11) {
                candidate.setCloseMatchStatus(false);
                return;
            }
            if (bInputAN3 && !StringUtilities.equalStrings((String)input.getAreaName3(), (String)candidate.getAreaName3())) {
                if (!StringUtilities.isEmpty((String)input.getAreaName1()) && candidate.getAreaName1Score() < 0.6) {
                    candidate.setCloseMatchStatus(false);
                    return;
                }
                if (bInputAN2 && candidate.getAreaName2Score() < 0.5) {
                    candidate.setCloseMatchStatus(false);
                    return;
                }
            }
        }
    }

    private void scoreCandidate(InternalGeographicCandidate candidate, Address parsedAddress, InternalMatcherConstants constants, double maxScore) {
        candidate.scoreCandidate(parsedAddress, constants.getCharsToIgnore());
        this.scoreGeographicCandidate(candidate, parsedAddress, constants, maxScore);
    }

    private void scoreGeographicCandidate(InternalGeographicCandidate candidate, Address parsedAddress, InternalMatcherConstants constants, double maxScore) {
        double score = 0.0;
        FieldScores matchedConstants = constants.getMatched();
        FieldScores blankConstants = constants.getBlank();
        score = XWG_GeographicMatcher.fieldExists(parsedAddress.getAreaName1()) ? (score += matchedConstants.getAreaName1() * candidate.getAreaName1Score()) : (score += blankConstants.getAreaName1() * candidate.getAreaName1Score());
        score = XWG_GeographicMatcher.fieldExists(parsedAddress.getAreaName2()) ? (score += matchedConstants.getAreaName2() * candidate.getAreaName2Score()) : (score += blankConstants.getAreaName2() * candidate.getAreaName2Score());
        score = XWG_GeographicMatcher.fieldExists(parsedAddress.getAreaName3()) ? (score += matchedConstants.getAreaName3() * candidate.getAreaName3Score()) : (score += blankConstants.getAreaName3() * candidate.getAreaName3Score());
        score = XWG_GeographicMatcher.fieldExists(parsedAddress.getAreaName4()) ? (score += matchedConstants.getAreaName4() * candidate.getAreaName4Score()) : (score += blankConstants.getAreaName4() * candidate.getAreaName4Score());
        score = XWG_GeographicMatcher.fieldExists(parsedAddress.getCountry()) ? (score += matchedConstants.getCountry() * candidate.getCountryScore()) : (score += blankConstants.getCountry() * candidate.getCountryScore());
        candidate.setCombinedScore(score / maxScore);
    }

    private double computeMaximumGeographicScore(Address parsedAddress, InternalMatcherConstants constants) {
        double m_maximumAddressScore = 0.0;
        FieldScores matchedConstants = constants.getMatched();
        FieldScores blankConstants = constants.getBlank();
        m_maximumAddressScore = XWG_GeographicMatcher.fieldExists(parsedAddress.getAreaName1()) ? (m_maximumAddressScore += matchedConstants.getAreaName1()) : (m_maximumAddressScore += blankConstants.getAreaName1());
        m_maximumAddressScore = XWG_GeographicMatcher.fieldExists(parsedAddress.getAreaName2()) ? (m_maximumAddressScore += matchedConstants.getAreaName2()) : (m_maximumAddressScore += blankConstants.getAreaName2());
        m_maximumAddressScore = XWG_GeographicMatcher.fieldExists(parsedAddress.getAreaName3()) ? (m_maximumAddressScore += matchedConstants.getAreaName3()) : (m_maximumAddressScore += blankConstants.getAreaName3());
        m_maximumAddressScore = XWG_GeographicMatcher.fieldExists(parsedAddress.getAreaName4()) ? (m_maximumAddressScore += matchedConstants.getAreaName4()) : (m_maximumAddressScore += blankConstants.getAreaName4());
        m_maximumAddressScore = XWG_GeographicMatcher.fieldExists(parsedAddress.getCountry()) ? (m_maximumAddressScore += matchedConstants.getCountry()) : (m_maximumAddressScore += blankConstants.getCountry());
        return m_maximumAddressScore;
    }

    private void orderCandidates(List candidateList) {
        Collections.sort(candidateList);
        Collections.reverse(candidateList);
    }

    private static boolean fieldExists(String str) {
        return str != null && str.length() != 0;
    }
}

