/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.XWG.reverseGeocode;

import com.mapinfo.mapmarker.common.Address;
import com.mapinfo.mapmarker.core.reverseGeocode.IReverseGeocodeInternalConstraints;
import com.mapinfo.mapmarker.user.ReverseGeocodeCandidateAddress;
import com.mapinfo.mapmarker.user.ReverseGeocodeLocation;
import com.mapinfo.mapmarker.user.ReverseGeocodeResponse;
import com.mapinfo.mapmarker.utils.MMJLog;
import com.mapinfo.midev.coordsys.CoordSysConstants;
import com.mapinfo.midev.data.ICursor;
import com.mapinfo.midev.data.IDataSourceTable;
import com.mapinfo.midev.dp.tab.NativeDataProvider;
import com.mapinfo.midev.feature.AttributeType;
import com.mapinfo.midev.feature.IAttributeDefinition;
import com.mapinfo.midev.feature.IFeature;
import com.mapinfo.midev.feature.util.AttributeDefinitionCollection;
import com.mapinfo.midev.geometry.Envelope;
import com.mapinfo.midev.geometry.IFeatureGeometry;
import com.mapinfo.midev.geometry.SpatialInfo;
import com.mapinfo.midev.geometry.impl.Point;
import com.mapinfo.midev.language.ISearch;
import com.mapinfo.midev.language.filter.EnvelopeFilter;
import com.mapinfo.midev.language.filter.FilterSearch;
import com.mapinfo.midev.language.filter.IFilter;
import com.mapinfo.midev.unit.Length;
import com.mapinfo.midev.unit.LinearUnit;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public abstract class XWG_AbstractReverseGeocodeSubHandler {
    private static SpatialInfo SPATIAL_INFO = new SpatialInfo(CoordSysConstants.longLatWGS84);
    private static final String GEOMETRY_COLUMN_NAME = "obj";

    protected Envelope buildEnvelope(ReverseGeocodeLocation location, IReverseGeocodeInternalConstraints constraints, boolean buffer) {
        return new Envelope(location.getPositionPoint(), location.getPositionPoint(), SPATIAL_INFO);
    }

    protected IDataSourceTable getTable(File file) {
        NativeDataProvider dp = NativeDataProvider.getInstance();
        return dp.openTable(file);
    }

    protected ICursor doSearch(String colName, String[] completeAttributes, IDataSourceTable dstable, ReverseGeocodeLocation location, IReverseGeocodeInternalConstraints constraints) {
        EnvelopeFilter filter = new EnvelopeFilter(colName, this.buildEnvelope(location, constraints, false));
        FilterSearch search = new FilterSearch(completeAttributes, (IFilter)filter, null);
        return dstable.search((ISearch)search);
    }

    public ReverseGeocodeResponse findCandidates(List<File> files, List<String> attributes, ReverseGeocodeLocation location, IReverseGeocodeInternalConstraints constraints) {
        ArrayList<ReverseGeocodeCandidateAddress> masterCandidateList = new ArrayList<ReverseGeocodeCandidateAddress>(1);
        if (attributes == null || attributes.isEmpty()) {
            MMJLog.getLog().error("No attributes provided for Reverse Geocode table.");
            return new ReverseGeocodeResponse(masterCandidateList);
        }
        if (files == null || files.isEmpty()) {
            MMJLog.getLog().error("No file provided for Reverse Geocode lookup.");
            return new ReverseGeocodeResponse(masterCandidateList);
        }
        for (File file : files) {
            IDataSourceTable dstable = this.getTable(file);
            if (dstable == null) {
                MMJLog.getLog().error("Reverse Geocode table is null: " + file.getAbsolutePath());
                continue;
            }
            masterCandidateList.addAll(this.getTableCandidates(dstable, attributes, location, constraints));
        }
        return new ReverseGeocodeResponse(masterCandidateList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<ReverseGeocodeCandidateAddress> getTableCandidates(IDataSourceTable dstable, List<String> attributes, ReverseGeocodeLocation location, IReverseGeocodeInternalConstraints constraints) {
        ArrayList<ReverseGeocodeCandidateAddress> candidates = new ArrayList<ReverseGeocodeCandidateAddress>(1);
        String featureGeometryColumnName = GEOMETRY_COLUMN_NAME;
        IAttributeDefinition objDef = dstable.getMetadata().getAttributeDefinitions().get(featureGeometryColumnName);
        if (objDef == null || objDef.getDataType() != AttributeType.FEATURE_GEOMETRY) {
            featureGeometryColumnName = null;
            AttributeDefinitionCollection attributeDefinitions = dstable.getMetadata().getAttributeDefinitions();
            for (IAttributeDefinition def : attributeDefinitions) {
                if (def.getDataType() != AttributeType.FEATURE_GEOMETRY) continue;
                featureGeometryColumnName = def.getName();
                break;
            }
            if (featureGeometryColumnName == null) {
                throw new RuntimeException(dstable.getDefinition().getName() + " featureGeometryColumnName is null");
            }
        }
        String[] completeAttributes = new String[attributes.size() + 1];
        for (int i = 0; i < attributes.size(); ++i) {
            completeAttributes[i] = attributes.get(i);
        }
        completeAttributes[attributes.size()] = featureGeometryColumnName;
        Point point = new Point(SPATIAL_INFO, location.getPositionPoint());
        ICursor cursor = this.doSearch(featureGeometryColumnName, completeAttributes, dstable, location, constraints);
        try {
            while (cursor.hasNext()) {
                IFeatureGeometry geometry;
                IFeature feature = cursor.next();
                if (feature.isNull(featureGeometryColumnName) || !(geometry = feature.getFeatureGeometry(featureGeometryColumnName)).contains(location.getPositionPoint())) continue;
                Address address = this.populateAddressAttributes(feature, constraints);
                ReverseGeocodeCandidateAddress cand = new ReverseGeocodeCandidateAddress(address, 1, new Length(0.0, LinearUnit.METER));
                cand.setLocation(point.getDirectPosition());
                cand.setPrecisionCode(this.calculatePrecisionCode(cand));
                candidates.add(cand);
            }
        }
        finally {
            cursor.dispose();
        }
        return candidates;
    }

    public abstract Address populateAddressAttributes(IFeature var1, IReverseGeocodeInternalConstraints var2);

    public abstract String calculatePrecisionCode(ReverseGeocodeCandidateAddress var1);
}

