/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.XWG.reverseGeocode;

import com.mapinfo.mapmarker.MMInternalFatalException;
import com.mapinfo.mapmarker.MapMarkerInternalException;
import com.mapinfo.mapmarker.XWG.dp.binary.XWG_DataManager;
import com.mapinfo.mapmarker.XWG.reverseGeocode.XWG_AbstractReverseGeocodeSubHandler;
import com.mapinfo.mapmarker.common.Address;
import com.mapinfo.mapmarker.common.AddressImpl;
import com.mapinfo.mapmarker.common.dp.DataManagerSettingsProvider;
import com.mapinfo.mapmarker.common.dp.binary.VendorDataType;
import com.mapinfo.mapmarker.core.reverseGeocode.IReverseGeocodeInternalConstraints;
import com.mapinfo.mapmarker.core.reverseGeocode.IReverseGeocodeSubHandler;
import com.mapinfo.mapmarker.user.ReverseGeocodeCandidateAddress;
import com.mapinfo.mapmarker.user.ReverseGeocodeLocation;
import com.mapinfo.mapmarker.user.ReverseGeocodeResponse;
import com.mapinfo.mapmarker.utils.StringUtilities;
import com.mapinfo.mapmarker.utils.StringWithTokens;
import com.mapinfo.midev.feature.IFeature;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;

public class XWG_GeographicReverseGeocodeSubHandler
extends XWG_AbstractReverseGeocodeSubHandler
implements IReverseGeocodeSubHandler {
    private static final String GEOGRAPHIC_PRECISION_CODE_PREFIX = "RG";
    public static final String GEOGRAPHIC_COUNTRY = "GEOGRAPHIC_COUNTRY";
    public static final String AREA_NAME_1 = "AREA_NAME_1";
    public static final String AREA_NAME_2 = "AREA_NAME_2";
    public static final String AREA_NAME_3 = "AREA_NAME_3";
    public static final String AREA_NAME_4 = "AREA_NAME_4";
    public static final String SUB_AREA_NAME_4 = "SUB_AREA_NAME_4";
    public static final String GEOGRAPHIC_COUNTRY_ENG = "GEOGRAPHIC_COUNTRY_ENG";
    public static final String AREA_NAME_1_ENG = "AREA_NAME_1_ENG";
    public static final String AREA_NAME_2_ENG = "AREA_NAME_2_ENG";
    public static final String AREA_NAME_3_ENG = "AREA_NAME_3_ENG";
    public static final String AREA_NAME_4_ENG = "AREA_NAME_4_ENG";
    public static final String SUB_AREA_NAME_4_ENG = "SUB_AREA_NAME_4_ENG";
    public static final String GEOGRAPHIC_ID = "GEOGRAPHIC_ID";
    public static final String GEOGRAPHIC_COUNTRY_DEFAULT = "country";
    public static final String ID_DEFAULT = "featureid";
    public static final String AREA_NAME_1_DEFAULT = "L2";
    public static final String AREA_NAME_2_DEFAULT = "L3";
    public static final String AREA_NAME_3_DEFAULT = "L4";
    public static final String AREA_NAME_4_DEFAULT = "L5";
    public static final String SUB_AREA_NAME_4_DEFAULT = "L6";
    public static final String GEOGRAPHIC_COUNTRY_ENG_DEFAULT = "L1_nm_eng";
    public static final String AREA_NAME_1_ENG_DEFAULT = "L2_nm_eng";
    public static final String AREA_NAME_2_ENG_DEFAULT = "L3_nm_eng";
    public static final String AREA_NAME_3_ENG_DEFAULT = "L4_nm_eng";
    public static final String AREA_NAME_4_ENG_DEFAULT = "L5_nm_eng";
    public static final String SUB_AREA_NAME_4_ENG_DEFAULT = "L6_nm_eng";
    private static final String DATATYPE_PREFIX = "DATATYPE_";
    protected static final int COUNTRY_ATT_IDX = 0;
    protected static final int ID_ATT_IDX = 1;
    protected static final int AN1_ATT_IDX = 2;
    protected static final int AN2_ATT_IDX = 3;
    protected static final int AN3_ATT_IDX = 4;
    protected static final int AN4_ATT_IDX = 5;
    protected static final int AN5_ATT_IDX = 6;
    protected static final int ENG_COUNTRY_ATT_IDX = 7;
    protected static final int ENG_AN1_ATT_IDX = 8;
    protected static final int ENG_AN2_ATT_IDX = 9;
    protected static final int ENG_AN3_ATT_IDX = 10;
    protected static final int ENG_AN4_ATT_IDX = 11;
    protected static final int ENG_AN5_ATT_IDX = 12;
    static List<String> requestedAttributes;
    static List<String> requestedAttributesPlusEnglish;
    static Map<String, String> LBS_NonDefaultVendorMap;

    @Override
    public Address populateAddressAttributes(IFeature feature, IReverseGeocodeInternalConstraints constraints) {
        HashMap<String, String> map;
        AddressImpl address = new AddressImpl();
        address.setCountry(feature.getString(requestedAttributes.get(0)));
        address.setAreaName1(feature.getString(requestedAttributes.get(2)));
        address.setAreaName2(feature.getString(requestedAttributes.get(3)));
        address.setAreaName3(feature.getString(requestedAttributes.get(4)));
        address.setAreaName4(feature.getString(requestedAttributes.get(5)));
        address.setGenericField1(feature.getString(requestedAttributes.get(1)));
        address.setGenericField2(feature.getString(requestedAttributes.get(6)));
        if (this.isReturnEnglishPlacenames(constraints)) {
            HashMap<String, String> customValues = new HashMap<String, String>(6);
            this.setIfNotNull(feature, requestedAttributesPlusEnglish.get(7), GEOGRAPHIC_COUNTRY_ENG, customValues);
            this.setIfNotNull(feature, requestedAttributesPlusEnglish.get(8), AREA_NAME_1_ENG, customValues);
            this.setIfNotNull(feature, requestedAttributesPlusEnglish.get(9), AREA_NAME_2_ENG, customValues);
            this.setIfNotNull(feature, requestedAttributesPlusEnglish.get(10), AREA_NAME_3_ENG, customValues);
            this.setIfNotNull(feature, requestedAttributesPlusEnglish.get(11), AREA_NAME_4_ENG, customValues);
            this.setIfNotNull(feature, requestedAttributesPlusEnglish.get(12), SUB_AREA_NAME_4_ENG, customValues);
            address.setAdditionalFields(customValues);
        }
        if ((map = address.getAdditionalFields()) == null) {
            map = new HashMap<String, String>();
            address.setAdditionalFields(map);
        }
        map.put("VENDOR", this.getCandidateSource((Address)address));
        return address;
    }

    public ReverseGeocodeResponse reverseGeocode(ReverseGeocodeLocation location, IReverseGeocodeInternalConstraints constraints) throws MapMarkerInternalException, MMInternalFatalException {
        String rgTabFile = XWG_DataManager.getReverseGeoDictFile();
        String rgTabPath = XWG_DataManager.getReverseGeoDictPath();
        if (rgTabFile == null || rgTabPath == null) {
            return new ReverseGeocodeResponse(new ArrayList());
        }
        ArrayList<File> files = new ArrayList<File>(1);
        files.add(new File(rgTabPath, rgTabFile));
        List<String> attributes = this.isReturnEnglishPlacenames(constraints) ? requestedAttributesPlusEnglish : requestedAttributes;
        return this.findCandidates(files, attributes, location, constraints);
    }

    @Override
    public String calculatePrecisionCode(ReverseGeocodeCandidateAddress candidateAddress) {
        return GEOGRAPHIC_PRECISION_CODE_PREFIX + (this.determineLevel((Address)candidateAddress) - 1);
    }

    protected String getCandidateSource(Address candidateAddress) {
        if (LBS_NonDefaultVendorMap.isEmpty()) {
            return "";
        }
        int level = this.determineLevel(candidateAddress);
        String key = candidateAddress.getCountry() + level;
        if (LBS_NonDefaultVendorMap.containsKey(key)) {
            return LBS_NonDefaultVendorMap.get(key);
        }
        return String.valueOf(VendorDataType.DATATYPE_TOMTOM.getDataType());
    }

    protected boolean isReturnEnglishPlacenames(IReverseGeocodeInternalConstraints constraints) {
        return constraints != null && "true".equalsIgnoreCase(constraints.getCustomString("RETURN_ENGLISH_VALUES"));
    }

    protected void setIfNotNull(IFeature feature, String featureKey, String customKey, Map<String, String> customValues) {
        if (feature == null || customValues == null || customKey == null || featureKey == null) {
            return;
        }
        String value = feature.getString(featureKey);
        if (value == null || value.isEmpty()) {
            return;
        }
        customValues.put(customKey, value);
    }

    protected int determineLevel(Address candidateAddress) {
        if (!StringUtilities.isEmpty((String)candidateAddress.getGenericField2())) {
            return 6;
        }
        if (!StringUtilities.isEmpty((String)candidateAddress.getAreaName4())) {
            return 5;
        }
        if (!StringUtilities.isEmpty((String)candidateAddress.getAreaName3())) {
            return 4;
        }
        if (!StringUtilities.isEmpty((String)candidateAddress.getAreaName2())) {
            return 3;
        }
        if (!StringUtilities.isEmpty((String)candidateAddress.getAreaName1())) {
            return 2;
        }
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void initializeLBS_SpecialVendorMap(File vendorFile) {
        BufferedReader reader = null;
        HashMap<String, HashMap> countryToLevelVendorsMap = new HashMap<String, HashMap>();
        HashMap<String, String> map = new HashMap<String, String>();
        try {
            reader = new BufferedReader(new FileReader(vendorFile));
            String line = reader.readLine();
            while (line != null) {
                StringTokenizer st;
                if (line.contains("Country")) {
                    line = reader.readLine();
                }
                if ((st = new StringTokenizer(line, ";")).countTokens() > 3) {
                    HashMap levelToVendorMap;
                    String level = st.nextToken();
                    String country = st.nextToken();
                    String garbage = st.nextToken();
                    String vendor = st.nextToken();
                    if (countryToLevelVendorsMap.containsKey(country)) {
                        levelToVendorMap = (HashMap)countryToLevelVendorsMap.get(country);
                    } else {
                        levelToVendorMap = new HashMap();
                        countryToLevelVendorsMap.put(country, levelToVendorMap);
                    }
                    int lvl = Integer.valueOf(level.substring(level.length() - 1));
                    levelToVendorMap.put(lvl, vendor.toUpperCase());
                }
                line = reader.readLine();
            }
        }
        catch (FileNotFoundException fnf) {
            throw new RuntimeException("MISSING REQUIRED SETUP FILE: " + fnf.getMessage(), fnf);
        }
        catch (IOException iOException) {
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
        }
        for (String country : countryToLevelVendorsMap.keySet()) {
            HashMap levelToVendorMap = (HashMap)countryToLevelVendorsMap.get(country);
            HashSet<String> vendors = new HashSet<String>(levelToVendorMap.values());
            if (vendors.size() == 1 && vendors.contains("TOMTOM")) continue;
            vendors.clear();
            for (int levelKey = 1; levelKey < 7; ++levelKey) {
                if (!levelToVendorMap.containsKey(levelKey)) continue;
                vendors.add((String)levelToVendorMap.get(levelKey));
                String vendorValue = XWG_GeographicReverseGeocodeSubHandler.buildVendorString(vendors);
                String mainKey = country + levelKey;
                map.put(mainKey, vendorValue);
            }
        }
        LBS_NonDefaultVendorMap = Collections.unmodifiableMap(map);
    }

    static String buildVendorString(HashSet<String> existingVendors) {
        StringBuilder vendorString = new StringBuilder();
        for (String vendor : existingVendors) {
            int cnt = 1;
            StringTokenizer toks = null;
            if (vendor.contains("/")) {
                toks = new StringTokenizer(vendor, "/");
                cnt = toks.countTokens();
            }
            for (int i = 0; i < cnt; ++i) {
                if (cnt > 1) {
                    String Vendor = toks.nextToken().trim();
                    String val = XWG_GeographicReverseGeocodeSubHandler.lookupVendorKey(Vendor);
                    if (XWG_GeographicReverseGeocodeSubHandler.checkForDupe(vendorString.toString(), val)) continue;
                    if (vendorString.length() != 0) {
                        vendorString.append(",");
                    }
                    vendorString.append(val);
                    continue;
                }
                if (vendorString.length() != 0) {
                    vendorString.append(",");
                }
                vendorString.append(XWG_GeographicReverseGeocodeSubHandler.lookupVendorKey(vendor));
            }
        }
        return vendorString.toString();
    }

    static boolean checkForDupe(String vendstr, String vendval) {
        StringWithTokens str = new StringWithTokens(vendstr.toString(), ",");
        for (String item : str) {
            if (!vendval.equals(item)) continue;
            return true;
        }
        return false;
    }

    static String lookupVendorKey(String vendor) {
        VendorDataType type = VendorDataType.ChangeDataSetInNumericValue((String)(DATATYPE_PREFIX + vendor));
        return String.valueOf(type.getDataType());
    }

    static {
        ArrayList<String> attributes = new ArrayList<String>();
        Properties properties = null;
        try {
            properties = DataManagerSettingsProvider.getInstance().getSettingsForCountry("XWG");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (properties != null) {
            attributes.add(properties.getProperty(GEOGRAPHIC_COUNTRY, GEOGRAPHIC_COUNTRY_DEFAULT));
            attributes.add(properties.getProperty(GEOGRAPHIC_ID, ID_DEFAULT));
            attributes.add(properties.getProperty(AREA_NAME_1, AREA_NAME_1_DEFAULT));
            attributes.add(properties.getProperty(AREA_NAME_2, AREA_NAME_2_DEFAULT));
            attributes.add(properties.getProperty(AREA_NAME_3, AREA_NAME_3_DEFAULT));
            attributes.add(properties.getProperty(AREA_NAME_4, AREA_NAME_4_DEFAULT));
            attributes.add(properties.getProperty(SUB_AREA_NAME_4, SUB_AREA_NAME_4_DEFAULT));
            requestedAttributes = Collections.unmodifiableList(attributes);
            ArrayList<String> engAttributes = new ArrayList<String>(attributes);
            engAttributes.add(properties.getProperty(GEOGRAPHIC_COUNTRY_ENG, GEOGRAPHIC_COUNTRY_ENG_DEFAULT));
            engAttributes.add(properties.getProperty(AREA_NAME_1_ENG, AREA_NAME_1_ENG_DEFAULT));
            engAttributes.add(properties.getProperty(AREA_NAME_2_ENG, AREA_NAME_2_ENG_DEFAULT));
            engAttributes.add(properties.getProperty(AREA_NAME_3_ENG, AREA_NAME_3_ENG_DEFAULT));
            engAttributes.add(properties.getProperty(AREA_NAME_4_ENG, AREA_NAME_4_ENG_DEFAULT));
            engAttributes.add(properties.getProperty(SUB_AREA_NAME_4_ENG, SUB_AREA_NAME_4_ENG_DEFAULT));
            requestedAttributesPlusEnglish = Collections.unmodifiableList(engAttributes);
            String vendorFile = properties.getProperty("LBS_INTERNAL_VENDOR_FILE");
            if (vendorFile != null) {
                XWG_GeographicReverseGeocodeSubHandler.initializeLBS_SpecialVendorMap(new File(vendorFile));
            } else {
                LBS_NonDefaultVendorMap = Collections.unmodifiableMap(new HashMap());
            }
        } else {
            throw new RuntimeException("MISSING XWG SETTINGS CONTAINING REQUIRED SETUP FILE KEY: LBS_INTERNAL_VENDOR_FILE");
        }
    }
}

