/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.XWG.singleline;

import com.mapinfo.mapmarker.XWG.singleline.XWG_AddressSplit;
import com.mapinfo.mapmarker.common.Address;
import com.mapinfo.mapmarker.core.singleline.IAddressParsing;
import com.mapinfo.mapmarker.utils.StringUtilities;
import java.util.Comparator;
import java.util.StringTokenizer;
import java.util.regex.Pattern;

public class TokenPatternRule
implements Comparator<IAddressParsing> {
    private static String[] invalidRegexes;
    private static final Pattern[] invalidPatterns;
    private static String[] validRegexes;
    private static final Pattern[] validPatterns;

    @Override
    public int compare(IAddressParsing o1, IAddressParsing o2) {
        int words2;
        int mix2;
        int mix1;
        int num2;
        XWG_AddressSplit split1 = (XWG_AddressSplit)o1.getSplit();
        XWG_AddressSplit split2 = (XWG_AddressSplit)o2.getSplit();
        int num1 = split1.countPureNumerics();
        if (num1 + (num2 = split2.countPureNumerics()) + (mix1 = split1.countMixedNumerics()) + (mix2 = split2.countMixedNumerics()) == 0) {
            return 0;
        }
        String pat1 = new String(split1.getTagPattern());
        String pat2 = new String(split2.getTagPattern());
        if (this.isValid(pat1)) {
            if (!this.isValid(pat2)) {
                return -1;
            }
        } else {
            if (this.isValid(pat2)) {
                return 1;
            }
            if (num1 + mix1 > num2 + mix2) {
                return 1;
            }
            if (num1 + mix1 < num2 + mix2) {
                return -1;
            }
            return 0;
        }
        if (num1 + mix1 > num2 + mix2) {
            return 1;
        }
        if (num1 + mix1 < num2 + mix2) {
            return -1;
        }
        int words1 = split1.countOther();
        if (words1 > (words2 = split2.countOther())) {
            return -1;
        }
        if (words1 < words2) {
            return 1;
        }
        return 0;
    }

    private boolean isInvalid(String token) {
        for (Pattern pattern : invalidPatterns) {
            if (!pattern.matcher(token).matches()) continue;
            return true;
        }
        return false;
    }

    private boolean isValid(String token) {
        for (Pattern pattern : validPatterns) {
            if (!pattern.matcher(token).matches()) continue;
            return true;
        }
        return false;
    }

    private StringTokenizer tokenize(IAddressParsing parsing) {
        Address split = parsing.getSplit().getAddress();
        String post = split.getPostAddress();
        if (post == null) {
            return null;
        }
        return new StringTokenizer(post);
    }

    private int countNonNumericTokens(StringTokenizer st) {
        int result = 0;
        while (st.hasMoreTokens()) {
            String tok = st.nextToken();
            if (StringUtilities.hasNumeric((String)tok)) continue;
            ++result;
        }
        return result;
    }

    static {
        int i;
        invalidRegexes = new String[]{"\\bO*[NM]O+[NM]O*\\b", "\\bO*[NM][NM][NM]+O\\b*", "\\bO+[NM]+O+\\b"};
        validRegexes = new String[]{"\\b[NM]?[NM]?O*\\b", "\\bO*[NM]?[NM]?\\b"};
        validPatterns = new Pattern[validRegexes.length];
        for (i = 0; i < validRegexes.length; ++i) {
            TokenPatternRule.validPatterns[i] = Pattern.compile(validRegexes[i]);
        }
        invalidPatterns = new Pattern[invalidRegexes.length];
        for (i = 0; i < invalidRegexes.length; ++i) {
            TokenPatternRule.invalidPatterns[i] = Pattern.compile(invalidRegexes[i]);
        }
    }
}

