/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.XWG.singleline;

import com.mapinfo.mapmarker.IConstraints;
import com.mapinfo.mapmarker.XWG.XWGUtils;
import com.mapinfo.mapmarker.XWG.singleline.PostAddressFieldCountRule;
import com.mapinfo.mapmarker.XWG.singleline.TokenPatternRule;
import com.mapinfo.mapmarker.XWG.singleline.XWG_AddressParsing;
import com.mapinfo.mapmarker.XWG.singleline.XWG_AddressSplit;
import com.mapinfo.mapmarker.XWG.singleline.XWG_SingleLineSplitHelper;
import com.mapinfo.mapmarker.XWG.singleline.filters.EndingStLastlineTokenFilter;
import com.mapinfo.mapmarker.XWG.singleline.filters.IllegalLastlineTokenFilter;
import com.mapinfo.mapmarker.XWG.singleline.filters.LastLineStartOrEndsWithPostTypeTokenFilter;
import com.mapinfo.mapmarker.XWG.singleline.filters.MainEndsInPreTypeTokenFilter;
import com.mapinfo.mapmarker.common.Address;
import com.mapinfo.mapmarker.core.parser.ParserException;
import com.mapinfo.mapmarker.core.singleline.IAddressParsing;
import com.mapinfo.mapmarker.core.singleline.IAddressSplit;
import com.mapinfo.mapmarker.core.singleline.filters.NoPostAddressFilter;
import com.mapinfo.mapmarker.core.singleline.parser.CoreSingleLineParser;
import com.mapinfo.mapmarker.core.singleline.parser.IAddressSplitFilter;
import com.mapinfo.mapmarker.utils.ISO3166;
import com.mapinfo.mapmarker.utils.StringUtilities;
import com.mapinfo.mapmarker.utils.TaggedTokenList;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;

public class XWG_SingleLineParser
extends CoreSingleLineParser {
    private static final int MAX_PARSINGS_RETURNED = 30;
    private static final List<Comparator<IAddressParsing>> m_rules;
    private static final List<IAddressSplitFilter> m_splitFilterRules;
    private static final String TAG_KEEP = "KEEP";
    private static final String XWG_STREET_POST_THOROUGHFARE = "STREET_POST_THOROUGHFARE";
    private static Properties properties;
    private static String postThoroughfareTypes;

    public XWG_SingleLineParser() {
        super(m_rules, m_splitFilterRules, 30);
    }

    protected List<IAddressParsing> createFinalList(List<IAddressParsing> parsings) {
        LinkedHashSet<IAddressParsing> set = new LinkedHashSet<IAddressParsing>(parsings);
        parsings.clear();
        parsings.addAll(set);
        return super.createFinalList(parsings);
    }

    protected XWG_AddressSplit makeAddressSplit(Address split, boolean fromDelimited, boolean fromReverseSplit) {
        return new XWG_AddressSplit(split, fromDelimited, fromReverseSplit);
    }

    protected void setCountryCode(Address input) {
        String test;
        String country;
        ISO3166 iso;
        String main = input.getMainAddress();
        if (StringUtilities.isEmpty((String)main) || main.length() < 5) {
            return;
        }
        String origCountry = input.getCountry();
        int countryIdx = main.indexOf(32);
        if (countryIdx == 3 && (iso = ISO3166.findCountryByISO3((String)main.substring(0, 3))) != null) {
            country = iso.getISO3Country();
            if (origCountry == null || StringUtilities.equalStrings((String)origCountry, (String)country)) {
                main = main.substring(countryIdx + 1);
                input.setCountry(country);
                input.setMainAddress(main);
                return;
            }
        }
        if ((countryIdx = main.lastIndexOf(32)) == main.length() - 4) {
            test = main.substring(countryIdx + 1);
            ISO3166 iso2 = ISO3166.findCountryByISO3((String)test);
            if (iso2 != null) {
                country = iso2.getISO3Country();
                if (origCountry == null || StringUtilities.equalStrings((String)origCountry, (String)country)) {
                    main = main.substring(0, countryIdx);
                    input.setCountry(country);
                    input.setMainAddress(main);
                    return;
                }
            } else if (origCountry == null && StringUtilities.equalStringsIgnoreCase((String)"NYC", (String)test)) {
                input.setCountry("USA");
                return;
            }
        } else if (origCountry == null && countryIdx == main.length() - 3 && StringUtilities.equalStringsIgnoreCase((String)"NY", (String)(test = main.substring(countryIdx + 1)))) {
            input.setCountry("USA");
            return;
        }
        if (StringUtilities.isEmpty((String)origCountry)) {
            TaggedTokenList toks = new TaggedTokenList(new StringTokenizer(main));
            int endIdx = toks.size() - 1;
            for (int i = 1; i <= endIdx && XWGUtils.returnCountryIso3FromString(toks.valuesAsString()) == null; ++i) {
                String isoCntry;
                String ctryPossible = toks.subList(i, toks.size()).valuesAsString();
                if (ctryPossible != null && i == endIdx && ctryPossible.length() == 2) {
                    ctryPossible = null;
                }
                if ((isoCntry = XWGUtils.returnCountryIso3FromString(ctryPossible)) == null) continue;
                for (int j = 0; j < i; ++j) {
                    toks.setTag(j, TAG_KEEP);
                }
                input.setCountry(isoCntry);
                input.setMainAddress(toks.getTaggedTokenString(TAG_KEEP));
                return;
            }
        }
    }

    protected List<IAddressSplit> createSplits(Address input, IConstraints constraints) {
        this.setCountryCode(input);
        String country = input.getCountry();
        String main = input.getMainAddress();
        if (main == null) {
            return XWG_SingleLineSplitHelper.createSplits("", country);
        }
        return XWG_SingleLineSplitHelper.createSplits(main, country);
    }

    public List<IAddressParsing> parse(Address input, IConstraints constraints) throws ParserException {
        this.removeStreetInfo(input);
        return super.parse(input, constraints);
    }

    private void removeAllCommas(Address input) {
        String mainAddress = input.getMainAddress();
        if (!StringUtilities.isEmpty((String)mainAddress) && mainAddress.indexOf(",") > -1) {
            input.setMainAddress(mainAddress.replaceAll(",", " "));
        }
    }

    protected IAddressParsing makeAddressParsing(IAddressSplit split, Address[] parse) {
        return new XWG_AddressParsing(split, parse);
    }

    void removeStreetInfo(Address input) {
        String[] thoroughfareTypes = postThoroughfareTypes.split(",");
        String mainAddress = input.getMainAddress();
        int indexOf = -1;
        if (mainAddress != null) {
            for (String thoroughfare : thoroughfareTypes) {
                indexOf = mainAddress.indexOf(thoroughfare);
                if (indexOf == -1 || indexOf == 0) continue;
                String regex = ".*" + thoroughfare;
                input.setMainAddress(mainAddress.replaceFirst(regex, ""));
                break;
            }
        }
    }

    static {
        properties = null;
        postThoroughfareTypes = null;
        ArrayList<Comparator<IAddressParsing>> result = new ArrayList<Comparator<IAddressParsing>>();
        result.add(new TokenPatternRule());
        result.add(new PostAddressFieldCountRule());
        m_rules = Collections.unmodifiableList(result);
        ArrayList<Object> splitFilterRules = new ArrayList<Object>();
        splitFilterRules.add(new NoPostAddressFilter());
        splitFilterRules.add(new IllegalLastlineTokenFilter());
        splitFilterRules.add(new EndingStLastlineTokenFilter());
        splitFilterRules.add(new MainEndsInPreTypeTokenFilter());
        splitFilterRules.add(new LastLineStartOrEndsWithPostTypeTokenFilter());
        m_splitFilterRules = Collections.unmodifiableList(splitFilterRules);
        properties = new Properties();
        try {
            properties.load(XWG_SingleLineParser.class.getResourceAsStream("XWG_ThoroughfareTypes.properties"));
            postThoroughfareTypes = (String)properties.get(XWG_STREET_POST_THOROUGHFARE);
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to load XWG_ThoroughfareTypes.properties");
        }
    }
}

