/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.XWG.singleline;

import com.mapinfo.mapmarker.XWG.singleline.XWG_AddressSplit;
import com.mapinfo.mapmarker.common.Address;
import com.mapinfo.mapmarker.common.AddressImpl;
import com.mapinfo.mapmarker.core.singleline.IAddressSplit;
import com.mapinfo.mapmarker.utils.StringUtilities;
import com.mapinfo.mapmarker.utils.StringWithTokens;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.regex.Pattern;

public class XWG_SingleLineSplitHelper {
    static final Set<String> commonPostTypes;
    static final Set<String> commonPreTypes;
    static final Set<String> commonPreOrPostTypes;
    static final Set<String> exclusiveStreetLineIndicators;
    static final Pattern commonLastlinePattern;

    protected static IAddressSplit setupNewSplit(String main, String post, String country, boolean bDelim, boolean bReverse) {
        AddressImpl tempAddress = new AddressImpl();
        tempAddress.setMainAddress(main);
        tempAddress.setPostAddress(post);
        tempAddress.setCountry(country);
        return new XWG_AddressSplit((Address)tempAddress, bDelim, bReverse);
    }

    protected static void addNewSplits(List<IAddressSplit> list, IAddressSplit newSplit) {
        String post = newSplit.getAddress().getPostAddress();
        if (StringUtilities.isEmpty((String)post)) {
            return;
        }
        if (!list.contains(newSplit)) {
            list.add(newSplit);
        }
    }

    public static List<IAddressSplit> createSplits(String input, String country) {
        String singleline = input;
        ArrayList<IAddressSplit> splits = new ArrayList<IAddressSplit>();
        splits.add(XWG_SingleLineSplitHelper.setupNewSplit(null, singleline, country, false, false));
        StringWithTokens swt = new StringWithTokens(singleline);
        int tokenCount = swt.size();
        if (tokenCount < 2) {
            return splits;
        }
        if (tokenCount == 2) {
            XWG_SingleLineSplitHelper.splitAtChar(' ', singleline, country, splits);
            return splits;
        }
        Object suggestedSplits = null;
        XWG_SingleLineSplitHelper.splitAtChar(',', singleline, country, splits);
        XWG_SingleLineSplitHelper.splitAtChar(';', singleline, country, splits);
        XWG_SingleLineSplitHelper.splitAtStringMidpoint(swt, singleline, country, splits);
        XWG_SingleLineSplitHelper.splitAtTokenMidpoint(swt, singleline, country, splits);
        XWG_SingleLineSplitHelper.splitAtTypeToken(swt, singleline, country, splits);
        XWG_SingleLineSplitHelper.splitAtInteriorNumericToken(swt, singleline, country, splits);
        XWG_SingleLineSplitHelper.splitAtEachInstanceOfChar(',', singleline, country, splits);
        return splits;
    }

    public static void splitAtChar(char cSplit, String singleline, String country, List<IAddressSplit> list) {
        int idx = singleline.indexOf(cSplit);
        if (idx > 0 && idx == singleline.lastIndexOf(cSplit)) {
            int breakIdx = idx + 1;
            if (cSplit == ' ') {
                breakIdx = idx;
            }
            String main = singleline.substring(0, breakIdx);
            String post = singleline.substring(idx + 1).trim();
            XWG_SingleLineSplitHelper.addNewSplits(list, XWG_SingleLineSplitHelper.setupNewSplit(main, post, country, true, false));
            XWG_SingleLineSplitHelper.addNewSplits(list, XWG_SingleLineSplitHelper.setupNewSplit(post, main, country, true, true));
        }
    }

    public static void splitAtEachInstanceOfChar(char cSplit, String singleline, String country, List<IAddressSplit> list) {
        int idx = singleline.indexOf(cSplit);
        while (idx > 0) {
            int breakIdx = idx + 1;
            if (cSplit == ' ') {
                breakIdx = idx;
            }
            String main = singleline.substring(0, breakIdx);
            String post = singleline.substring(idx + 1).trim();
            XWG_SingleLineSplitHelper.addNewSplits(list, XWG_SingleLineSplitHelper.setupNewSplit(main, post, country, true, false));
            XWG_SingleLineSplitHelper.addNewSplits(list, XWG_SingleLineSplitHelper.setupNewSplit(post, main, country, true, true));
            if (idx > singleline.length() - 3) break;
            idx = singleline.indexOf(cSplit, idx + 2);
        }
    }

    protected static String buildTokenString(StringWithTokens swt, int start) {
        return XWG_SingleLineSplitHelper.buildTokenString(swt, start, swt.size());
    }

    protected static String buildTokenString(StringWithTokens swt, int start, int end) {
        StringBuilder sb = new StringBuilder();
        for (int i = start; i < end; ++i) {
            if (sb.length() != 0) {
                sb.append(' ');
            }
            sb.append(swt.getToken(i));
        }
        return sb.toString();
    }

    public static void splitAtTokenMidpoint(StringWithTokens swt, String singleline, String country, List<IAddressSplit> list) {
        int count = swt.size();
        int tokenMidpoint = count / 2;
        boolean bOddNumberTokens = count % 2 == 1;
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < count; ++i) {
            String token = swt.getToken(i);
            if (i == tokenMidpoint) {
                String main = sb.toString();
                String post = XWG_SingleLineSplitHelper.buildTokenString(swt, i);
                XWG_SingleLineSplitHelper.addNewSplits(list, XWG_SingleLineSplitHelper.setupNewSplit(main, post, country, false, false));
                XWG_SingleLineSplitHelper.addNewSplits(list, XWG_SingleLineSplitHelper.setupNewSplit(post, main, country, false, true));
                if (bOddNumberTokens) {
                    sb.append(' ');
                    sb.append(token);
                    main = sb.toString();
                    post = XWG_SingleLineSplitHelper.buildTokenString(swt, i + 1);
                    XWG_SingleLineSplitHelper.addNewSplits(list, XWG_SingleLineSplitHelper.setupNewSplit(main, post, country, false, false));
                    XWG_SingleLineSplitHelper.addNewSplits(list, XWG_SingleLineSplitHelper.setupNewSplit(post, main, country, false, true));
                }
                return;
            }
            if (sb.length() != 0) {
                sb.append(' ');
            }
            sb.append(token);
        }
    }

    public static void splitAtStringMidpoint(StringWithTokens swt, String singleline, String country, List<IAddressSplit> list) {
        int startPt = 0;
        int len = singleline.length();
        int count = swt.size();
        int stringMidpoint = startPt + len / 2;
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < count; ++i) {
            String token = swt.getToken(i);
            if (sb.length() == stringMidpoint) {
                String main = sb.toString();
                String post = XWG_SingleLineSplitHelper.buildTokenString(swt, i);
                XWG_SingleLineSplitHelper.addNewSplits(list, XWG_SingleLineSplitHelper.setupNewSplit(main, post, country, false, false));
                XWG_SingleLineSplitHelper.addNewSplits(list, XWG_SingleLineSplitHelper.setupNewSplit(post, main, country, false, true));
                return;
            }
            if (sb.length() < stringMidpoint && sb.length() + token.length() + 1 > stringMidpoint) {
                String main = sb.toString();
                String post = XWG_SingleLineSplitHelper.buildTokenString(swt, i);
                XWG_SingleLineSplitHelper.addNewSplits(list, XWG_SingleLineSplitHelper.setupNewSplit(main, post, country, false, false));
                XWG_SingleLineSplitHelper.addNewSplits(list, XWG_SingleLineSplitHelper.setupNewSplit(post, main, country, false, true));
                sb.append(' ');
                sb.append(token);
                main = sb.toString();
                post = XWG_SingleLineSplitHelper.buildTokenString(swt, i + 1);
                XWG_SingleLineSplitHelper.addNewSplits(list, XWG_SingleLineSplitHelper.setupNewSplit(main, post, country, false, false));
                XWG_SingleLineSplitHelper.addNewSplits(list, XWG_SingleLineSplitHelper.setupNewSplit(post, main, country, false, true));
                return;
            }
            if (sb.length() != 0) {
                sb.append(' ');
            }
            sb.append(token);
        }
    }

    public static void splitAtTypeToken(StringWithTokens swt, String singleline, String country, List<IAddressSplit> list) {
        int tokenCount = swt.size();
        StringBuilder sb = new StringBuilder(singleline.length());
        for (int i = 0; i < tokenCount; ++i) {
            boolean bShortToken;
            boolean bFoundPostType;
            String token = swt.getToken(i);
            String tokenUpper = token.toUpperCase();
            boolean bFoundPreType = commonPreTypes.contains(tokenUpper) || commonPreOrPostTypes.contains(tokenUpper);
            boolean bl = bFoundPostType = commonPostTypes.contains(tokenUpper) || commonPreOrPostTypes.contains(tokenUpper);
            if (!bFoundPreType && !bFoundPostType) {
                if (sb.length() > 0) {
                    sb.append(' ');
                }
                sb.append(token);
                continue;
            }
            boolean bAppendedToken = false;
            if (bFoundPreType && sb.length() > 0) {
                String newPost = sb.toString();
                String newMain = XWG_SingleLineSplitHelper.buildTokenString(swt, i);
                XWG_SingleLineSplitHelper.addNewSplits(list, XWG_SingleLineSplitHelper.setupNewSplit(newMain, newPost, country, false, true));
                sb = new StringBuilder();
                bAppendedToken = true;
            }
            if (bFoundPostType && i + 1 < tokenCount) {
                sb.append(' ');
                sb.append(token);
                bAppendedToken = true;
                String main = sb.toString();
                String post = XWG_SingleLineSplitHelper.buildTokenString(swt, i + 1);
                XWG_SingleLineSplitHelper.addNewSplits(list, XWG_SingleLineSplitHelper.setupNewSplit(main, post, country, false, false));
            }
            if (sb.length() > 0) {
                sb.append(' ');
            }
            sb.append(token);
            if (!bFoundPreType) continue;
            if (++i == tokenCount) {
                return;
            }
            token = swt.getToken(i);
            sb.append(' ');
            sb.append(token);
            if (i == tokenCount - 1) {
                String newMain = sb.toString();
                String newPost = XWG_SingleLineSplitHelper.buildTokenString(swt, 0, i - 1);
                XWG_SingleLineSplitHelper.addNewSplits(list, XWG_SingleLineSplitHelper.setupNewSplit(newMain, newPost, country, false, true));
                return;
            }
            if (i + 2 > tokenCount) continue;
            boolean bl2 = bShortToken = token.length() < 4;
            if (!bShortToken) {
                if (bAppendedToken) {
                    return;
                }
                String main = sb.toString();
                String post = XWG_SingleLineSplitHelper.buildTokenString(swt, i + 1);
                XWG_SingleLineSplitHelper.addNewSplits(list, XWG_SingleLineSplitHelper.setupNewSplit(main, post, country, false, false));
                return;
            }
            token = swt.getToken(++i);
            boolean bAddedExtraTokens = false;
            while (bShortToken && token.length() < 4 && i <= tokenCount - 2) {
                sb.append(' ');
                sb.append(token);
                token = swt.getToken(++i);
                bShortToken = token.length() < 4;
                bAddedExtraTokens = true;
            }
            if (bAddedExtraTokens && (token.length() > 3 || i == tokenCount - 1)) {
                sb.append(' ');
                sb.append(token);
            }
            String main = sb.toString();
            int postIdx = i;
            if (bAddedExtraTokens && bAppendedToken && ++postIdx == tokenCount) {
                return;
            }
            if (postIdx < tokenCount) {
                String post = XWG_SingleLineSplitHelper.buildTokenString(swt, postIdx);
                XWG_SingleLineSplitHelper.addNewSplits(list, XWG_SingleLineSplitHelper.setupNewSplit(main, post, country, false, false));
            }
            return;
        }
    }

    public static void splitAtInteriorNumericToken(StringWithTokens swt, String singleline, String country, List<IAddressSplit> list) {
        int endingBreakpoint;
        if (!StringUtilities.hasNumeric((String)singleline)) {
            return;
        }
        int tokenCount = swt.size();
        int startingBreakpoint = 0;
        boolean bStartsWithNumeric = StringUtilities.hasNumeric((String)swt.getFirstToken());
        boolean bEndsWithNumeric = StringUtilities.hasNumeric((String)swt.getLastToken());
        if (bStartsWithNumeric) {
            ++startingBreakpoint;
            while (startingBreakpoint < tokenCount && StringUtilities.hasNumeric((String)swt.getToken(startingBreakpoint))) {
                ++startingBreakpoint;
            }
        }
        while (startingBreakpoint < tokenCount && !StringUtilities.hasNumeric((String)swt.getToken(startingBreakpoint))) {
            ++startingBreakpoint;
        }
        if (!bStartsWithNumeric) {
            ++startingBreakpoint;
        }
        if (startingBreakpoint >= tokenCount) {
            return;
        }
        String first = XWG_SingleLineSplitHelper.buildTokenString(swt, 0, startingBreakpoint);
        String remainder = XWG_SingleLineSplitHelper.buildTokenString(swt, startingBreakpoint++);
        XWG_SingleLineSplitHelper.addNewSplits(list, XWG_SingleLineSplitHelper.setupNewSplit(first, remainder, country, false, false));
        XWG_SingleLineSplitHelper.addNewSplits(list, XWG_SingleLineSplitHelper.setupNewSplit(remainder, first, country, false, true));
        for (endingBreakpoint = tokenCount - 2; bEndsWithNumeric && endingBreakpoint >= 0 && StringUtilities.hasNumeric((String)swt.getToken(endingBreakpoint)); --endingBreakpoint) {
        }
        if (endingBreakpoint <= 0) {
            return;
        }
        while (endingBreakpoint >= 0 && !StringUtilities.hasNumeric((String)swt.getToken(endingBreakpoint))) {
            --endingBreakpoint;
        }
        if (endingBreakpoint <= 0) {
            return;
        }
        if (bEndsWithNumeric) {
            ++endingBreakpoint;
        }
        remainder = XWG_SingleLineSplitHelper.buildTokenString(swt, endingBreakpoint);
        first = XWG_SingleLineSplitHelper.buildTokenString(swt, 0, endingBreakpoint);
        XWG_SingleLineSplitHelper.addNewSplits(list, XWG_SingleLineSplitHelper.setupNewSplit(first, remainder, country, false, false));
        XWG_SingleLineSplitHelper.addNewSplits(list, XWG_SingleLineSplitHelper.setupNewSplit(remainder, first, country, false, true));
    }

    public static boolean containsIllegalLastlineTokens(String lastline) {
        StringTokenizer st = new StringTokenizer(lastline, " .,;-");
        while (st.hasMoreTokens()) {
            String token = st.nextToken().toUpperCase();
            if (!exclusiveStreetLineIndicators.contains(token)) continue;
            if ("STE".equals(token)) {
                if (st.hasMoreTokens()) {
                    token = st.nextToken();
                    return token.length() == 1 || StringUtilities.hasNumeric((String)token);
                }
                return true;
            }
            return true;
        }
        return false;
    }

    public static boolean isPreType(String testType) {
        return commonPreTypes.contains(testType.toUpperCase());
    }

    static {
        String regex = "\\b[A-Z]{3,} ([A-Z]{2,3}) (\\d{4,5})\\b";
        commonLastlinePattern = Pattern.compile(regex);
        HashSet<String> tmpSet = new HashSet<String>();
        tmpSet.add("ST");
        tmpSet.add("STREET");
        tmpSet.add("AVE");
        tmpSet.add("RD");
        tmpSet.add("ROAD");
        tmpSet.add("STRASSE");
        commonPostTypes = Collections.unmodifiableSet(tmpSet);
        tmpSet = new HashSet();
        tmpSet.add("RUE");
        tmpSet.add("CALLE");
        tmpSet.add("AV");
        tmpSet.add("AVENIDA");
        commonPreTypes = Collections.unmodifiableSet(tmpSet);
        tmpSet = new HashSet();
        tmpSet.add("AVENUE");
        tmpSet.add("HIGHWAY");
        tmpSet.add("ROUTE");
        commonPreOrPostTypes = Collections.unmodifiableSet(tmpSet);
        tmpSet = new HashSet();
        tmpSet.add("AVENUE");
        tmpSet.add("HIGHWAY");
        tmpSet.add("ROUTE");
        tmpSet.add("RUE");
        tmpSet.add("CALLE");
        tmpSet.add("AV");
        tmpSet.add("AVENIDA");
        tmpSet.add("RD");
        tmpSet.add("ROAD");
        tmpSet.add("STREET");
        tmpSet.add("STRASSE");
        tmpSet.add("BOX");
        tmpSet.add("SUITE");
        tmpSet.add("STE");
        exclusiveStreetLineIndicators = Collections.unmodifiableSet(tmpSet);
    }
}

