/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.XWG.singleline.eval;

import com.mapinfo.mapmarker.GeocodeResult;
import com.mapinfo.mapmarker.IConstraints;
import com.mapinfo.mapmarker.IHandler;
import com.mapinfo.mapmarker.XWG.XWG_Handler;
import com.mapinfo.mapmarker.XWG.XWG_InternalGeographicCandidate;
import com.mapinfo.mapmarker.XWG.filters.GeographicPrecisionFilterRule;
import com.mapinfo.mapmarker.XWG.filters.KeepHigherScoringDuplicateFilterRule;
import com.mapinfo.mapmarker.XWG.filters.SingleLineCountrytFilterRule;
import com.mapinfo.mapmarker.XWG.filters.SingleLineIncludesArea4FilterRule;
import com.mapinfo.mapmarker.XWG.filters.SingleLineInputFilterRule;
import com.mapinfo.mapmarker.XWG.filters.SingleLineInputTokenMatchFilterRule;
import com.mapinfo.mapmarker.XWG.filters.SingleLineMoreSpecificMatchFilterRule;
import com.mapinfo.mapmarker.common.Address;
import com.mapinfo.mapmarker.common.AddressImpl;
import com.mapinfo.mapmarker.common.ICandidate;
import com.mapinfo.mapmarker.common.InternalGeographicCandidate;
import com.mapinfo.mapmarker.common.filters.ICloseMatchFilterRule;
import com.mapinfo.mapmarker.core.singleline.ISingleLineResultEval;
import com.mapinfo.mapmarker.core.singleline.SingleLineResult;
import com.mapinfo.mapmarker.utils.DebugLevel;
import com.mapinfo.mapmarker.utils.MMJLog;
import com.mapinfo.mapmarker.utils.StringUtilities;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class XWG_SingleLineEval
implements ISingleLineResultEval {
    SingleLineResult combinedGeographicResults = null;
    SingleLineResult combinedPostalResults = null;
    ICloseMatchFilterRule[] singleResultGeoFilterRules = new ICloseMatchFilterRule[]{new GeographicPrecisionFilterRule()};
    ICloseMatchFilterRule[] multiResultGeoFilterRules = new ICloseMatchFilterRule[]{new SingleLineCountrytFilterRule(), new SingleLineInputFilterRule(), new SingleLineMoreSpecificMatchFilterRule(), new KeepHigherScoringDuplicateFilterRule(), new SingleLineInputTokenMatchFilterRule(), new SingleLineIncludesArea4FilterRule()};

    public void evaluate(SingleLineResult current) {
        List candidateList = current.getConstraints().getHandler().getMatchResults();
        if (candidateList != null && !candidateList.isEmpty()) {
            if (candidateList.get(0) instanceof XWG_InternalGeographicCandidate) {
                if (this.combinedGeographicResults == null) {
                    this.filterGeographicCloseMatches(current.getConstraints().getHandler(), candidateList, this.singleResultGeoFilterRules, current.getGeoResult().getNumberCloseCandidates(), false);
                    this.combinedGeographicResults = current;
                } else {
                    this.evaluateByType(current, this.combinedGeographicResults);
                }
            } else if (this.combinedPostalResults == null) {
                this.combinedPostalResults = current;
            } else {
                this.evaluateByType(current, this.combinedPostalResults);
            }
        } else if (this.combinedGeographicResults == null) {
            this.combinedGeographicResults = current;
        } else if (this.combinedPostalResults == null) {
            this.combinedPostalResults = current;
        }
    }

    public void evaluateByType(SingleLineResult current, SingleLineResult compositeResults) {
        GeocodeResult gr = compositeResults.getGeoResult();
        ArrayList candidateList = compositeResults.getConstraints().getHandler().getMatchResults();
        if (candidateList == null) {
            candidateList = new ArrayList();
            compositeResults.getConstraints().getHandler().setMatchResults(candidateList);
        }
        int curClose = current.getGeoResult().getNumberCloseCandidates();
        List currentCandidates = current.getConstraints().getHandler().getMatchResults();
        if (currentCandidates != null) {
            if (compositeResults == this.combinedGeographicResults) {
                curClose = this.filterGeographicCloseMatches(current.getConstraints().getHandler(), currentCandidates, this.singleResultGeoFilterRules, curClose, true);
                current.getGeoResult().setNumberCloseCandidates(curClose);
                this.combineGeographicResults(current);
            } else {
                this.addAndSort(gr, candidateList, currentCandidates, true);
                compositeResults.getConstraints().getHandler().setGeocodeResult(gr);
                compositeResults.getConstraints().getHandler().setMatchResults(candidateList);
            }
        }
    }

    public boolean shouldStop() {
        SingleLineResult best = this.getBest();
        if (best == null) {
            return false;
        }
        if (best.getConstraints().getHandler().getMatchResults() == null || best.getConstraints().getHandler().getMatchResults().size() == 0) {
            return false;
        }
        if (!(best.getConstraints().getHandler().getMatchResults().get(0) instanceof XWG_InternalGeographicCandidate)) {
            return false;
        }
        XWG_InternalGeographicCandidate bestCandidate = (XWG_InternalGeographicCandidate)((Object)best.getConstraints().getHandler().getMatchResults().get(0));
        if (!bestCandidate.isCloseMatch()) {
            return false;
        }
        if (StringUtilities.isEmpty((String)bestCandidate.getInputAreaName1()) && !StringUtilities.isEmpty((String)best.getConstraints().getHandler().getInputAddress().getMainAddress())) {
            return false;
        }
        if (bestCandidate.getPrecision() != 10 && bestCandidate.getPrecision() != 11) {
            return false;
        }
        if (bestCandidate.getAreaName1Score() < 0.97) {
            return false;
        }
        if (bestCandidate.getPrecision() == 10 && bestCandidate.getAreaName3Score() < 0.97) {
            return false;
        }
        if (bestCandidate.getPrecision() == 11 && bestCandidate.getAreaName4Score() < 0.97) {
            return false;
        }
        return bestCandidate.hadUnadjustedAreaName3();
    }

    public SingleLineResult getBest() {
        int postalCount = 0;
        if (this.combinedPostalResults != null) {
            postalCount = this.combinedPostalResults.getGeoResult().getNumberCloseCandidates();
        }
        int geoCount = 0;
        if (this.combinedGeographicResults != null) {
            geoCount = this.combinedGeographicResults.getGeoResult().getNumberCloseCandidates();
        }
        if (geoCount == 1 && this.combinedGeographicResults.getGeoResult().isUniqueMatchFound()) {
            return this.combinedGeographicResults;
        }
        if (geoCount > 0 && postalCount > 0) {
            XWG_Handler handler = (XWG_Handler)this.combinedGeographicResults.getConstraints().getHandler();
            XWG_InternalGeographicCandidate candidate = (XWG_InternalGeographicCandidate)((Object)handler.getMatchResults().get(0));
            int precision = candidate.getPrecision();
            if (precision >= 10) {
                return this.combinedGeographicResults;
            }
            return this.combinedPostalResults;
        }
        if (geoCount >= postalCount && this.combinedGeographicResults != null) {
            return this.combinedGeographicResults;
        }
        if (this.combinedPostalResults != null) {
            return this.combinedPostalResults;
        }
        return null;
    }

    public int filterGeographicCloseMatches(IHandler handler, List geographicCandidates, ICloseMatchFilterRule[] closeMatchRules, int closeCount, boolean ignoreResort) {
        InternalGeographicCandidate otherCandidate;
        Address[] inputAddresses = handler.getParsedAddressArray();
        if (closeMatchRules == null) {
            return closeCount;
        }
        boolean bDebug = DebugLevel.getDebugLevel((int)4) >= 2;
        boolean resort = false;
        Iterator candidateIterator = geographicCandidates.iterator();
        InternalGeographicCandidate bestCandidate = (InternalGeographicCandidate)candidateIterator.next();
        int newCloseCount = 1;
        while (candidateIterator.hasNext() && (otherCandidate = (InternalGeographicCandidate)candidateIterator.next()).isCloseMatch()) {
            for (int i = 0; i < closeMatchRules.length; ++i) {
                if (!closeMatchRules[i].demoteOther(inputAddresses, (ICandidate)bestCandidate, (ICandidate)otherCandidate)) continue;
                if (bDebug) {
                    MMJLog.getLog().debug("XWG_SingleLineEval::filterGeographicCloseMatches candidate demoted by rule: " + closeMatchRules[i].getClass().getSimpleName());
                    MMJLog.getLog().debug("demoted candidate: " + otherCandidate);
                    MMJLog.getLog().debug("best candidate: " + bestCandidate);
                }
                resort = true;
                otherCandidate.setCloseMatchStatus(false);
                break;
            }
            if (!otherCandidate.isCloseMatch()) continue;
            ++newCloseCount;
        }
        if (resort && !ignoreResort) {
            Collections.reverse(geographicCandidates);
            Collections.sort(geographicCandidates);
            Collections.reverse(geographicCandidates);
        }
        return newCloseCount;
    }

    protected Address buildInputAsScored(SingleLineResult result) {
        IConstraints constraints = result.getConstraints();
        AddressImpl input = new AddressImpl(constraints.getHandler().getParsedAddress());
        if (constraints.containsCustomObjectKey((Object)"KEY_SWAPPED_INPUT_AN3_AN4")) {
            String tmp = input.getAreaName4();
            input.setAreaName4(input.getAreaName3());
            input.setAreaName3(tmp);
        } else if (constraints.containsCustomObjectKey((Object)"KEY_SWAPPED_INPUT_AN1_AN3")) {
            String tmp = input.getAreaName1();
            input.setAreaName1(input.getAreaName3());
            input.setAreaName3(tmp);
        }
        return input;
    }

    public int combineGeographicResults(SingleLineResult otherSingleLineResult) {
        InternalGeographicCandidate otherCandidate;
        InternalGeographicCandidate otherCandidate2;
        XWG_Handler currentHandler = (XWG_Handler)this.combinedGeographicResults.getConstraints().getHandler();
        XWG_Handler otherHandler = (XWG_Handler)otherSingleLineResult.getConstraints().getHandler();
        GeocodeResult currentResult = this.combinedGeographicResults.getGeoResult();
        GeocodeResult otherResult = otherSingleLineResult.getGeoResult();
        int curClose = currentResult.getNumberCloseCandidates();
        int otherClose = otherResult.getNumberCloseCandidates();
        List candidateList = currentHandler.getMatchResults();
        List otherCandidateList = otherHandler.getMatchResults();
        boolean resort = this.keepBetterScoringGeographicVersion(candidateList, otherCandidateList);
        if (otherCandidateList.isEmpty()) {
            return this.combine(this.combinedGeographicResults, otherSingleLineResult, 0, true);
        }
        if (candidateList.isEmpty()) {
            return this.combine(otherSingleLineResult, this.combinedGeographicResults, otherClose, true);
        }
        if (curClose == 0) {
            if (otherClose == 0) {
                return this.combine(this.combinedGeographicResults, otherSingleLineResult, 0, true);
            }
            return this.combine(otherSingleLineResult, this.combinedGeographicResults, otherClose, true);
        }
        Address[] inputAddresses = new Address[]{this.buildInputAsScored(this.combinedGeographicResults), this.buildInputAsScored(otherSingleLineResult)};
        boolean bDebug = DebugLevel.getDebugLevel((int)4) >= 2;
        Iterator otherIterator = otherCandidateList.iterator();
        XWG_InternalGeographicCandidate bestCandidate = (XWG_InternalGeographicCandidate)((Object)candidateList.get(0));
        int otherModifiedCloseCount = 0;
        InternalGeographicCandidate otherBestCandidate = null;
        while (otherIterator.hasNext() && (otherCandidate2 = (InternalGeographicCandidate)otherIterator.next()).isCloseMatch()) {
            for (int i = 0; i < this.multiResultGeoFilterRules.length; ++i) {
                if (!this.multiResultGeoFilterRules[i].demoteOther(inputAddresses, (ICandidate)bestCandidate, (ICandidate)otherCandidate2)) continue;
                if (bDebug) {
                    MMJLog.getLog().debug("XWG_SingleLineEval::combineGeographicResults candidate demoted by rule: " + this.multiResultGeoFilterRules[i].getClass().getSimpleName());
                    MMJLog.getLog().debug("demoted candidate: " + otherCandidate2);
                    MMJLog.getLog().debug("best candidate: " + (Object)((Object)bestCandidate));
                }
                resort = true;
                otherCandidate2.setCloseMatchStatus(false);
                break;
            }
            if (!otherCandidate2.isCloseMatch()) continue;
            ++otherModifiedCloseCount;
            if (otherBestCandidate != null) continue;
            otherBestCandidate = otherCandidate2;
        }
        if (otherModifiedCloseCount == 0) {
            return this.combine(this.combinedGeographicResults, otherSingleLineResult, curClose, true);
        }
        Iterator candidateIterator = candidateList.iterator();
        int curModifiedCloseCount = 0;
        Address tmpAddr = inputAddresses[0];
        inputAddresses[0] = inputAddresses[1];
        inputAddresses[1] = tmpAddr;
        while (candidateIterator.hasNext() && (otherCandidate = (InternalGeographicCandidate)candidateIterator.next()).isCloseMatch()) {
            for (int i = 0; i < this.multiResultGeoFilterRules.length; ++i) {
                if (!this.multiResultGeoFilterRules[i].demoteOther(inputAddresses, (ICandidate)otherBestCandidate, (ICandidate)otherCandidate)) continue;
                if (bDebug) {
                    MMJLog.getLog().debug("XWG_SingleLineEval::combineGeographicResults candidate demoted by rule: " + this.multiResultGeoFilterRules[i].getClass().getSimpleName());
                    MMJLog.getLog().debug("demoted candidate: " + otherCandidate);
                    MMJLog.getLog().debug("best candidate: " + otherBestCandidate);
                }
                resort = true;
                otherCandidate.setCloseMatchStatus(false);
                break;
            }
            if (!otherCandidate.isCloseMatch()) continue;
            ++curModifiedCloseCount;
        }
        if (curModifiedCloseCount == 0) {
            return this.combine(otherSingleLineResult, this.combinedGeographicResults, otherModifiedCloseCount, true);
        }
        if (!resort && curModifiedCloseCount > 0 && otherModifiedCloseCount > 0) {
            resort = true;
        }
        return this.combine(this.combinedGeographicResults, otherSingleLineResult, curModifiedCloseCount + otherModifiedCloseCount, resort);
    }

    protected int combine(SingleLineResult bestResult, SingleLineResult otherResult, int newTotalClose, boolean bSort) {
        this.addAndSort(bestResult.getGeoResult(), bestResult.getConstraints().getHandler().getMatchResults(), otherResult.getConstraints().getHandler().getMatchResults(), bSort);
        this.combinedGeographicResults = bestResult;
        return newTotalClose;
    }

    protected boolean keepBetterScoringGeographicVersion(List baseList, List toAdd) {
        boolean bMadeChanges = false;
        ArrayList<Long> candidateIDs = new ArrayList<Long>(baseList.size());
        for (Object candidate : baseList) {
            candidateIDs.add(((XWG_InternalGeographicCandidate)((Object)candidate)).getRecordID());
        }
        ArrayList<Integer> removeFromBaseIndexes = new ArrayList<Integer>();
        for (int toAddCandidateIdx = toAdd.size() - 1; toAddCandidateIdx >= 0; --toAddCandidateIdx) {
            XWG_InternalGeographicCandidate candidate = (XWG_InternalGeographicCandidate)((Object)toAdd.get(toAddCandidateIdx));
            long id = candidate.getRecordID();
            if (!candidateIDs.contains(id)) continue;
            int idx = candidateIDs.indexOf(id);
            XWG_InternalGeographicCandidate existingCand = (XWG_InternalGeographicCandidate)((Object)baseList.get(idx));
            if (existingCand.compareTo((Object)candidate) < 0) {
                removeFromBaseIndexes.add(idx);
            } else {
                toAdd.remove(toAddCandidateIdx);
            }
            bMadeChanges = true;
        }
        if (!removeFromBaseIndexes.isEmpty()) {
            Collections.sort(removeFromBaseIndexes);
            for (int i = removeFromBaseIndexes.size() - 1; i >= 0; --i) {
                int removeIDx = (Integer)removeFromBaseIndexes.get(i);
                baseList.remove(removeIDx);
            }
        }
        return bMadeChanges;
    }

    protected void addAndSort(GeocodeResult geocodeResult, List baseList, List toAdd, boolean bSort) {
        boolean bGeoCands;
        boolean bl = bGeoCands = baseList.size() > 0 && baseList.get(0) instanceof XWG_InternalGeographicCandidate;
        if (bGeoCands) {
            ArrayList<Long> candidateIDs = new ArrayList<Long>(baseList.size());
            for (Object candidate : baseList) {
                candidateIDs.add(((XWG_InternalGeographicCandidate)((Object)candidate)).getRecordID());
            }
            for (Object candidateObj : toAdd) {
                XWG_InternalGeographicCandidate candidate = (XWG_InternalGeographicCandidate)((Object)candidateObj);
                long id = candidate.getRecordID();
                if (!candidateIDs.contains(id)) {
                    baseList.add(candidate);
                    continue;
                }
                int idx = candidateIDs.indexOf(id);
                XWG_InternalGeographicCandidate existingCand = (XWG_InternalGeographicCandidate)((Object)baseList.get(idx));
                if (existingCand.compareTo((Object)candidate) >= 0) continue;
                baseList.remove(idx);
                baseList.add(idx, candidate);
            }
        } else {
            baseList.addAll(toAdd);
        }
        geocodeResult.setNumberCandidates(baseList.size());
        if (bSort) {
            Collections.reverse(baseList);
            Collections.sort(baseList);
            Collections.reverse(baseList);
        }
        int closeCount = 0;
        for (Object candidate : baseList) {
            if (!((ICandidate)candidate).isCloseMatch()) break;
            ++closeCount;
        }
        geocodeResult.setNumberCloseCandidates(closeCount);
    }
}

