/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.XWG.utils;

import com.mapinfo.mapmarker.MapMarkerInternalException;
import com.mapinfo.mapmarker.XWG.XWGInternalException;
import com.mapinfo.mapmarker.XWG.utils.IAlternatesProvider;
import com.mapinfo.mapmarker.utils.ISO3166;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class AlternatesProviderFactory {
    public static final String ALTERNATE_COUUNTRY_FILE = "/com/mapinfo/mapmarker/XWG/utils/country_names.properties";
    private static IAlternatesProvider m_countryAlternateProvider;
    private static final IAlternatesProvider m_noResultsProvider;
    private static final Map<String, IAlternatesProvider> m_areaName1Providers;
    private static final Map<String, IAlternatesProvider> m_areaName2Providers;

    public static IAlternatesProvider getCountryAlternatesProvider() throws MapMarkerInternalException {
        if (m_countryAlternateProvider == null) {
            InputStream stream = AlternatesProviderFactory.class.getResourceAsStream(ALTERNATE_COUUNTRY_FILE);
            if (stream == null) {
                throw new XWGInternalException(7700, new String[]{ALTERNATE_COUUNTRY_FILE});
            }
            boolean bSuccess = false;
            try {
                m_countryAlternateProvider = new CountryAlternateProvider(stream);
                bSuccess = true;
            }
            finally {
                block10: {
                    try {
                        stream.close();
                    }
                    catch (IOException IOEx) {
                        if (!bSuccess) break block10;
                        throw new XWGInternalException(7701, IOEx);
                    }
                }
            }
        }
        return m_countryAlternateProvider;
    }

    public static IAlternatesProvider getAreaName1AlternatesProvider(String country) throws MapMarkerInternalException {
        return AlternatesProviderFactory.getProvider(country, "areaName1", m_areaName1Providers);
    }

    public static IAlternatesProvider getAreaName2AlternatesProvider(String country) throws MapMarkerInternalException {
        return AlternatesProviderFactory.getProvider(country, "areaName2", m_areaName2Providers);
    }

    public static IAlternatesProvider getNoResultsProvider() {
        return m_noResultsProvider;
    }

    private static IAlternatesProvider getProvider(String country, String typeBaseName, Map<String, IAlternatesProvider> providers) throws MapMarkerInternalException {
        IAlternatesProvider provider = providers.get(country);
        if (provider != null) {
            return provider;
        }
        InputStream stream = AlternatesProviderFactory.getAlternatesStream(country, typeBaseName);
        if (stream == null) {
            providers.put(country, m_noResultsProvider);
            return m_noResultsProvider;
        }
        try {
            provider = AlternatesProviderFactory.getProvider(stream);
            providers.put(country, provider);
            return provider;
        }
        catch (IOException IOEx) {
            throw new XWGInternalException(7701, IOEx);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static IAlternatesProvider getProvider(InputStream stream) throws IOException, MapMarkerInternalException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(stream, "UTF-8"));
        boolean bSuccess = false;
        try {
            AlternatesProvider provider = new AlternatesProvider(reader);
            bSuccess = true;
            AlternatesProvider alternatesProvider = provider;
            return alternatesProvider;
        }
        finally {
            block7: {
                try {
                    reader.close();
                }
                catch (IOException IOEx) {
                    if (!bSuccess) break block7;
                    throw IOEx;
                }
            }
        }
    }

    private static InputStream getAlternatesStream(String country, String typeBaseName) {
        return AlternatesProviderFactory.class.getResourceAsStream("/com/mapinfo/mapmarker/XWG/utils/" + country + "_" + typeBaseName + "Alternates.properties");
    }

    static {
        m_noResultsProvider = new NoResultsAlternateProvider();
        m_areaName1Providers = new HashMap<String, IAlternatesProvider>();
        m_areaName2Providers = new HashMap<String, IAlternatesProvider>();
    }

    private static final class CountryAlternatesFileEntry {
        private final String m_countryISO;
        private final String m_alternate;

        public CountryAlternatesFileEntry(String entry) throws MapMarkerInternalException {
            try {
                this.m_countryISO = entry.substring(0, 3);
                this.m_alternate = entry.substring(4).trim();
            }
            catch (IndexOutOfBoundsException IOOBEx) {
                throw new XWGInternalException(7702, IOOBEx);
            }
        }

        public String getCountryISO() {
            return this.m_countryISO;
        }

        public String getAlternate() {
            return this.m_alternate;
        }
    }

    private static class CountryAlternateProvider
    implements IAlternatesProvider {
        private final Map<String, Set<String>> m_alternates;
        private final Map<String, String> m_AlternatesAsKeys;

        public CountryAlternateProvider(InputStream stream) throws MapMarkerInternalException {
            HashMap<String, Set<String>> alternates = new HashMap<String, Set<String>>();
            HashMap altsAsKeysmap = new HashMap();
            try {
                String s;
                BufferedReader reader = new BufferedReader(new InputStreamReader(stream, "UTF-8"));
                while ((s = reader.readLine()) != null) {
                    CountryAlternatesFileEntry e = new CountryAlternatesFileEntry(s);
                    if (e.getCountryISO().equals(e.getAlternate())) continue;
                    HashSet<String> countryAlts = (HashSet<String>)alternates.get(e.getCountryISO());
                    if (countryAlts == null) {
                        countryAlts = new HashSet<String>();
                        alternates.put(e.getCountryISO(), countryAlts);
                    }
                    countryAlts.add(e.getAlternate());
                }
                this.addISO3166Entries(alternates);
                HashMap alternates1 = new HashMap(alternates.size());
                int cnt = 0;
                for (Map.Entry e2 : alternates.entrySet()) {
                    cnt += ((Set)e2.getValue()).size() + 1;
                    alternates1.put(e2.getKey(), Collections.unmodifiableSet((Set)e2.getValue()));
                }
                HashMap<String, String> isoCountries = new HashMap<String, String>(cnt);
                for (Map.Entry e2 : alternates.entrySet()) {
                    Iterator iterator = ((Set)e2.getValue()).iterator();
                    String ctry = (String)e2.getKey();
                    while (iterator.hasNext()) {
                        isoCountries.put((String)iterator.next(), ctry);
                    }
                    isoCountries.put(ctry, ctry);
                }
                alternates = alternates1;
                altsAsKeysmap = isoCountries;
            }
            catch (IOException IOEx) {
                throw new XWGInternalException(7701, IOEx);
            }
            this.m_alternates = Collections.unmodifiableMap(alternates);
            this.m_AlternatesAsKeys = Collections.unmodifiableMap(altsAsKeysmap);
        }

        @Override
        public Collection<String> getAlternates(String areaName) {
            List<String> result = (List<String>)((Object)this.m_alternates.get(areaName));
            return result != null ? result : Collections.emptyList();
        }

        @Override
        public String getKeyForAlternate(String key) {
            if (key == null) {
                return null;
            }
            String isoCtry = this.m_AlternatesAsKeys.get(key.toUpperCase());
            return isoCtry;
        }

        private void addISO3166Entries(Map<String, Set<String>> entries) {
            for (ISO3166 ISO : ISO3166.getISOCountries()) {
                Set<String> countryEntries = entries.get(ISO.getISO3Country());
                if (countryEntries == null) {
                    countryEntries = new HashSet<String>(2);
                    entries.put(ISO.getISO3Country(), countryEntries);
                }
                countryEntries.add(ISO.getISO2Country());
                countryEntries.add(ISO.getDisplayCountry());
            }
        }
    }

    private static class AlternatesProvider
    implements IAlternatesProvider {
        private final Map<String, List<String>> m_alternates = new HashMap<String, List<String>>();

        public AlternatesProvider(BufferedReader reader) throws IOException, MapMarkerInternalException {
            String s;
            while ((s = reader.readLine()) != null) {
                if (s.trim().length() == 0 || s.startsWith("#")) continue;
                String[] splits = s.split("=");
                if (splits.length != 2) {
                    throw new XWGInternalException(7702, new String[]{"line contents improperly formatted: " + s});
                }
                String[] alts = splits[1].split(",");
                ArrayList altsList = new ArrayList(alts.length);
                Collections.addAll(altsList, alts);
                if (this.m_alternates.put(splits[0].replaceAll("\\+", " "), Collections.unmodifiableList(altsList)) == null) continue;
                throw new XWGInternalException(7702, new String[]{splits[0] + " is already present"});
            }
            if (this.m_alternates.isEmpty()) {
                throw new XWGInternalException(7702, new String[]{"No alternate entries were found"});
            }
        }

        @Override
        public Collection<String> getAlternates(String areaName) {
            Collection<String> result = this.m_alternates.get(areaName);
            if (result == null && areaName != null) {
                result = this.m_alternates.get(areaName.toUpperCase());
            }
            return result != null ? result : Collections.emptyList();
        }

        @Override
        public String getKeyForAlternate(String value) {
            return null;
        }
    }

    private static class NoResultsAlternateProvider
    implements IAlternatesProvider {
        private NoResultsAlternateProvider() {
        }

        @Override
        public Collection<String> getAlternates(String areaName) {
            return Collections.emptyList();
        }

        @Override
        public String getKeyForAlternate(String value) {
            return null;
        }
    }
}

