/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.addressparser.AUS;

import com.mapinfo.mapmarker.AUS.utils.AUS_StringUtilities;
import com.mapinfo.mapmarker.addressparser.AUS.AUS_KeywordStoreCollection;
import com.mapinfo.mapmarker.addressparser.AUS.AUS_RegexAddressMatrixAnalyser;
import com.mapinfo.mapmarker.addressparser.AUS.AUS_RegexPatternGenerator;
import com.mapinfo.mapmarker.addressparser.MI_ParseRuleAdapter;
import com.mapinfo.mapmarker.addressparser.analyser.RegexAddressMatrixAnalyser;
import com.mapinfo.mapmarker.addressparser.keywords.KeywordStore;
import com.mapinfo.mapmarker.addressparser.keywords.KeywordStoreCollection;
import com.mapinfo.mapmarker.addressparser.keywords.KeywordType;
import com.mapinfo.mapmarker.addressparser.patterngen.RegexPatternGenerator;
import com.mapinfo.mapmarker.common.Address;

public class AUS_MI_ParseRuleAdapter
extends MI_ParseRuleAdapter {
    private boolean _dataConstruction = false;

    public AUS_MI_ParseRuleAdapter() {
    }

    public AUS_MI_ParseRuleAdapter(boolean dataConstruction) {
        this._dataConstruction = dataConstruction;
    }

    @Override
    protected RegexPatternGenerator initRegexPatternGenerator() {
        return AUS_RegexPatternGenerator.getInstance();
    }

    @Override
    protected KeywordStoreCollection initKeywordStoreCollection() {
        return AUS_KeywordStoreCollection.getInstance();
    }

    @Override
    protected RegexAddressMatrixAnalyser initMatrixAnalyser() {
        AUS_RegexAddressMatrixAnalyser analyser = AUS_RegexAddressMatrixAnalyser.getInstance();
        this.setAnalyserLevels(analyser);
        return analyser;
    }

    @Override
    protected String getAddressTokenParserField(Address unrefinedAddress) {
        return unrefinedAddress.getMainAddress();
    }

    @Override
    protected void processManualFieldUpdates(Address originalParsedAddress, Address newlyParsedAddress) {
        if (this.usePostThoroughFareAsMainAddress(originalParsedAddress)) {
            originalParsedAddress.setMainAddress(originalParsedAddress.getPostThoroughfareType());
            originalParsedAddress.setPostThoroughfareType(null);
        }
        this.abbreviatePostThoroughFareType(originalParsedAddress);
        this.removeSaintToPreAddress(originalParsedAddress);
    }

    private void removeSaintToPreAddress(Address originalParsedAddress) {
        String mainAddress = originalParsedAddress.getMainAddress();
        if (mainAddress.toLowerCase().startsWith("st ") && mainAddress.length() != 2) {
            String existingPreAddress = originalParsedAddress.getPreAddress() == null ? "" : originalParsedAddress.getPreAddress();
            originalParsedAddress.setPreAddress((existingPreAddress + " ST").trim());
            originalParsedAddress.setMainAddress(mainAddress.substring(2, mainAddress.length()).trim());
        }
    }

    private void abbreviatePostThoroughFareType(Address originalParsedAddress) {
        String postThoroughfareType = originalParsedAddress.getPostThoroughfareType();
        if (!AUS_StringUtilities.isEmpty(postThoroughfareType)) {
            KeywordStore streetKeywordStore = this._keywordStoreCollection.getKeywordStore("street");
            KeywordType keyword = streetKeywordStore.getKeyword(postThoroughfareType);
            originalParsedAddress.setPostThoroughfareType(keyword.getAbbreviation());
        }
    }

    private boolean usePostThoroughFareAsMainAddress(Address address) {
        return AUS_StringUtilities.isEmpty(address.getMainAddress()) && !AUS_StringUtilities.isEmpty(address.getPostThoroughfareType());
    }

    @Override
    protected String[] getAddressAttributeCopyList() {
        return new String[]{"GenericField1", "GenericField2", "GenericField3", "GenericField4", "PreAddress", "MainAddress", "AddressNumber", "PreThoroughfareType", "PostThoroughfareType", "PreDirectional", "PostDirectional", "UnitType", "UnitValue"};
    }

    private void setAnalyserLevels(RegexAddressMatrixAnalyser analyser) {
        if (this._dataConstruction) {
            analyser.setStrictnessLevel(1);
            analyser.setRuleLevel(2);
        } else {
            analyser.setStrictnessLevel(2);
            analyser.setRuleLevel(2);
        }
    }
}

