/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.addressparser;

import com.mapinfo.mapmarker.IConstraints;
import com.mapinfo.mapmarker.addressparser.AddressMatrix;
import com.mapinfo.mapmarker.addressparser.IAddress;
import com.mapinfo.mapmarker.addressparser.analyser.RegexAddressMatrixAnalyser;
import com.mapinfo.mapmarker.addressparser.classifier.TokenClassifierEngine;
import com.mapinfo.mapmarker.addressparser.keywords.KeywordStoreCollection;
import com.mapinfo.mapmarker.addressparser.patterngen.RegexPatternGenerator;
import com.mapinfo.mapmarker.addressparser.tokenparser.AddressTokenParser;
import com.mapinfo.mapmarker.common.Address;
import com.mapinfo.mapmarker.core.parser.IParseRule;
import com.mapinfo.mapmarker.core.parser.ParserException;
import java.lang.reflect.Method;

public abstract class MI_ParseRuleAdapter
implements IParseRule {
    protected RegexPatternGenerator _regexPatternGenerator = this.initRegexPatternGenerator();
    protected KeywordStoreCollection _keywordStoreCollection = this.initKeywordStoreCollection();
    protected TokenClassifierEngine _tokenClassifierEngine;
    protected RegexAddressMatrixAnalyser _matrixAnalyser = this.initMatrixAnalyser();
    public AddressMatrix LAST_MATRIX_PARSED;

    public MI_ParseRuleAdapter() {
        this._tokenClassifierEngine = new TokenClassifierEngine(this._regexPatternGenerator, this._keywordStoreCollection);
    }

    protected abstract RegexPatternGenerator initRegexPatternGenerator();

    protected abstract KeywordStoreCollection initKeywordStoreCollection();

    protected abstract RegexAddressMatrixAnalyser initMatrixAnalyser();

    protected abstract String getAddressTokenParserField(Address var1);

    protected abstract void processManualFieldUpdates(Address var1, Address var2);

    protected String[] getAddressAttributeCopyList() {
        return IAddress.ADDRESS_FIELDS;
    }

    public void parse(Address ura, Address pa, IConstraints constraints) throws ParserException {
        AddressTokenParser parser = new AddressTokenParser(this._tokenClassifierEngine);
        AddressMatrix matrix = parser.buildAddressMatrix(ura, this.getAddressTokenParserField(ura), true);
        matrix.analyseMatrix(this._matrixAnalyser);
        if (matrix.hasBeenParsed()) {
            this.prepareParsedAddress(pa, matrix);
            this.processManualFieldUpdates(pa, matrix.getParsedAddress());
            this.LAST_MATRIX_PARSED = matrix;
        }
    }

    protected void prepareParsedAddress(Address pa, AddressMatrix matrix) throws ParserException {
        try {
            this.copyParsedAttributes(pa, matrix.getParsedAddress());
        }
        catch (Exception e) {
            throw new ParserException(2308, (Throwable)e);
        }
    }

    public final void copyParsedAttributes(Address originalAddr, Address newAddress) throws Exception {
        if (originalAddr == null || newAddress == null) {
            return;
        }
        String[] simpleAttributeList = this.getAddressAttributeCopyList();
        for (int i = 0; i < simpleAttributeList.length; ++i) {
            MI_ParseRuleAdapter.copyAttribute(originalAddr, newAddress, simpleAttributeList[i]);
        }
    }

    public static boolean copyAttribute(Object origObj, Object newObj, String attribute) throws Exception {
        if (!origObj.getClass().isInstance(newObj)) {
            return false;
        }
        Method getterMethod = newObj.getClass().getMethod("get" + attribute, new Class[0]);
        Method setterMethod = newObj.getClass().getMethod("set" + attribute, String.class);
        Object newValue = getterMethod.invoke(newObj, new Object[0]);
        setterMethod.invoke(origObj, newValue);
        return true;
    }
}

