/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.addressparser.analyser;

import com.mapinfo.mapmarker.APAC.utils.APAC_StringUtilities;
import com.mapinfo.mapmarker.addressparser.AddressMatrix;
import com.mapinfo.mapmarker.addressparser.analyser.MatrixAnalyserException;
import com.mapinfo.mapmarker.addressparser.analyser.MatrixAnalyserRule;
import com.mapinfo.mapmarker.addressparser.classifier.TokenCleaner;
import com.mapinfo.mapmarker.addressparser.tokenparser.AddressToken;
import com.mapinfo.mapmarker.common.Address;
import com.mapinfo.mapmarker.common.AddressImpl;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RegexAddressMatrixAnalyser {
    public static final int RULE_LEVEL_FINE = 1;
    public static final int RULE_LEVEL_MEDIUM = 2;
    public static final int RULE_LEVEL_COARSE = 3;
    public static final int STRICT_MATCH_ENTIRE = 1;
    public static final int STRICT_MATCH_PARTIAL = 2;
    public static final boolean CLEAN_TOKENS_YES = true;
    public static final boolean CLEAN_TOKENS_NO = false;
    public static final String ADDRESS_NUMBER = "AddressNumber";
    public static final String MAIN_ADDRESS = "MainAddress";
    public static final String POST_THOROUGHFARE_TYPE = "PostThoroughfareType";
    public static final String UNIT_TYPE = "UnitType";
    public static final String UNIT_VALUE = "UnitValue";
    public static final String GENERIC_FIELD1 = "GenericField1";
    public static final String GENERIC_FIELD2 = "GenericField2";
    public static final String POST_DIRECTIONAL = "PostDirectional";
    public static final String PRE_DIRECTIONAL = "PreDirectional";
    public static final String PRE_ADDRESS = "PreAddress";
    public static final String POST_CODE1 = "PostCode1";
    public static final String AREANAME1 = "AreaName1";
    public static final String AREANAME2 = "AreaName2";
    public static final String AREANAME3 = "AreaName3";
    public static final String AREANAME4 = "AreaName4";
    private static final String ONE_OR_MORE_CHAR = "+";
    private static final String ONE_OR_NOT_AT_ALL = "?";
    protected static final String SPACE_CHAR = " ";
    private ArrayList _ruleArray = new ArrayList();
    private int _ruleLevel = 1;
    private int _strictnessLevel = 2;
    private boolean _cleanTokensStatus = true;

    public Address analyse(AddressMatrix matrix) throws MatrixAnalyserException {
        if (matrix == null || matrix.size() == 0) {
            throw new MatrixAnalyserException("Unable to analyse null or empty Address Matrix.");
        }
        AddressImpl parsedAddress = new AddressImpl();
        String inputAddressPattern = matrix.getMatchString(true);
        block0: for (int currentRuleLevel = 1; currentRuleLevel <= this.getRuleLevel(); ++currentRuleLevel) {
            for (int i = 0; i < this._ruleArray.size(); ++i) {
                AnalyserRule analyserRule = (AnalyserRule)this._ruleArray.get(i);
                if (analyserRule._level != currentRuleLevel || !this.checkForMatchWithRule(analyserRule, inputAddressPattern, matrix, parsedAddress)) continue;
                matrix.setMatchedPattern(analyserRule._ruleIndicator);
                continue block0;
            }
        }
        return parsedAddress;
    }

    public final boolean addMatrixAnalyserRule(MatrixAnalyserRule analyserRule) {
        AnalyserRule convertedRule = this.buildRuleFromMatrixAnayserRule(analyserRule);
        if (convertedRule != null) {
            convertedRule._ruleIndicator = this._ruleArray.size() + 1;
        }
        return convertedRule == null ? false : this._ruleArray.add(convertedRule);
    }

    public final Pattern getAnalyserPattern(int ruleIndex) throws IndexOutOfBoundsException {
        return ((AnalyserRule)this._ruleArray.get((int)ruleIndex))._pattern;
    }

    public final Map getAnalyserGroupMapping(int ruleIndex) throws IndexOutOfBoundsException {
        return ((AnalyserRule)this._ruleArray.get((int)ruleIndex))._regexGroupMapping;
    }

    public boolean getCleanTokensStatus() {
        return this._cleanTokensStatus;
    }

    public void setCleanTokensStatus(boolean cleanTokens) {
        this._cleanTokensStatus = cleanTokens;
    }

    public int getStrictnessLevel() {
        return this._strictnessLevel;
    }

    public void setStrictnessLevel(int strictnessLevel) {
        this._strictnessLevel = strictnessLevel;
    }

    public void setRuleLevel(int level) {
        this._ruleLevel = level;
    }

    public int getRuleLevel() {
        return this._ruleLevel;
    }

    public int size() {
        return this._ruleArray.size();
    }

    protected AnalyserRule getRule(int index) {
        return (AnalyserRule)this._ruleArray.get(index);
    }

    private boolean checkForMatchWithRule(AnalyserRule analyserRule, String inputAddressPattern, AddressMatrix matrix, AddressImpl parsedAddress) {
        Pattern p = analyserRule._pattern;
        Matcher matcher = p.matcher(inputAddressPattern);
        boolean matchFound = false;
        switch (this.getStrictnessLevel()) {
            case 2: {
                if (!matcher.find()) break;
                this.processMatchedRule(matrix, matcher, analyserRule, parsedAddress);
                matchFound = true;
                break;
            }
            default: {
                if (!matcher.matches()) break;
                this.processMatchedRule(matrix, matcher, analyserRule, parsedAddress);
                matchFound = true;
            }
        }
        return matchFound;
    }

    protected void processMatchedRule(AddressMatrix matrix, Matcher matcher, AnalyserRule analyserRule, AddressImpl parsedAddress) {
        Map regexGroupsMap = analyserRule._regexGroupMapping;
        for (String addressField : regexGroupsMap.keySet()) {
            String[] regexGroupNumbers = (String[])regexGroupsMap.get(addressField);
            for (int i = 0; i < regexGroupNumbers.length; ++i) {
                int group = MatrixAnalyserRule.getGroupMapping(regexGroupNumbers[i]);
                int groupPart = MatrixAnalyserRule.getGroupPartMapping(regexGroupNumbers[i]);
                String regexGroupString = matcher.group(group);
                if (regexGroupString == null) continue;
                StringBuffer addressFieldValue = this.fetchTokensForMatchedGroup(matrix, regexGroupString, groupPart);
                this.populateAddressObject(parsedAddress, addressField, addressFieldValue);
            }
        }
    }

    protected StringBuffer fetchTokensForMatchedGroup(AddressMatrix matrix, String groupString, int tokenPart) {
        int[] tokenPositions = APAC_StringUtilities.extractIntArray(groupString);
        StringBuffer fetchedMatrixToken = new StringBuffer();
        for (int currentPos = 0; currentPos < tokenPositions.length; ++currentPos) {
            AddressToken token = matrix.getAddressToken(tokenPositions[currentPos]);
            fetchedMatrixToken.append(this.cleanTokenIfNecessary(token, tokenPart));
            fetchedMatrixToken.append(SPACE_CHAR);
        }
        return fetchedMatrixToken;
    }

    private String cleanTokenIfNecessary(AddressToken token, int tokenPart) {
        String addrTokenValue = token.getToken(tokenPart);
        if (this.getCleanTokensStatus()) {
            TokenCleaner cleaner = token.getClassifier().getCleaner();
            addrTokenValue = cleaner.isCleanWithAbbreviation() ? token.getClassifier().getTokenAbbreviation() : cleaner.clean(addrTokenValue);
        }
        return addrTokenValue;
    }

    protected void populateAddressObject(AddressImpl parsedAddress, String addressField, StringBuffer fetchedMatrixString) {
        if (ADDRESS_NUMBER.equals(addressField)) {
            parsedAddress.setAddressNumber(fetchedMatrixString.toString().trim());
        } else if (MAIN_ADDRESS.equals(addressField)) {
            parsedAddress.setMainAddress(this.appendString(fetchedMatrixString, parsedAddress.getMainAddress()));
        } else if (POST_THOROUGHFARE_TYPE.equals(addressField)) {
            parsedAddress.setPostThoroughfareType(fetchedMatrixString.toString().trim());
        } else if (UNIT_TYPE.equals(addressField)) {
            parsedAddress.setUnitType(this.appendString(fetchedMatrixString, parsedAddress.getUnitType()));
        } else if (UNIT_VALUE.equals(addressField)) {
            parsedAddress.setUnitValue(this.appendString(fetchedMatrixString, parsedAddress.getUnitValue()));
        } else if (GENERIC_FIELD1.equals(addressField)) {
            parsedAddress.setGenericField1(this.appendString(fetchedMatrixString, parsedAddress.getGenericField1()));
        } else if (GENERIC_FIELD2.equals(addressField)) {
            parsedAddress.setGenericField2(this.appendString(fetchedMatrixString, parsedAddress.getGenericField2()));
        } else if (PRE_ADDRESS.equals(addressField)) {
            parsedAddress.setPreAddress(this.appendString(fetchedMatrixString, parsedAddress.getPreAddress()));
        } else if (POST_DIRECTIONAL.equals(addressField)) {
            parsedAddress.setPostDirectional(this.appendString(fetchedMatrixString, parsedAddress.getPostDirectional()));
        } else if (PRE_DIRECTIONAL.equals(addressField)) {
            parsedAddress.setPreDirectional(this.appendString(fetchedMatrixString, parsedAddress.getPreDirectional()));
        } else if (AREANAME1.equals(addressField)) {
            parsedAddress.setAreaName1(this.appendString(fetchedMatrixString, parsedAddress.getAreaName1()));
        } else if (AREANAME2.equals(addressField)) {
            parsedAddress.setAreaName2(this.appendString(fetchedMatrixString, parsedAddress.getAreaName2()));
        } else if (AREANAME3.equals(addressField)) {
            parsedAddress.setAreaName3(this.appendString(fetchedMatrixString, parsedAddress.getAreaName3()));
        } else if (AREANAME4.equals(addressField)) {
            parsedAddress.setAreaName4(this.appendString(fetchedMatrixString, parsedAddress.getAreaName4()));
        } else if (POST_CODE1.equals(addressField)) {
            parsedAddress.setPostCode1(fetchedMatrixString.toString().trim());
        }
    }

    protected String appendString(StringBuffer fetchedMatrixString, String genField1) {
        return ((genField1 != null ? genField1 + SPACE_CHAR : "") + fetchedMatrixString.toString().trim()).trim();
    }

    private AnalyserRule buildRuleFromMatrixAnayserRule(MatrixAnalyserRule analyserRule) {
        if (!analyserRule.isValid()) {
            return null;
        }
        StringBuffer patternBuffer = this.buildPatternBuffer(analyserRule);
        Map regexGroupMapping = this.buildRegexGroupToAddressFieldMap(analyserRule);
        return new AnalyserRule(Pattern.compile(patternBuffer.toString()), regexGroupMapping, analyserRule.getLevel());
    }

    private Map buildRegexGroupToAddressFieldMap(MatrixAnalyserRule analyserRule) {
        HashMap<String, String[]> regexGroupMapping = new HashMap<String, String[]>();
        Map fieldMap = analyserRule.getFieldMap();
        for (String addressFieldKey : fieldMap.keySet()) {
            String[] regexGroupArray = (String[])fieldMap.get(addressFieldKey);
            regexGroupMapping.put(addressFieldKey, regexGroupArray);
        }
        return regexGroupMapping;
    }

    protected StringBuffer buildPatternBuffer(MatrixAnalyserRule analyserRule) {
        StringBuffer patternBuffer = new StringBuffer();
        StringTokenizer ruleTokens = new StringTokenizer(analyserRule.getRule());
        while (ruleTokens.hasMoreTokens()) {
            String token = ruleTokens.nextToken();
            if (token.equals(".+")) {
                patternBuffer.append("((?:.)+)");
                continue;
            }
            if (token.startsWith("<") && token.endsWith(">")) {
                patternBuffer.append(token.substring(1, token.length() - 1));
                continue;
            }
            if (token.endsWith(ONE_OR_MORE_CHAR)) {
                patternBuffer.append("((?:" + token.substring(0, token.length() - 1) + "\\d{1,3})+)");
                continue;
            }
            if (token.endsWith(ONE_OR_NOT_AT_ALL)) {
                patternBuffer.append("(" + token.substring(0, token.length() - 1) + "\\d{1,3})?");
                continue;
            }
            patternBuffer.append("((?:" + token + ")\\d{1,3})");
        }
        return patternBuffer;
    }

    protected class AnalyserRule {
        Map _regexGroupMapping = new HashMap();
        public Pattern _pattern;
        public int _level;
        public int _ruleIndicator;

        public AnalyserRule(Pattern pattern, Map groupMapping, int level) {
            this._pattern = pattern;
            this._regexGroupMapping = groupMapping;
            this._level = level;
        }
    }
}

