/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.addressparser.keywords;

import com.mapinfo.mapmarker.APAC.utils.APAC_StringUtilities;
import com.mapinfo.mapmarker.addressparser.classifier.TokenCleaner;
import com.mapinfo.mapmarker.addressparser.classifier.TokenSplitter;
import com.mapinfo.mapmarker.addressparser.keywords.KeywordType;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;

public class KeywordStore {
    public static final String ERROR_MSG_RESOURCE_LOAD_FAILURE = "Unable to load required files for KeywordStore.";
    private static final String DELIMETER_SETTINGS = ",";
    private static final String DELIMETER_ABBR = "|";
    private String _id;
    private String _resourceLocation;
    private Map _keywordTypes;
    private double _priority;
    private TokenCleaner _cleaner;
    private TokenSplitter _splitter;

    public KeywordStore(String id, String resourceLocation) {
        this._id = id;
        this._resourceLocation = resourceLocation;
        this._priority = 1.0;
        this._cleaner = new TokenCleaner(id);
        this._splitter = new TokenSplitter(id);
        try {
            Properties propertiesFile = new Properties();
            ClassLoader loader = this.getClass().getClassLoader();
            propertiesFile.load(loader.getResourceAsStream(this._resourceLocation));
            if (propertiesFile != null) {
                this.buildTypesMap(propertiesFile);
            }
        }
        catch (Throwable e) {
            System.out.println(System.getProperties());
            throw new RuntimeException(ERROR_MSG_RESOURCE_LOAD_FAILURE, e);
        }
    }

    public TokenSplitter getSplitter() {
        return this._splitter;
    }

    public void setSplitter(TokenSplitter splitter) {
        this._splitter = splitter;
    }

    public TokenCleaner getCleaner() {
        return this._cleaner;
    }

    public void setCleaner(TokenCleaner cleaner) {
        this._cleaner = cleaner;
    }

    public double getPriority() {
        return this._priority;
    }

    public void setPriority(double priority) {
        this._priority = priority;
    }

    public String getId() {
        return this._id;
    }

    public String getResourceLocation() {
        return this._resourceLocation;
    }

    public int getNumberOfKeywords() {
        return this._keywordTypes.size();
    }

    public KeywordType getKeyword(String keyword) {
        return (KeywordType)this._keywordTypes.get(keyword.toUpperCase());
    }

    private void buildTypesMap(Properties unitProperties) {
        Iterator<Object> typesIterator = unitProperties.keySet().iterator();
        if (typesIterator.hasNext()) {
            this._keywordTypes = new HashMap();
        }
        while (typesIterator.hasNext()) {
            String typeDescription = (String)typesIterator.next();
            String typeDescriptionSettings = unitProperties.getProperty(typeDescription);
            this.buildAndInsertTypesForDescription(typeDescription, typeDescriptionSettings);
        }
    }

    private void buildAndInsertTypesForDescription(String unitTypeDescription, String typeDescriptionSettings) {
        StringTokenizer settingsTokens = new StringTokenizer(typeDescriptionSettings, DELIMETER_SETTINGS);
        String abbreviationProper = "";
        String abbreviationList = "";
        int tokenCount = settingsTokens.countTokens();
        if (tokenCount == 1) {
            abbreviationProper = settingsTokens.nextToken();
        }
        if (tokenCount == 2) {
            abbreviationProper = settingsTokens.nextToken();
            abbreviationList = settingsTokens.nextToken();
        }
        if (APAC_StringUtilities.isEmpty(abbreviationProper) || APAC_StringUtilities.isEmpty(unitTypeDescription)) {
            return;
        }
        KeywordType realType = new KeywordType(unitTypeDescription, abbreviationProper);
        this._keywordTypes.put(abbreviationProper.toUpperCase(), realType);
        this._keywordTypes.put(unitTypeDescription.toUpperCase(), realType);
        this.buildAndInsertAbbreviations(abbreviationList, realType);
    }

    private void buildAndInsertAbbreviations(String abbreviationList, KeywordType realType) {
        StringTokenizer abbreviationSubList = new StringTokenizer(abbreviationList, DELIMETER_ABBR);
        while (abbreviationSubList.hasMoreTokens()) {
            String abbr = abbreviationSubList.nextToken();
            if (APAC_StringUtilities.isEmpty(abbr)) continue;
            this._keywordTypes.put(abbr.toUpperCase(), realType);
        }
    }
}

