/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.addressparser.patterngen;

import com.mapinfo.mapmarker.APAC.utils.APAC_StringUtilities;
import com.mapinfo.mapmarker.addressparser.classifier.TokenCleaner;
import com.mapinfo.mapmarker.addressparser.classifier.TokenSplitter;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RegexPatternGenerator {
    public static Pattern PAT_INTEGER = Pattern.compile("\\d+");
    public static Pattern PAT_BASIC_WORD = Pattern.compile("(?:[a-z]|[A-Z])+(?:(?:_|-|')??(?:[a-z]|[A-Z]|[0-9])+)+");
    private ArrayList _patternList = new ArrayList();

    public final boolean addPattern(String description, Pattern pattern, double priority, TokenSplitter splitter) {
        PatternEntry newEntry = new PatternEntry(description, pattern, priority, new TokenCleaner(description), splitter);
        return this._patternList.add(newEntry);
    }

    public final boolean addPattern(String description, Pattern pattern, double priority, TokenCleaner cleaner) {
        PatternEntry newEntry = new PatternEntry(description, pattern, priority, cleaner, new TokenSplitter(description));
        return this._patternList.add(newEntry);
    }

    public final boolean addPattern(String description, Pattern pattern, double priority) {
        PatternEntry newEntry = new PatternEntry(description, pattern, priority, new TokenCleaner(description), new TokenSplitter(description));
        return this._patternList.add(newEntry);
    }

    public final boolean addPattern(String description, Pattern pattern, double priority, TokenCleaner cleaner, TokenSplitter splitter) {
        PatternEntry newEntry = new PatternEntry(description, pattern, priority, cleaner, splitter);
        return this._patternList.add(newEntry);
    }

    public final int getPatternCount() {
        return this._patternList.size();
    }

    public final String getPatternDescription(int patternIndex) throws IndexOutOfBoundsException {
        return ((PatternEntry)this._patternList.get(patternIndex)).getDescription();
    }

    public final Pattern getPattern(int patternIndex) throws IndexOutOfBoundsException {
        return ((PatternEntry)this._patternList.get(patternIndex)).getPattern();
    }

    public final double getPatternPriority(int patternIndex) throws IndexOutOfBoundsException {
        return ((PatternEntry)this._patternList.get(patternIndex)).getPriority();
    }

    public final TokenCleaner getTokenCleaner(int patternIndex) throws IndexOutOfBoundsException {
        return ((PatternEntry)this._patternList.get(patternIndex)).getCleaner();
    }

    public final TokenSplitter getTokenSplitter(int patternIndex) throws IndexOutOfBoundsException {
        return ((PatternEntry)this._patternList.get(patternIndex)).getSplitter();
    }

    public final int[] match(String matchString) {
        ArrayList resultList = this.matchInputWithPatternList(matchString);
        if (resultList.size() == 0) {
            return null;
        }
        int[] resultArray = this.convertIntegerListToIntArray(resultList);
        return resultArray;
    }

    private int[] convertIntegerListToIntArray(ArrayList resultList) {
        int[] resultArray = new int[resultList.size()];
        for (int i = 0; i < resultList.size(); ++i) {
            resultArray[i] = (Integer)resultList.get(i);
        }
        return resultArray;
    }

    private ArrayList matchInputWithPatternList(String matchString) {
        ArrayList<Integer> resultList = new ArrayList<Integer>();
        if (APAC_StringUtilities.isEmpty(matchString)) {
            return resultList;
        }
        for (int i = 0; i < this._patternList.size(); ++i) {
            PatternEntry entry = (PatternEntry)this._patternList.get(i);
            Matcher m = entry.getPattern().matcher(matchString);
            if (!m.matches()) continue;
            resultList.add(new Integer(i));
        }
        return resultList;
    }

    class PatternEntry {
        private String _description;
        private Pattern _pattern;
        private double _priority;
        private TokenCleaner _cleaner;
        private TokenSplitter _splitter;

        public PatternEntry(String description, Pattern pattern, double priority, TokenCleaner cleaner, TokenSplitter splitter) {
            this._description = description;
            this._pattern = pattern;
            this._priority = priority;
            this._cleaner = cleaner;
            this._splitter = splitter;
        }

        public double getPriority() {
            return this._priority;
        }

        public String getDescription() {
            return this._description;
        }

        public Pattern getPattern() {
            return this._pattern;
        }

        public TokenCleaner getCleaner() {
            return this._cleaner;
        }

        public TokenSplitter getSplitter() {
            return this._splitter;
        }
    }
}

