/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.addressparser.tokenparser;

import com.mapinfo.mapmarker.addressparser.classifier.TokenClassifier;
import java.util.ArrayList;
import java.util.List;

public class AddressToken {
    public static final int POSITION_NOT_ASSIGNED = -1;
    public static final TokenClassifier NO_CLASSIFIER = null;
    public static final int NO_ADDITIONAL_CLASSIFIERS = 0;
    private String _token;
    private String[] _tokenParts;
    private int _position;
    private TokenClassifier _classifier;
    private List _additionalClassifiers = new ArrayList();

    public AddressToken() {
        this(null, -1, NO_CLASSIFIER);
    }

    public AddressToken(String token, int position, TokenClassifier tokenClassifier) {
        this.setToken(token);
        this.setPosition(position);
        this.setClassifier(tokenClassifier);
    }

    public boolean addAdditionalClassifier(TokenClassifier tokenClassifier) {
        return this._additionalClassifiers.add(tokenClassifier);
    }

    public List getAdditionalClassifiers() {
        return this._additionalClassifiers;
    }

    public TokenClassifier getClassifier() {
        return this._classifier;
    }

    public TokenClassifier getClassifier(String tokenType) {
        if (tokenType.startsWith(this._classifier.getType())) {
            return this._classifier;
        }
        for (int i = 0; i < this._additionalClassifiers.size(); ++i) {
            TokenClassifier classifier = (TokenClassifier)this._additionalClassifiers.get(i);
            if (!tokenType.startsWith(classifier.getType())) continue;
            return classifier;
        }
        return null;
    }

    public void setClassifier(TokenClassifier classifier) {
        this._classifier = classifier;
    }

    public int getPosition() {
        return this._position;
    }

    public void setPosition(int position) {
        this._position = position;
    }

    public void setToken(String token) {
        this._token = token;
    }

    public String getToken() {
        return this._token;
    }

    public int getTokenPartCount() {
        return this._tokenParts == null ? 0 : this._tokenParts.length;
    }

    public void setTokenParts(String[] parts) {
        this._tokenParts = parts;
    }

    public String getToken(int partIndex) {
        if (this.isInvalidPartIndex(partIndex)) {
            return this._token;
        }
        return this._tokenParts[partIndex - 1];
    }

    private boolean isInvalidPartIndex(int partIndex) {
        return this._tokenParts == null || partIndex > this._tokenParts.length || partIndex < 1;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("Token: " + this._token + "\n");
        sb.append("Position: " + this._position + "\n");
        sb.append("TokenClassifier: " + this._classifier + "\n");
        sb.append("Token Parts: " + this._tokenParts + "\n");
        sb.append("Additional Classifiers: " + this._additionalClassifiers + "\n");
        return sb.toString();
    }
}

