/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.common.dp.gui.ud;

import com.mapinfo.mapmarker.common.dp.gui.ud.UDColumnDefinition;
import com.mapinfo.mapmarker.common.dp.gui.ud.UDRequiredOneOfDefinition;
import com.mapinfo.mapmarker.common.dp.gui.ud.UDRequiredSetDefinition;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Set;

class RequiredColumnHelper {
    public static final int REQUIRED_COLUMNS_DEFINED = 0;
    public static final int REQUIRED_COLUMN_NOT_DEFINED = 1;
    public static final int MISSING_ONE_OF_REQUIRED_COLUMNS = 2;
    public static final int MISSING_ELEMENT_REQUIRED_COLUMN_SET = 3;
    private String m_missingRequiredColumnDescription = "";

    public int requiredColumnsNotMapped(Set columns, List defs, Properties properties, List oneOfList, List setList) {
        this.m_missingRequiredColumnDescription = "";
        for (int i = 0; i < defs.size(); ++i) {
            String mappedTo;
            UDColumnDefinition def = (UDColumnDefinition)defs.get(i);
            if (!def.isRequired() || columns.contains(mappedTo = properties.getProperty(def.getPropertyKey()))) continue;
            int reason = this.testColumnInRequiredOneOfDefinitions(def.getPropertyKey(), columns, properties, oneOfList);
            if (reason == 2) {
                return reason;
            }
            if (reason == 0) continue;
            reason = this.testColumnHasFullyMappedRequiredSet(def.getPropertyKey(), columns, properties, setList);
            if (reason == 1) {
                this.m_missingRequiredColumnDescription = def.getPropertyText();
                return reason;
            }
            if (reason == 0) continue;
            return reason;
        }
        return 0;
    }

    public int conditionallyRequiredColumnsNotMapped(Set columns, List defs, Properties properties, List oneOfList, List setList) {
        this.m_missingRequiredColumnDescription = "";
        for (int i = 0; i < defs.size(); ++i) {
            String mappedTo;
            UDColumnDefinition def = (UDColumnDefinition)defs.get(i);
            if (!def.isRequired() || columns.contains(mappedTo = properties.getProperty(def.getPropertyKey()))) continue;
            int reason = this.testColumnInRequiredOneOfDefinitions(def.getPropertyKey(), columns, properties, oneOfList);
            if (reason == 2) {
                return reason;
            }
            if (reason == 0 || (reason = this.testColumnHasFullyMappedRequiredSet(def.getPropertyKey(), columns, properties, setList)) == 1 || reason == 0) continue;
            return reason;
        }
        return 0;
    }

    public String returnUnmappedRequiredColumnDescription() {
        return this.m_missingRequiredColumnDescription;
    }

    private int testColumnInRequiredOneOfDefinitions(String unmappedColumn, Set columns, Properties properties, List UDOneOfDefs) {
        for (int i = 0; i < UDOneOfDefs.size(); ++i) {
            UDRequiredOneOfDefinition oneof = (UDRequiredOneOfDefinition)UDOneOfDefs.get(i);
            if (!oneof.containsProperty(unmappedColumn)) continue;
            Iterator<String> it = oneof.getIterator();
            while (it.hasNext()) {
                String other = it.next();
                String otherMapping = properties.getProperty(other);
                if (!columns.contains(otherMapping)) continue;
                return 0;
            }
            this.m_missingRequiredColumnDescription = oneof.getDescription();
            return 2;
        }
        return 1;
    }

    public int requiredSetColumnsNotMapped(Set columns, List defs, Properties properties, List setList) {
        this.m_missingRequiredColumnDescription = "";
        for (int i = 0; i < defs.size(); ++i) {
            UDColumnDefinition def = (UDColumnDefinition)defs.get(i);
            String mappedTo = properties.getProperty(def.getPropertyKey());
            if (mappedTo != null) continue;
            for (int j = 0; j < setList.size(); ++j) {
                String otherMapping;
                UDRequiredSetDefinition reqSet = (UDRequiredSetDefinition)setList.get(j);
                if (!reqSet.containsAlsoRequiredProperty(def.getPropertyKey()) || !columns.contains(otherMapping = properties.getProperty(reqSet.getKeyProperty()))) continue;
                this.m_missingRequiredColumnDescription = reqSet.getDescription();
                return 3;
            }
        }
        return 0;
    }

    private int testColumnHasFullyMappedRequiredSet(String unmappedColumn, Set columns, Properties properties, List UDSetDefs) {
        for (int i = 0; i < UDSetDefs.size(); ++i) {
            UDRequiredSetDefinition reqSet = (UDRequiredSetDefinition)UDSetDefs.get(i);
            if (!reqSet.containsAlsoRequiredProperty(unmappedColumn)) continue;
            String otherMapping = properties.getProperty(reqSet.getKeyProperty());
            if (columns.contains(otherMapping)) {
                this.m_missingRequiredColumnDescription = reqSet.getDescription();
                return 3;
            }
            return 0;
        }
        return 1;
    }
}

