/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.common.dp.gui.ud;

import com.mapinfo.mapmarker.common.dp.IProgressBarUpdater;
import com.mapinfo.mapmarker.common.dp.UserCancelledRuntimeException;
import com.mapinfo.mapmarker.common.dp.binary.UDDataCreator;
import com.mapinfo.mapmarker.common.dp.gui.ud.UDBuildHelper;
import com.mapinfo.mapmarker.common.dp.gui.ud.UDButtonPnl;
import com.mapinfo.mapmarker.common.dp.gui.ud.UDGUIController;
import com.mapinfo.mapmarker.common.dp.gui.ud.UDWizardPnl;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.net.URL;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class UDGUI
extends JPanel {
    private static final String RESOURCE_BUNDLE_NAME = "com.mapinfo.mapmarker.common.dp.gui.ud.UDGUI";
    private static final String PROP_FILE = "/.mapinfoUdGui/udCreation.properties";
    private static final String ICON_PATH = "com/mapinfo/mapmarker/common/dp/gui/ud/Utility.gif";
    private static final String LOCALE = "locale";
    private static final int MIN_WIDTH = 480;
    private static final int MIN_HEIGHT = 360;
    private UDGUIController m_controller;
    private UDWizardPnl m_wizardPnl;
    private UDButtonPnl m_buttonPnl;
    private Locale m_locale;
    private final UDBuildHelper m_helper;
    private final UDDataCreator m_creator;
    private int m_width = 480;
    private int m_height = 360;

    public static void main(String[] args) {
        Locale locale = Locale.getDefault();
        if (args != null && args.length == 1) {
            Properties props = null;
            try {
                props = UDGUI.parseCommandLine(args);
            }
            catch (IllegalArgumentException e) {
                System.out.println("Invalid program arguments.");
                System.out.println("Usage: UDGUI [locale=<locale string>]");
                System.out.println("Example <locale string>: fr");
                System.out.println("Example <locale string>: fr_FR");
                System.exit(1);
            }
            locale = new Locale(props.getProperty(LOCALE));
        }
        try {
            try {
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            }
            catch (Exception props) {
                // empty catch block
            }
            final UDGUI mainPanel = new UDGUI(locale);
            String title = ResourceBundle.getBundle(RESOURCE_BUNDLE_NAME, locale).getString("title");
            final JFrame frame = new JFrame();
            URL iconURL = UDGUI.class.getClassLoader().getResource(ICON_PATH);
            if (iconURL != null) {
                Image iconImg = Toolkit.getDefaultToolkit().createImage(iconURL);
                frame.setIconImage(iconImg);
            }
            frame.setTitle(title);
            frame.setDefaultCloseOperation(0);
            frame.getContentPane().add((Component)mainPanel, "Center");
            frame.pack();
            frame.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    mainPanel.m_controller.cancel();
                    if (mainPanel.m_controller.getProgress() == 100) {
                        mainPanel.saveUserValues(mainPanel.m_controller.buildProperties());
                    }
                    frame.dispose();
                }
            });
            Dimension size = frame.getSize();
            size.setSize(Math.max(size.getWidth(), (double)mainPanel.m_width), Math.max(size.getHeight(), (double)mainPanel.m_height));
            frame.setSize(size);
            frame.setLocationRelativeTo(null);
            frame.setVisible(true);
        }
        catch (MissingResourceException e) {
            JOptionPane.showMessageDialog(null, "Unable to initialize GUI resource strings.", "Error", 0);
            System.exit(1);
        }
    }

    private static Properties parseCommandLine(String[] args) {
        Properties result = new Properties();
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            String[] keyValuePair = arg.split("=");
            if (keyValuePair.length != 2) {
                throw new IllegalArgumentException();
            }
            result.setProperty(keyValuePair[0], keyValuePair[1]);
        }
        return result;
    }

    public UDGUI(Locale locale) {
        this(locale, new UDBuildHelper(), new UDDataCreator());
    }

    protected UDGUI(Locale locale, UDBuildHelper helper, UDDataCreator creator) {
        this.m_locale = locale;
        this.m_helper = helper;
        this.m_creator = creator;
        this.initComponents();
        this.layoutComponents();
    }

    private void layoutComponents() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.m_wizardPnl, "Center");
        this.add((Component)this.m_buttonPnl, "South");
    }

    private void initComponents() {
        Properties properties = this.readUserValues();
        this.m_controller = new UDGUIController(this.m_locale, properties, this.m_helper, this.m_creator, new ProgressUpdater());
        this.m_wizardPnl = new UDWizardPnl(this.m_locale, this.m_helper, this, this.m_controller);
        this.m_buttonPnl = new UDButtonPnl(this.m_locale, this, this.m_controller);
    }

    public void updateWizardPanel() {
        if (this.m_wizardPnl != null) {
            this.m_wizardPnl.updatePanel();
        }
    }

    public void updateButtonPanel() {
        if (this.m_buttonPnl != null) {
            this.m_buttonPnl.updateButtons();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties readUserValues() {
        Properties result = new Properties();
        FileInputStream fis = null;
        try {
            File propsFile = new File(System.getProperty("user.home") + PROP_FILE);
            if (propsFile.exists()) {
                fis = new FileInputStream(propsFile);
                BufferedInputStream bis = new BufferedInputStream(fis);
                result.load(bis);
            }
        }
        catch (Exception exception) {
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException iOException) {}
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveUserValues(Properties props) {
        FileOutputStream fos = null;
        try {
            if (props != null) {
                File propsFile = new File(System.getProperty("user.home") + PROP_FILE);
                File dir = propsFile.getParentFile();
                if (!dir.exists()) {
                    dir.mkdir();
                }
                fos = new FileOutputStream(propsFile);
                BufferedOutputStream bos = new BufferedOutputStream(fos);
                PrintStream ps = new PrintStream(bos);
                props.store(ps, "Last runs values");
                ps.flush();
            }
        }
        catch (Exception exception) {
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    class ProgressUpdater
    implements IProgressBarUpdater {
        ProgressUpdater() {
        }

        public void update(int perCentComplete) throws UserCancelledRuntimeException {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    UDGUI.this.updateWizardPanel();
                    UDGUI.this.updateButtonPanel();
                }
            });
        }
    }
}

