/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.jni;

import com.mapinfo.mapmarker.common.dp.IProgressBarUpdater;
import com.mapinfo.mapmarker.common.dp.PhaseProgressBounds;
import com.mapinfo.mapmarker.common.dp.PhaseProgressBoundsProvider;
import com.mapinfo.mapmarker.common.dp.ProgressBarUpdaterProvider;
import com.mapinfo.mapmarker.common.dp.UserCancelledRuntimeException;
import com.mapinfo.mapmarker.common.dp.binary.DataCreationException;
import com.mapinfo.mapmarker.common.dp.binary.DataCreationLogger;
import com.mapinfo.mapmarker.common.dp.binary.UDDataCreationException;
import com.mapinfo.mapmarker.common.dp.binary.UDDataCreator;
import com.mapinfo.mapmarker.jni.ProgressBarUpdater;
import com.mapinfo.mapmarker.utils.DebugLevel;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;

public class DataDict {
    protected static final int ALL_ROWS = 1;
    protected static final int SUBSET_ROWS = 2;
    private String m_leftStartAddrFieldName;
    private String m_leftEndAddrFieldName;
    private String m_rightStartAddrFieldName;
    private String m_rightEndAddrFieldName;
    private String m_streetFieldName;
    private String m_cityFieldName;
    private String m_stateFieldName;
    private String m_leftZipCodeFieldName;
    private String m_rightZipCodeFieldName;
    private String m_leftZipAddOnFieldName;
    private String m_rightZipAddOnFieldName;
    private String m_leftOddEvenFieldName;
    private String m_rightOddEvenFieldName;
    private String m_placeFieldName;
    private int m_iProcessFlag;
    private int m_iStartRow;
    private int m_iEndRow;
    private String m_input_table_name;
    private String m_dataSetPath;
    private Properties m_props = new Properties();
    private String m_outputPath;
    private String m_outputBaseName;
    private PrintStream m_statusStream;
    private PrintStream m_errorStream;
    private PrintStream m_internalErrorStream;

    public DataDict(String outputDictionaryName) throws UDDataCreationException {
        this.setOutputDictionaryName(outputDictionaryName);
        String pathAndBaseName = this.m_outputPath + File.separator + this.m_outputBaseName;
        try {
            this.m_statusStream = new PrintStream(new FileOutputStream(pathAndBaseName + ".log"));
            this.m_props.put("statusLog", this.m_statusStream);
            DataCreationLogger.getLogger().setStatusLog(this.m_statusStream, false);
            this.m_errorStream = new PrintStream(new FileOutputStream(pathAndBaseName + ".err"));
            this.m_props.put("errorLog", this.m_errorStream);
            DataCreationLogger.getLogger().setErrorLog(this.m_errorStream, false);
            if (DebugLevel.getDebugLevel((int)5) > 0) {
                this.m_internalErrorStream = new PrintStream(new FileOutputStream(pathAndBaseName + ".ier"));
                this.m_props.put("internalErrorLog", this.m_errorStream);
                DataCreationLogger.getLogger().setInternalErrorLog(this.m_internalErrorStream, false);
            }
        }
        catch (FileNotFoundException e) {
            throw new UDDataCreationException(-1);
        }
        this.m_props.setProperty("logFiles", "true");
        PhaseProgressBoundsProvider provider = PhaseProgressBoundsProvider.getInstance();
        provider.addBounds(0, new PhaseProgressBounds(0, 40));
        provider.addBounds(1, new PhaseProgressBounds(41, 80));
        provider.addBounds(2, new PhaseProgressBounds(81, 100));
    }

    public void setLeftStartAddrFieldName(String name) {
        this.m_leftStartAddrFieldName = name;
    }

    public void setLeftEndAddrFieldName(String name) {
        this.m_leftEndAddrFieldName = name;
    }

    public void setRightStartAddrFieldName(String name) {
        this.m_rightStartAddrFieldName = name;
    }

    public void setRightEndAddrFieldName(String name) {
        this.m_rightEndAddrFieldName = name;
    }

    public void setStreetFieldName(String name) {
        this.m_streetFieldName = name;
    }

    public void setCityFieldName(String name) {
        this.m_cityFieldName = name;
    }

    public void setStateFieldName(String name) {
        this.m_stateFieldName = name;
    }

    public void setLeftZipCodeFieldName(String name) {
        this.m_leftZipCodeFieldName = name;
    }

    public void setRightZipCodeFieldName(String name) {
        this.m_rightZipCodeFieldName = name;
    }

    public void setLeftZipAddOnFieldName(String name) {
        this.m_leftZipAddOnFieldName = name;
    }

    public void setRightZipAddOnFieldName(String name) {
        this.m_rightZipAddOnFieldName = name;
    }

    public void setLeftOddEvenFieldName(String name) {
        this.m_leftOddEvenFieldName = name;
    }

    public void setRightOddEvenFieldName(String name) {
        this.m_rightOddEvenFieldName = name;
    }

    public void setPlaceFieldName(String name) {
        this.m_placeFieldName = name;
    }

    public void setProcessFlag(int flag) {
        this.m_iProcessFlag = flag;
    }

    public void setStartRow(int rowNum) {
        this.m_iStartRow = rowNum;
    }

    public void setEndRow(int rowNum) {
        this.m_iEndRow = rowNum;
    }

    public void setInputTableName(String name) {
        File file = new File(name);
        this.m_input_table_name = file.getAbsolutePath();
    }

    private void setOutputDictionaryName(String name) throws UDDataCreationException {
        String fullName;
        File file = new File(name);
        this.m_outputPath = file.getParent();
        this.m_outputBaseName = fullName = file.getName();
        int dotPosition = fullName.lastIndexOf(".");
        if (dotPosition > 0) {
            this.m_outputBaseName = fullName.substring(0, dotPosition);
        }
        if (this.stringLengthZero(this.m_outputPath) || this.stringLengthZero(this.m_outputBaseName)) {
            throw new UDDataCreationException(1903);
        }
    }

    public void setDataSetPath(String path) {
        if (path.endsWith(";")) {
            String temp;
            path = temp = path.substring(0, path.length() - 1);
        }
        File file = new File(path);
        this.m_dataSetPath = file.getAbsolutePath();
    }

    protected String getOutputPath() {
        return this.m_outputPath;
    }

    protected void makeDataProperties() throws DataCreationException {
        this.m_props.setProperty("geo2sac_create", "NO");
        this.m_props.setProperty("geoInfo_create", "NO");
        this.m_props.setProperty("post2sac_create", "NO");
        this.m_props.setProperty("postInfo_create", "NO");
        this.m_props.setProperty("street_create", "YES");
        this.m_props.setProperty("street_inputTable", this.m_input_table_name);
        this.m_props.setProperty("street_outputFilePath", this.m_outputPath);
        this.m_props.setProperty("street_outputFile", this.m_outputBaseName);
        this.m_props.setProperty("geo2sac_outputFilePath", this.m_outputPath);
        this.m_props.setProperty("post2sac_outputFilePath", this.m_outputPath);
        this.m_props.setProperty("postInfo_outputFile", "postinfo");
        this.m_props.setProperty("postInfo_outputFilePath", this.m_outputPath);
        if (this.m_dataSetPath != null) {
            this.m_props.setProperty("dataSetPath", this.m_dataSetPath);
        }
        this.setRequiredProperty("street_fromLeft", this.m_leftStartAddrFieldName);
        this.setRequiredProperty("street_toLeft", this.m_leftEndAddrFieldName);
        this.setRequiredProperty("street_fromRight", this.m_rightStartAddrFieldName);
        this.setRequiredProperty("street_toRight", this.m_rightEndAddrFieldName);
        this.setRequiredProperty("street_mainAddress", this.m_streetFieldName);
        this.setRequiredProperty("street_leftAreaName1", this.m_stateFieldName);
        this.setRequiredProperty("street_rightAreaName1", this.m_stateFieldName);
        this.setRequiredProperty("street_leftPostCode1", this.m_leftZipCodeFieldName);
        this.setRequiredProperty("street_rightPostCode1", this.m_rightZipCodeFieldName);
        this.setOptionalProperty("street_leftAreaName3", this.m_cityFieldName);
        this.setOptionalProperty("street_rightAreaName3", this.m_cityFieldName);
        this.setOptionalProperty("street_leftPostCode2", this.m_leftZipAddOnFieldName);
        this.setOptionalProperty("street_leftPostCode2", this.m_rightZipAddOnFieldName);
        this.setOptionalProperty("street_leftRangeStatus", this.m_leftOddEvenFieldName);
        this.setOptionalProperty("street_rightRangeStatus", this.m_rightOddEvenFieldName);
        this.setOptionalProperty("street_leftPlaceName", this.m_placeFieldName);
        this.setOptionalProperty("street_rightPlaceName", this.m_placeFieldName);
        if (this.m_iProcessFlag == 1) {
            this.m_props.setProperty("startRow", Integer.toString(0));
            this.m_props.setProperty("endRow", Integer.toString(0));
        } else if (this.m_iProcessFlag == 2) {
            if (this.m_iStartRow < 0) {
                throw new UDDataCreationException(1901);
            }
            if (this.m_iEndRow < this.m_iStartRow) {
                throw new UDDataCreationException(1900);
            }
            this.m_props.setProperty("startRow", Integer.toString(this.m_iStartRow));
            this.m_props.setProperty("endRow", Integer.toString(this.m_iEndRow));
        } else {
            throw new UDDataCreationException(1904);
        }
    }

    protected void logProperties() {
        String keyString;
        DataCreationLogger.getLogger().logStatus("Data creation properties:");
        ArrayList<String> keyList = new ArrayList<String>();
        Set<Object> keys = this.m_props.keySet();
        Iterator<Object> keysIterator = keys.iterator();
        if (keysIterator != null) {
            while (keysIterator.hasNext()) {
                keyString = (String)keysIterator.next();
                keyList.add(keyString);
            }
        }
        Collections.sort(keyList);
        for (int i = 0; i < keyList.size(); ++i) {
            keyString = (String)keyList.get(i);
            if ("Log".equalsIgnoreCase(keyString)) {
                String containsLogFilesProp = this.m_props.getProperty("logFiles");
                if (!Boolean.valueOf(containsLogFilesProp).booleanValue()) continue;
                DataCreationLogger.getLogger().logStatus(keyString + "=" + this.m_props.get(keyString).toString());
                continue;
            }
            DataCreationLogger.getLogger().logStatus(keyString + "=" + this.m_props.getProperty(keyString));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int createData() {
        ProgressBarUpdaterProvider.assignProgressBarUpdater((IProgressBarUpdater)new ProgressBarUpdater());
        UDDataCreator dataCreator = new UDDataCreator();
        try {
            this.makeDataProperties();
            dataCreator.runProcess(this.m_props);
            ProgressBarUpdaterProvider.getUpdaterInstance().update(100);
        }
        catch (DataCreationException DCex) {
            DataCreationLogger.getLogger().logInternalError("DataCreationException: DataDict:: createData(): ");
            DataCreationLogger.getLogger().logError(DCex.getMessage());
            DataCreationLogger.getLogger().logStackTrace((Throwable)DCex);
            int n = this.translateUDError(DCex.getExceptionCode());
            return n;
        }
        catch (UserCancelledRuntimeException UCREx) {
            DataCreationLogger.getLogger().logStatus("User cancelled data creation at: " + new Date().toString());
            int n = 999;
            return n;
        }
        catch (OutOfMemoryError OOMEr) {
            DataCreationLogger.getLogger().logInternalError("OutOfMemoryError: DataDict:: createData(): ");
            DataCreationLogger.getLogger().logError(OOMEr.getMessage());
            DataCreationLogger.getLogger().logStackTrace((Throwable)OOMEr);
            int n = -1;
            return n;
        }
        catch (NullPointerException NPEx) {
            DataCreationLogger.getLogger().logInternalError("NullPointerException: DataDict:: createData(): ");
            DataCreationLogger.getLogger().logError(NPEx.getMessage());
            DataCreationLogger.getLogger().logStackTrace((Throwable)NPEx);
            int n = -1;
            return n;
        }
        catch (Throwable t) {
            DataCreationLogger.getLogger().logInternalError("Throwable: DataDict:: createData(): ");
            DataCreationLogger.getLogger().logError(t.getMessage());
            DataCreationLogger.getLogger().logStackTrace(t);
            int n = -1;
            return n;
        }
        finally {
            if (this.m_statusStream != null) {
                this.m_statusStream.flush();
                this.m_statusStream.close();
            }
            if (this.m_errorStream != null) {
                this.m_errorStream.flush();
                this.m_errorStream.close();
            }
            if (this.m_internalErrorStream != null) {
                this.m_internalErrorStream.flush();
                this.m_internalErrorStream.close();
            }
        }
        return 0;
    }

    private boolean stringLengthZero(String s) {
        if (s == null) {
            return true;
        }
        String sTrimmed = s.trim();
        return sTrimmed == null || sTrimmed.length() == 0;
    }

    protected void setRequiredProperty(String key, String value) throws UDDataCreationException {
        if (this.stringLengthZero(value)) {
            throw new UDDataCreationException(1906);
        }
        this.m_props.setProperty(key, value);
    }

    protected void setOptionalProperty(String key, String value) {
        if (this.stringLengthZero(value)) {
            this.m_props.setProperty(key, "NONE");
        } else {
            this.m_props.setProperty(key, value);
        }
    }

    private int translateUDError(int error) {
        switch (error) {
            case 1900: {
                return 703;
            }
            case 1901: {
                return 704;
            }
            case 1902: {
                return 711;
            }
            case 1903: {
                return 716;
            }
            case 1904: {
                return 719;
            }
            case 1905: {
                return 727;
            }
            case 1906: {
                return 728;
            }
        }
        return error;
    }
}

