/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.midev.coordsys;

import com.mapinfo.midev.coordsys.CodeSet;
import com.mapinfo.midev.coordsys.CoordSysType;
import com.mapinfo.midev.coordsys.transform.CoordTransform;
import com.mapinfo.midev.geometry.AffineTransform;
import com.mapinfo.midev.util.DoubleRect;
import com.mapinfo.midev.util.PublicAPI;
import java.io.Serializable;
import java.util.Locale;

@PublicAPI
public abstract class CoordSys
implements Serializable {
    private final String m_displayName;
    private final CodeSet m_codeSet;
    private final AffineTransform m_affineTransform;

    protected CoordSys(String displayName, CodeSet codeSet, AffineTransform affineTransform) {
        this.m_displayName = displayName;
        this.m_codeSet = codeSet == null ? new CodeSet() : codeSet;
        this.m_affineTransform = affineTransform == null ? AffineTransform.IDENTITY : affineTransform;
    }

    public abstract CoordSysType getType();

    public String getDisplayName(Locale locale) {
        return this.m_displayName;
    }

    public CodeSet getCodes() {
        return this.m_codeSet;
    }

    public AffineTransform getAffineTransform() {
        return this.m_affineTransform;
    }

    public abstract DoubleRect getMBR();

    public boolean equivalent(CoordSys coordSys) {
        if (coordSys == null) {
            return false;
        }
        return this.getType() == coordSys.getType() && this.m_affineTransform.equals((Object)coordSys.m_affineTransform);
    }

    public CoordTransform createCoordTransform(CoordSys destCoordSys) {
        return new CoordTransform(this, destCoordSys);
    }
}

