/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.midev.coordsys;

import com.mapinfo.midev.coordsys.CodeSet;
import com.mapinfo.midev.unit.LinearUnit;
import com.mapinfo.midev.util.ArgumentValidator;
import java.io.Serializable;
import java.util.Locale;

public class Ellipsoid
implements Serializable {
    private final String m_displayName;
    private final CodeSet m_codeSet;
    private final double m_semiMajorAxis;
    private final double m_semiMinorAxis;
    private final double m_flattening;
    private final double m_inverseFlattening;
    private final double m_eccentricity;
    private final double m_eccentricitySquared;
    private final LinearUnit m_axisUnit;

    public Ellipsoid(String displayName, CodeSet codeSet, double semiMajorAxis, double inverseFlattening, LinearUnit axisUnit) {
        ArgumentValidator.assertNotNullReference((String)"axisUnit", (Object)axisUnit);
        this.m_displayName = displayName;
        this.m_codeSet = codeSet == null ? new CodeSet() : codeSet;
        this.m_semiMajorAxis = semiMajorAxis;
        this.m_inverseFlattening = inverseFlattening;
        this.m_axisUnit = axisUnit;
        this.m_flattening = this.m_inverseFlattening == 0.0 ? 0.0 : 1.0 / this.m_inverseFlattening;
        this.m_semiMinorAxis = this.m_semiMajorAxis * (1.0 - this.m_flattening);
        this.m_eccentricitySquared = this.m_flattening * (2.0 - this.m_flattening);
        this.m_eccentricity = Math.sqrt(this.m_eccentricitySquared);
    }

    public String getDisplayName(Locale locale) {
        return this.m_displayName;
    }

    public CodeSet getCodes() {
        return this.m_codeSet;
    }

    public double getSemiMajorAxis() {
        return this.m_semiMajorAxis;
    }

    public double getSemiMinorAxis() {
        return this.m_semiMinorAxis;
    }

    public double getFlattening() {
        return this.m_flattening;
    }

    public double getInverseFlattening() {
        return this.m_inverseFlattening;
    }

    public double getEccentricity() {
        return this.m_eccentricity;
    }

    public double getEccentricitySquared() {
        return this.m_eccentricitySquared;
    }

    public LinearUnit getAxisUnit() {
        return this.m_axisUnit;
    }

    public boolean equivalent(Ellipsoid ellipsoid) {
        if (ellipsoid == null) {
            return false;
        }
        if (this == ellipsoid) {
            return true;
        }
        if (Double.compare(ellipsoid.m_inverseFlattening, this.m_inverseFlattening) != 0) {
            return false;
        }
        return Double.compare(LinearUnit.convert((double)ellipsoid.m_semiMajorAxis, (LinearUnit)ellipsoid.m_axisUnit, (LinearUnit)this.m_axisUnit), this.m_semiMajorAxis) == 0;
    }
}

