/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.midev.coordsys;

import com.mapinfo.midev.coordsys.CodeSet;
import com.mapinfo.midev.coordsys.Ellipsoid;
import com.mapinfo.midev.coordsys.PrimeMeridian;
import com.mapinfo.midev.util.ArgumentValidator;
import java.io.Serializable;
import java.util.Locale;

public class GeodeticDatum
implements Serializable {
    private final String m_displayName;
    private final CodeSet m_codeSet;
    private final Ellipsoid m_ellipsoid;
    private final PrimeMeridian m_primeMeridian;

    public GeodeticDatum(String displayName, CodeSet codeSet, Ellipsoid ellipsoid, PrimeMeridian primeMeridian) {
        ArgumentValidator.assertNotNullReference((String)"ellipsoid", (Object)ellipsoid);
        ArgumentValidator.assertNotNullReference((String)"primeMeridian", (Object)primeMeridian);
        this.m_displayName = displayName;
        this.m_codeSet = codeSet == null ? new CodeSet() : codeSet;
        this.m_ellipsoid = ellipsoid;
        this.m_primeMeridian = primeMeridian;
    }

    public String getDisplayName(Locale locale) {
        return this.m_displayName;
    }

    public CodeSet getCodes() {
        return this.m_codeSet;
    }

    public Ellipsoid getEllipsoid() {
        return this.m_ellipsoid;
    }

    public PrimeMeridian getPrimeMeridian() {
        return this.m_primeMeridian;
    }

    public boolean equivalent(GeodeticDatum datum) {
        if (datum == null) {
            return false;
        }
        if (this == datum) {
            return true;
        }
        if (!this.m_ellipsoid.equivalent(datum.m_ellipsoid)) {
            return false;
        }
        return this.m_primeMeridian.equivalent(datum.m_primeMeridian);
    }
}

