/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.midev.coordsys;

import com.mapinfo.midev.coordsys.CodeSet;
import com.mapinfo.midev.coordsys.GeodeticDatum;
import com.mapinfo.midev.util.ArgumentValidator;
import java.io.Serializable;
import java.util.Locale;

public class GeodeticDatumOperation
implements Serializable {
    private final String m_displayName;
    private final CodeSet m_codeSet;
    private final GeodeticDatum m_datum;
    private final double m_shiftX;
    private final double m_shiftY;
    private final double m_shiftZ;
    private final double m_rotateX;
    private final double m_rotateY;
    private final double m_rotateZ;
    private final double m_scaleAdjust;

    public GeodeticDatumOperation(String displayName, CodeSet codeSet, GeodeticDatum datum, double shiftX, double shiftY, double shiftZ, double rotateX, double rotateY, double rotateZ, double scaleAdjust) {
        ArgumentValidator.assertNotNullReference((String)"datum", (Object)datum);
        this.m_displayName = displayName;
        this.m_codeSet = codeSet == null ? new CodeSet() : codeSet;
        this.m_datum = datum;
        this.m_shiftX = shiftX;
        this.m_shiftY = shiftY;
        this.m_shiftZ = shiftZ;
        this.m_rotateX = rotateX;
        this.m_rotateY = rotateY;
        this.m_rotateZ = rotateZ;
        this.m_scaleAdjust = scaleAdjust;
    }

    public String getDisplayName(Locale locale) {
        return this.m_displayName;
    }

    public CodeSet getCodes() {
        return this.m_codeSet;
    }

    public GeodeticDatum getGeodeticDatum() {
        return this.m_datum;
    }

    public double getShiftX() {
        return this.m_shiftX;
    }

    public double getShiftY() {
        return this.m_shiftY;
    }

    public double getShiftZ() {
        return this.m_shiftZ;
    }

    public double getRotateX() {
        return this.m_rotateX;
    }

    public double getRotateY() {
        return this.m_rotateY;
    }

    public double getRotateZ() {
        return this.m_rotateZ;
    }

    public double getScaleAdjust() {
        return this.m_scaleAdjust;
    }

    public boolean equivalent(GeodeticDatumOperation datumOperation) {
        if (datumOperation == null) {
            return false;
        }
        if (this == datumOperation) {
            return true;
        }
        if (Double.compare(datumOperation.m_rotateX, this.m_rotateX) != 0) {
            return false;
        }
        if (Double.compare(datumOperation.m_rotateY, this.m_rotateY) != 0) {
            return false;
        }
        if (Double.compare(datumOperation.m_rotateZ, this.m_rotateZ) != 0) {
            return false;
        }
        if (Double.compare(datumOperation.m_scaleAdjust, this.m_scaleAdjust) != 0) {
            return false;
        }
        if (Double.compare(datumOperation.m_shiftX, this.m_shiftX) != 0) {
            return false;
        }
        if (Double.compare(datumOperation.m_shiftY, this.m_shiftY) != 0) {
            return false;
        }
        if (Double.compare(datumOperation.m_shiftZ, this.m_shiftZ) != 0) {
            return false;
        }
        return this.m_datum.equivalent(datumOperation.m_datum);
    }
}

