/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.midev.coordsys;

import com.mapinfo.midev.unit.AngularUnit;
import com.mapinfo.midev.util.ArgumentValidator;
import java.io.Serializable;
import java.util.Locale;

public class PrimeMeridian
implements Serializable {
    public static final PrimeMeridian GREENWICH = new PrimeMeridian("Greenwich", 0.0, AngularUnit.DEGREE);
    public static final PrimeMeridian PARIS = new PrimeMeridian("Paris", 2.337229166667, AngularUnit.DEGREE);
    public static final PrimeMeridian FERRO = new PrimeMeridian("Paris", -17.666666666667, AngularUnit.DEGREE);
    private final double m_longitude;
    private final AngularUnit m_angularUnit;
    private final String m_displayName;

    public PrimeMeridian(String displayName, double longitude, AngularUnit angularUnit) {
        ArgumentValidator.assertNotNullReference((String)"angularUnit", (Object)angularUnit);
        this.m_displayName = displayName;
        this.m_longitude = longitude;
        this.m_angularUnit = angularUnit;
    }

    public String getDisplayName(Locale locale) {
        return this.m_displayName;
    }

    public double getLongitude() {
        return this.m_longitude;
    }

    public AngularUnit getAngularUnit() {
        return this.m_angularUnit;
    }

    public boolean equivalent(PrimeMeridian primeMeridian) {
        if (primeMeridian == null) {
            return false;
        }
        if (this.m_angularUnit.equals((Object)primeMeridian.m_angularUnit)) {
            return Double.compare(this.m_longitude, primeMeridian.m_longitude) == 0;
        }
        return Double.compare(this.m_longitude, AngularUnit.convert((double)primeMeridian.m_longitude, (AngularUnit)primeMeridian.m_angularUnit, (AngularUnit)this.m_angularUnit)) == 0;
    }
}

