/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.midev.coordsys.factory.prj;

import com.google.common.collect.Iterators;
import com.mapinfo.midev.coordsys.parser.LegacyCoordSysParams;
import com.mapinfo.midev.coordsys.parser.PRJCoordSysParser;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.LineIterator;
import org.apache.commons.lang3.StringUtils;

public final class PRJCoordSysProvider {
    private static final List<String> ADDITIONAL_PRJ_LINES = Arrays.asList("\"Longitude / Latitude (NAD 83)\\p4269\", 1, 33", "\"New Zealand Transverse Mercator (NZGD2000)\\p2193\", 8, 33, 7, 173, 0, 0.9996, 1600000, 10000000");

    private PRJCoordSysProvider() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<LegacyCoordSysParams> list() {
        ArrayList<LegacyCoordSysParams> result = new ArrayList<LegacyCoordSysParams>();
        InputStream in = PRJCoordSysProvider.class.getResourceAsStream("/MAPINFOW.PRJ");
        try (LineIterator iterator = IOUtils.lineIterator((InputStream)in, (Charset)StandardCharsets.ISO_8859_1);){
            Iterator i = Iterators.concat(ADDITIONAL_PRJ_LINES.iterator(), (Iterator)iterator);
            while (i.hasNext()) {
                String line = (String)i.next();
                if (!StringUtils.isNotEmpty((CharSequence)line) || line.startsWith("\"---")) continue;
                result.add(PRJCoordSysParser.parse(line));
            }
        }
        catch (Exception e) {
            throw new IllegalStateException("Error reading MAPINFOW.PRJ file.", e);
        }
        return result;
    }
}

