/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.midev.coordsys.parser;

import com.mapinfo.midev.coordsys.PrimeMeridian;
import com.mapinfo.midev.coordsys.parser.LegacyProjectionParser;
import com.mapinfo.midev.geometry.AffineTransform;
import com.mapinfo.midev.unit.LinearUnit;
import com.mapinfo.midev.util.DoubleRect;

public final class LegacyCoordSysParams {
    private String m_displayName = null;
    private String m_codeSpace = null;
    private String m_code = null;
    private int m_projectionType = -1;
    private AffineTransform m_affineTransform = AffineTransform.IDENTITY;
    private int m_ellipsoidIndex = -1;
    private int m_datumIndex = -1;
    private double m_datumShiftX = 0.0;
    private double m_datumShiftY = 0.0;
    private double m_datumShiftZ = 0.0;
    private double m_datumRotateX = 0.0;
    private double m_datumRotateY = 0.0;
    private double m_datumRotateZ = 0.0;
    private double m_datumScaleAdjust = 1.0;
    private PrimeMeridian m_primeMeridian = PrimeMeridian.GREENWICH;
    private LinearUnit m_linearUnit = LinearUnit.METER;
    private double[] m_projectionParams = null;
    private DoubleRect m_bounds = null;

    public String getDisplayName() {
        return this.m_displayName;
    }

    public void setDisplayName(String displayName) {
        this.m_displayName = displayName;
    }

    public String getCodeSpace() {
        return this.m_codeSpace;
    }

    public void setCodeSpace(String codeSpace) {
        this.m_codeSpace = codeSpace;
    }

    public String getCode() {
        return this.m_code;
    }

    public void setCode(String code) {
        this.m_code = code;
    }

    public int getProjectionType() {
        return this.m_projectionType;
    }

    public void setProjectionType(int projectionType) {
        this.m_projectionType = projectionType;
    }

    public AffineTransform getAffineTransform() {
        return this.m_affineTransform;
    }

    public void setAffineTransform(AffineTransform affineTransform) {
        this.m_affineTransform = affineTransform;
    }

    public int getEllipsoidIndex() {
        return this.m_ellipsoidIndex;
    }

    public void setEllipsoidIndex(int ellipsoidIndex) {
        this.m_ellipsoidIndex = ellipsoidIndex;
    }

    public int getDatumIndex() {
        return this.m_datumIndex;
    }

    public void setDatumIndex(int datumIndex) {
        this.m_datumIndex = datumIndex;
    }

    public double getDatumShiftX() {
        return this.m_datumShiftX;
    }

    public void setDatumShiftX(double datumShiftX) {
        this.m_datumShiftX = datumShiftX;
    }

    public double getDatumShiftY() {
        return this.m_datumShiftY;
    }

    public void setDatumShiftY(double datumShiftY) {
        this.m_datumShiftY = datumShiftY;
    }

    public double getDatumShiftZ() {
        return this.m_datumShiftZ;
    }

    public void setDatumShiftZ(double datumShiftZ) {
        this.m_datumShiftZ = datumShiftZ;
    }

    public double getDatumRotateX() {
        return this.m_datumRotateX;
    }

    public void setDatumRotateX(double datumRotateX) {
        this.m_datumRotateX = datumRotateX;
    }

    public double getDatumRotateY() {
        return this.m_datumRotateY;
    }

    public void setDatumRotateY(double datumRotateY) {
        this.m_datumRotateY = datumRotateY;
    }

    public double getDatumRotateZ() {
        return this.m_datumRotateZ;
    }

    public void setDatumRotateZ(double datumRotateZ) {
        this.m_datumRotateZ = datumRotateZ;
    }

    public double getDatumScaleAdjust() {
        return this.m_datumScaleAdjust;
    }

    public void setDatumScaleAdjust(double datumScaleAdjust) {
        this.m_datumScaleAdjust = datumScaleAdjust;
    }

    public PrimeMeridian getPrimeMeridian() {
        return this.m_primeMeridian;
    }

    public void setPrimeMeridian(PrimeMeridian primeMeridian) {
        this.m_primeMeridian = primeMeridian;
    }

    public LinearUnit getLinearUnit() {
        return this.m_linearUnit;
    }

    public void setLinearUnit(LinearUnit linearUnit) {
        this.m_linearUnit = linearUnit;
    }

    public double[] getProjectionParams() {
        return this.m_projectionParams;
    }

    public void setProjectionParams(double[] projectionParams) {
        this.m_projectionParams = projectionParams;
    }

    public DoubleRect getBounds() {
        return this.m_bounds;
    }

    public void setBounds(DoubleRect bounds) {
        this.m_bounds = bounds;
    }

    public String toMapInfoCode() {
        StringBuilder code = new StringBuilder("coordsys ");
        int projectionType = this.getProjectionType();
        if (this.m_bounds != null) {
            projectionType += 2000;
        }
        if (!this.getAffineTransform().isIdentity()) {
            projectionType += 1000;
        }
        code.append(projectionType);
        if (this.getProjectionType() != 0) {
            code.append(", ");
            code.append(this.getDatumIndex());
            if (this.getDatumIndex() == 999 || this.getDatumIndex() == 9999) {
                code.append(", ");
                code.append(this.getEllipsoidIndex());
                code.append(", ");
                code.append(this.getDatumShiftX());
                code.append(", ");
                code.append(this.getDatumShiftY());
                code.append(", ");
                code.append(this.getDatumShiftZ());
                if (this.getDatumIndex() == 9999) {
                    code.append(", ");
                    code.append(this.getDatumRotateX());
                    code.append(", ");
                    code.append(this.getDatumRotateY());
                    code.append(", ");
                    code.append(this.getDatumRotateZ());
                    code.append(", ");
                    code.append(this.getDatumScaleAdjust());
                    code.append(", ");
                    code.append(this.getPrimeMeridian().getLongitude());
                }
            }
        }
        if (this.getProjectionType() != 1) {
            code.append(", ");
            code.append(this.getLinearUnit().getMapInfoProIndex());
        }
        if (this.getProjectionParams() != null) {
            for (int i = 0; i < LegacyProjectionParser.getParamCount(this.getProjectionType()); ++i) {
                code.append(", ");
                code.append(this.getProjectionParams()[i]);
            }
        }
        if (!this.getAffineTransform().isIdentity()) {
            code.append(", ");
            code.append(this.getLinearUnit().getMapInfoProIndex());
            double[] coefficients = new double[6];
            this.getAffineTransform().getRowFirstCoefficients(coefficients);
            for (double c : coefficients) {
                code.append(", ");
                code.append(c);
            }
        }
        if (this.m_bounds != null) {
            code.append(", ");
            code.append(this.m_bounds.getMinX());
            code.append(", ");
            code.append(this.m_bounds.getMinY());
            code.append(", ");
            code.append(this.m_bounds.getMaxX());
            code.append(", ");
            code.append(this.m_bounds.getMaxY());
        }
        return code.toString();
    }
}

