/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.midev.coordsys.parser;

import com.mapinfo.midev.coordsys.Ellipsoid;
import com.mapinfo.midev.coordsys.PrimeMeridian;
import com.mapinfo.midev.coordsys.factory.CoordSysFactory;
import com.mapinfo.midev.coordsys.parser.UnknownProjectionException;
import com.mapinfo.midev.coordsys.parser.UnknownProjectionParamException;
import com.mapinfo.midev.coordsys.projection.IProjectionFactory;
import com.mapinfo.midev.coordsys.projection.Projection;
import com.mapinfo.midev.coordsys.projection.ProjectionParamType;
import com.mapinfo.midev.coordsys.projection.ProjectionParams;
import com.mapinfo.midev.unit.Angle;
import com.mapinfo.midev.unit.AngularUnit;
import com.mapinfo.midev.unit.LinearUnit;
import com.mapinfo.midev.unit.Offset;
import com.mapinfo.midev.util.ArgumentValidator;
import com.mapinfo.midev.util.Code;

public class LegacyProjectionParser {
    private static final int[] PARAM_COUNT = new int[]{0, 0, 2, 6, 3, 3, 6, 6, 5, 6, 1, 1, 1, 1, 1, 1, 1, 1, 4, 6, 5, 5, 5, 5, 5, 4, 2, 4, 3, 3, 4, 5, 6, 4, 5, 7};

    private LegacyProjectionParser() {
    }

    static int getParamCount(int type) {
        return PARAM_COUNT[type];
    }

    public static Projection create(Code code, LinearUnit linearUnit, Ellipsoid ellipsoid, PrimeMeridian primeMeridian, double[] params) {
        ArgumentValidator.assertNotNullReference((String)"code", (Object)code);
        IProjectionFactory projectionFactory = CoordSysFactory.getDefaultCoordSysFactory().getProjectionFactory(code.getCodeSpace(), code.getCode());
        if (projectionFactory == null) {
            throw new UnknownProjectionException(code);
        }
        ProjectionParams projectionParams = LegacyProjectionParser.createParams(linearUnit, ellipsoid, primeMeridian, params, projectionFactory.getParamInfo());
        return projectionFactory.createProjection(projectionParams);
    }

    public static ProjectionParams createParams(LinearUnit linearUnit, Ellipsoid ellipsoid, PrimeMeridian primeMeridian, double[] params, ProjectionParamType[] paramInfo) {
        Angle originLongitude = ProjectionParams.DEFAULT_ORIGIN_LONGITUDE;
        Angle originLatitude = ProjectionParams.DEFAULT_ORIGIN_LATITUDE;
        Angle standardParallel1 = ProjectionParams.DEFAULT_STANDARD_PARALLEL_1;
        Angle standardParallel2 = ProjectionParams.DEFAULT_STANDARD_PARALLEL_2;
        Angle azimuth = ProjectionParams.DEFAULT_AZIMUTH;
        Angle bearing = ProjectionParams.DEFAULT_BEARING;
        double scaleFactor = 1.0;
        Offset falseEasting = ProjectionParams.DEFAULT_FALSE_EASTING;
        Offset falseNorthing = ProjectionParams.DEFAULT_FALSE_NORTHING;
        Angle range = ProjectionParams.DEFAULT_RANGE;
        int paramCount = Math.min(params.length, paramInfo.length);
        block12: for (int n = 0; n < paramCount; ++n) {
            switch (paramInfo[n]) {
                case ORIGIN_LONGITUDE: {
                    originLongitude = new Angle(params[n], AngularUnit.DEGREE);
                    continue block12;
                }
                case ORIGIN_LATITUDE: {
                    originLatitude = new Angle(params[n], AngularUnit.DEGREE);
                    continue block12;
                }
                case STANDARD_PARALLEL_1: {
                    standardParallel1 = new Angle(params[n], AngularUnit.DEGREE);
                    continue block12;
                }
                case STANDARD_PARALLEL_2: {
                    standardParallel2 = new Angle(params[n], AngularUnit.DEGREE);
                    continue block12;
                }
                case AZIMUTH: {
                    azimuth = new Angle(params[n], AngularUnit.DEGREE);
                    continue block12;
                }
                case BEARING: {
                    bearing = new Angle(params[n], AngularUnit.DEGREE);
                    continue block12;
                }
                case SCALE_FACTOR: {
                    scaleFactor = params[n];
                    continue block12;
                }
                case FALSE_EASTING: {
                    falseEasting = new Offset(params[n], linearUnit);
                    continue block12;
                }
                case FALSE_NORTHING: {
                    falseNorthing = new Offset(params[n], linearUnit);
                    continue block12;
                }
                case RANGE: {
                    range = new Angle(params[n], AngularUnit.DEGREE);
                    continue block12;
                }
                default: {
                    throw new UnknownProjectionParamException(n, paramInfo[n]);
                }
            }
        }
        return new ProjectionParams(linearUnit, ellipsoid, primeMeridian, originLongitude, originLatitude, standardParallel1, standardParallel2, azimuth, bearing, scaleFactor, falseEasting, falseNorthing, range);
    }

    public static Projection create(int type, LinearUnit linearUnit, Ellipsoid ellipsoid, PrimeMeridian primeMeridian, double[] params) {
        if (type == 0 || type == 1) {
            return null;
        }
        return LegacyProjectionParser.create(new Code("mapinfo", "projection" + type), linearUnit, ellipsoid, primeMeridian, params);
    }
}

