/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.midev.coordsys.parser;

import com.mapinfo.midev.coordsys.PrimeMeridian;
import com.mapinfo.midev.coordsys.UnknownSRSNameException;
import com.mapinfo.midev.coordsys.parser.LegacyCoordSysParams;
import com.mapinfo.midev.coordsys.parser.LegacyProjectionParser;
import com.mapinfo.midev.geometry.AffineTransform;
import com.mapinfo.midev.unit.AngularUnit;
import com.mapinfo.midev.unit.LinearUnit;
import com.mapinfo.midev.util.DoubleRect;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class PRJCoordSysParser {
    private static final Pattern PATTERN = Pattern.compile("(?:\"([^\"]*)\")\\s*,\\s*(.+)", 10);

    private PRJCoordSysParser() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static LegacyCoordSysParams parse(String s) {
        Matcher m = PATTERN.matcher(s.trim());
        if (!m.matches()) return PRJCoordSysParser.parsePrjString(s.trim());
        if (m.groupCount() != 2) throw new UnknownSRSNameException(s);
        LegacyCoordSysParams params = PRJCoordSysParser.parsePrjString(m.group(2));
        String[] ss = m.group(1).split("\\\\p");
        params.setDisplayName(ss[0].trim());
        if (ss.length > 1) {
            String codeAndCodeSpace = ss[1];
            if ((ss = codeAndCodeSpace.split(":")).length == 1) {
                params.setCodeSpace("epsg");
                params.setCode(ss[0].trim());
                return params;
            } else {
                if (ss.length != 2) throw new UnknownSRSNameException(codeAndCodeSpace);
                params.setCodeSpace(ss[0].trim());
                params.setCode(ss[1].trim());
            }
            return params;
        } else {
            params.setCodeSpace("mapinfo");
            params.setCode("coordsys " + m.group(2).replaceAll("\\s*,\\s*", ", "));
        }
        return params;
    }

    static LegacyCoordSysParams parsePrjString(String s) {
        int type;
        LegacyCoordSysParams params = new LegacyCoordSysParams();
        boolean hasAT = false;
        boolean hasBounds = false;
        String[] ss = s.split("\\s*,\\s*");
        int i = 0;
        if ((type = Integer.parseInt(ss[i++])) >= 2000) {
            type -= 2000;
            hasBounds = true;
        }
        if (type >= 1000) {
            type -= 1000;
            hasAT = true;
        }
        params.setProjectionType(type);
        if (params.getProjectionType() == 0) {
            params.setDatumIndex(-1);
            params.setPrimeMeridian(null);
        } else {
            params.setDatumIndex(Integer.parseInt(ss[i++]));
            if (params.getDatumIndex() == 999 || params.getDatumIndex() == 9999) {
                params.setEllipsoidIndex(Integer.parseInt(ss[i++]));
                params.setDatumShiftX(Double.parseDouble(ss[i++]));
                params.setDatumShiftY(Double.parseDouble(ss[i++]));
                params.setDatumShiftZ(Double.parseDouble(ss[i++]));
                if (params.getDatumIndex() == 9999) {
                    params.setDatumRotateX(Double.parseDouble(ss[i++]));
                    params.setDatumRotateY(Double.parseDouble(ss[i++]));
                    params.setDatumRotateZ(Double.parseDouble(ss[i++]));
                    params.setDatumScaleAdjust(Double.parseDouble(ss[i++]));
                    params.setPrimeMeridian(new PrimeMeridian(null, Double.parseDouble(ss[i++]), AngularUnit.DEGREE));
                } else {
                    params.setDatumRotateX(0.0);
                    params.setDatumRotateY(0.0);
                    params.setDatumRotateZ(0.0);
                    params.setDatumScaleAdjust(0.0);
                    params.setPrimeMeridian(PrimeMeridian.GREENWICH);
                }
            } else {
                params.setPrimeMeridian(params.getDatumIndex() == 1002 ? PrimeMeridian.PARIS : PrimeMeridian.GREENWICH);
            }
        }
        if (params.getProjectionType() != 1) {
            params.setLinearUnit(PRJCoordSysParser.parseLinearUnit(ss[i++]));
        }
        double[] projParams = new double[LegacyProjectionParser.getParamCount(params.getProjectionType())];
        try {
            for (int j = 0; j < projParams.length; ++j) {
                projParams[j] = Double.parseDouble(ss[i++]);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Error parsing PRJ String: " + s, e);
        }
        params.setProjectionParams(projParams);
        if (hasAT) {
            params.setAffineTransform(PRJCoordSysParser.parseAffineTransform(ss, i));
            i += 7;
        } else {
            params.setAffineTransform(AffineTransform.IDENTITY);
        }
        if (hasBounds) {
            params.setBounds(new DoubleRect(Double.parseDouble(ss[i++]), Double.parseDouble(ss[i++]), Double.parseDouble(ss[i++]), Double.parseDouble(ss[i++])));
        }
        return params;
    }

    static LinearUnit parseLinearUnit(String s) {
        LinearUnit unit;
        block2: {
            try {
                unit = LinearUnit.getFromMapInfoProIndex((int)Integer.parseInt(s));
            }
            catch (NumberFormatException e) {
                unit = LinearUnit.getFromMapInfoCode((String)s.replace('\"', ' ').trim());
                if (unit != null) break block2;
                unit = LinearUnit.getFromMapBasicAbbreviation((String)s.replace('\"', ' ').trim());
            }
        }
        return unit;
    }

    static AffineTransform parseAffineTransform(String[] ss, int start) {
        LinearUnit unit = PRJCoordSysParser.parseLinearUnit(ss[start++]);
        double[] coefficients = new double[6];
        for (int j = 0; j < coefficients.length; ++j) {
            coefficients[j] = Double.parseDouble(ss[start++]);
        }
        return AffineTransform.getRowFirstInstance((double)coefficients[0], (double)coefficients[1], (double)coefficients[2], (double)coefficients[3], (double)coefficients[4], (double)coefficients[5]);
    }
}

