/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.midev.coordsys.projection;

import com.mapinfo.midev.coordsys.CodeSet;
import com.mapinfo.midev.coordsys.projection.IProjectionFactory;
import com.mapinfo.midev.coordsys.projection.Projection;
import com.mapinfo.midev.coordsys.projection.ProjectionParamType;
import com.mapinfo.midev.coordsys.projection.ProjectionParams;
import com.mapinfo.midev.coordsys.util.CoordSysUtilities;
import com.mapinfo.midev.geometry.DirectPosition;
import com.mapinfo.midev.unit.AngularUnit;
import com.mapinfo.midev.unit.LinearUnit;
import com.mapinfo.midev.util.Code;
import com.mapinfo.midev.util.MathUtil;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class CassiniSoldnerFactory
implements IProjectionFactory {
    private static final ProjectionParamType[] PARAM_INFO = new ProjectionParamType[]{ProjectionParamType.ORIGIN_LONGITUDE, ProjectionParamType.ORIGIN_LATITUDE, ProjectionParamType.FALSE_EASTING, ProjectionParamType.FALSE_NORTHING};
    private static final Set<Code> CODE_SET;

    @Override
    public ProjectionParamType[] getParamInfo() {
        return PARAM_INFO;
    }

    @Override
    public Set<Code> getSupportedCodes() {
        return CODE_SET;
    }

    @Override
    public Projection createProjection(ProjectionParams projectionParams) {
        return new CassiniSoldner(new CodeSet(this.getSupportedCodes()), projectionParams);
    }

    static {
        HashSet<Code> result = new HashSet<Code>();
        result.add(new Code("epsg", "9806"));
        result.add(new Code("mapinfo", "projection30"));
        CODE_SET = Collections.unmodifiableSet(result);
    }

    private static class CassiniSoldner
    extends Projection
    implements Serializable {
        private double m_lambda0;
        private double m_MultY;
        private double m_Aprime;
        private double m_Bprime;
        private double m_Cprime;
        private double m_Aprime2;
        private double m_Bprime2;
        private double m_Cprime2;
        private double m_Dprime2;
        private double m_M0;

        public CassiniSoldner(CodeSet codeSet, ProjectionParams projectionParams) {
            super("Cassini-Soldner", codeSet, projectionParams);
            this.calcInternals();
        }

        private void calcInternals() {
            ProjectionParams projectionParams = this.getProjectionParams();
            this.m_lambda0 = CoordSysUtilities.convertClip(projectionParams.getOriginLongitude(), AngularUnit.RADIAN, -360.0, 360.0);
            double e1 = (1.0 - Math.sqrt(1.0 - projectionParams.getEllipsoid().getEccentricitySquared())) / (1.0 + Math.sqrt(1.0 - projectionParams.getEllipsoid().getEccentricitySquared()));
            double e1_2 = e1 * e1;
            double e1_3 = e1 * e1_2;
            double e1_4 = e1_2 * e1_2;
            double phi0 = CoordSysUtilities.convertClip(projectionParams.getOriginLatitude(), AngularUnit.RADIAN, -90.0, 90.0);
            double e4 = projectionParams.getEllipsoid().getEccentricitySquared() * projectionParams.getEllipsoid().getEccentricitySquared();
            double e6 = projectionParams.getEllipsoid().getEccentricitySquared() * e4;
            double A = projectionParams.getEllipsoid().getSemiMajorAxis() * -(3.0 * projectionParams.getEllipsoid().getEccentricitySquared() / 8.0 + 3.0 * e4 / 32.0 + 45.0 * e6 / 1024.0);
            double B = projectionParams.getEllipsoid().getSemiMajorAxis() * (15.0 * e4 / 256.0 + 45.0 * e6 / 1024.0);
            double C = projectionParams.getEllipsoid().getSemiMajorAxis() * -35.0 * e6 / 3072.0;
            this.m_MultY = projectionParams.getEllipsoid().getSemiMajorAxis() * (1.0 - projectionParams.getEllipsoid().getEccentricitySquared() / 4.0 - 3.0 * e4 / 64.0 - 5.0 * e6 / 256.0);
            this.m_Aprime = A - C;
            this.m_Bprime = 2.0 * B;
            this.m_Cprime = 4.0 * C;
            A = 3.0 * e1 / 2.0 - 27.0 * e1_3 / 32.0;
            B = 21.0 * e1_2 / 16.0 - 55.0 * e1_4 / 32.0;
            C = 151.0 * e1_3 / 96.0;
            double D = 1097.0 * e1_4 / 512.0;
            this.m_Aprime2 = A - C;
            this.m_Bprime2 = 2.0 * B - 4.0 * D;
            this.m_Cprime2 = 4.0 * C;
            this.m_Dprime2 = 8.0 * D;
            double phi2 = phi0 * 2.0;
            double cosphi2 = Math.cos(phi2);
            this.m_M0 = this.m_MultY * phi0 + Math.sin(phi2) * (this.m_Aprime + cosphi2 * (this.m_Bprime + cosphi2 * this.m_Cprime));
        }

        @Override
        public DirectPosition fromLongLat(DirectPosition source, DirectPosition destination) {
            double y;
            double x;
            ProjectionParams projectionParams = this.getProjectionParams();
            double lambdadiff = CoordSysUtilities.convertClip(source.getX() - projectionParams.getOriginLongitude().getValue(AngularUnit.DEGREE), AngularUnit.DEGREE, AngularUnit.RADIAN, -360.0, 360.0);
            double phi = CoordSysUtilities.convertClip(source.getY(), AngularUnit.DEGREE, AngularUnit.RADIAN, -180.0, 180.0);
            double cosphi = Math.cos(phi);
            if (0.0 == cosphi || 1.5707963267948966 == phi || -1.5707963267948966 == phi) {
                x = 0.0;
                y = this.m_MultY * phi - this.m_M0;
            } else {
                double sinphi = Math.sin(phi);
                double tanphi = Math.tan(phi);
                double phi2 = phi * 2.0;
                double cosphi2 = Math.cos(phi2);
                double M = this.m_MultY * phi + Math.sin(phi2) * (this.m_Aprime + cosphi2 * (this.m_Bprime + cosphi2 * this.m_Cprime));
                double C = projectionParams.getEllipsoid().getEccentricitySquared() * cosphi * cosphi / (1.0 - projectionParams.getEllipsoid().getEccentricitySquared());
                double A = lambdadiff * cosphi;
                double A2 = A * A;
                double A3 = A2 * A;
                double A4 = A3 * A;
                double A5 = A4 * A;
                double T = tanphi * tanphi;
                double N = projectionParams.getEllipsoid().getSemiMajorAxis() / Math.sqrt(1.0 - projectionParams.getEllipsoid().getEccentricitySquared() * sinphi * sinphi);
                x = N * (A - T * A3 / 6.0 - (8.0 - T + 8.0 * C) * T * A5 / 120.0);
                y = M - this.m_M0 + N * tanphi * (A2 / 2.0 + (5.0 - T + 6.0 * C) * A4 / 24.0);
            }
            x = LinearUnit.convert((double)x, (LinearUnit)projectionParams.getEllipsoid().getAxisUnit(), (LinearUnit)projectionParams.getLinearUnit());
            y = LinearUnit.convert((double)y, (LinearUnit)projectionParams.getEllipsoid().getAxisUnit(), (LinearUnit)projectionParams.getLinearUnit());
            destination.setXY(x += projectionParams.getFalseEasting().getValue(projectionParams.getLinearUnit()), y += projectionParams.getFalseNorthing().getValue(projectionParams.getLinearUnit()));
            return destination;
        }

        @Override
        public DirectPosition toLongLat(DirectPosition source, DirectPosition destination) {
            ProjectionParams projectionParams = this.getProjectionParams();
            double x = source.getX() - projectionParams.getFalseEasting().getValue(projectionParams.getLinearUnit());
            double y = source.getY() - projectionParams.getFalseNorthing().getValue(projectionParams.getLinearUnit());
            x = LinearUnit.convert((double)x, (LinearUnit)projectionParams.getLinearUnit(), (LinearUnit)projectionParams.getEllipsoid().getAxisUnit());
            y = LinearUnit.convert((double)y, (LinearUnit)projectionParams.getLinearUnit(), (LinearUnit)projectionParams.getEllipsoid().getAxisUnit());
            double M1 = this.m_M0 + y;
            double mu1 = M1 / this.m_MultY;
            double twomu1 = 2.0 * mu1;
            double costwomu1 = Math.cos(twomu1);
            double phi1 = mu1 + Math.sin(twomu1) * (this.m_Aprime2 + costwomu1 * (this.m_Bprime2 + costwomu1 * (this.m_Cprime2 + this.m_Dprime2 * costwomu1)));
            if (1.5707963267948966 == (phi1 = MathUtil.clip((double)phi1, (double)-1.5707963267948966, (double)1.5707963267948966)) || -1.5707963267948966 == phi1) {
                x = this.m_lambda0;
                y = phi1;
            } else {
                double tanphi1 = Math.tan(phi1);
                double sinphi1 = Math.sin(phi1);
                double cosphi1 = Math.cos(phi1);
                double T1 = tanphi1 * tanphi1;
                double temp = 1.0 - projectionParams.getEllipsoid().getEccentricitySquared() * sinphi1 * sinphi1;
                double N1 = projectionParams.getEllipsoid().getSemiMajorAxis() / Math.sqrt(temp);
                double R1 = projectionParams.getEllipsoid().getSemiMajorAxis() * (1.0 - projectionParams.getEllipsoid().getEccentricitySquared()) / (temp * Math.sqrt(temp));
                double D = x / N1;
                double D2 = D * D;
                double D3 = D2 * D;
                double D4 = D3 * D;
                double D5 = D4 * D;
                x = this.m_lambda0 + (D - T1 * D3 / 3.0 + (1.0 + 3.0 * T1) * T1 * D5 / 15.0) / cosphi1;
                y = phi1 - N1 * tanphi1 / R1 * (D2 / 2.0 - (1.0 + 3.0 * T1) * D4 / 24.0);
            }
            x = CoordSysUtilities.convertClip(x, AngularUnit.RADIAN, AngularUnit.DEGREE, -360.0, 360.0);
            y = CoordSysUtilities.convertClip(y, AngularUnit.RADIAN, AngularUnit.DEGREE, -90.0, 90.0);
            destination.setXY(x, y);
            return destination;
        }
    }
}

