/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.midev.coordsys.projection;

import com.mapinfo.midev.coordsys.CodeSet;
import com.mapinfo.midev.coordsys.projection.IProjectionFactory;
import com.mapinfo.midev.coordsys.projection.Projection;
import com.mapinfo.midev.coordsys.projection.ProjectionParamType;
import com.mapinfo.midev.coordsys.projection.ProjectionParams;
import com.mapinfo.midev.coordsys.util.CoordSysUtilities;
import com.mapinfo.midev.geometry.DirectPosition;
import com.mapinfo.midev.unit.AngularUnit;
import com.mapinfo.midev.unit.LinearUnit;
import com.mapinfo.midev.util.Code;
import com.mapinfo.midev.util.MathUtil;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public final class EquidistantCylindricalFactory
implements IProjectionFactory {
    private static final ProjectionParamType[] PARAM_INFO = new ProjectionParamType[]{ProjectionParamType.ORIGIN_LONGITUDE, ProjectionParamType.ORIGIN_LATITUDE, ProjectionParamType.FALSE_EASTING, ProjectionParamType.FALSE_NORTHING};
    private static final Set<Code> CODE_SET;

    @Override
    public Projection createProjection(ProjectionParams projectionParams) {
        return new EquidistantCylindrical(new CodeSet(this.getSupportedCodes()), projectionParams);
    }

    @Override
    public ProjectionParamType[] getParamInfo() {
        return PARAM_INFO;
    }

    @Override
    public Set<Code> getSupportedCodes() {
        return CODE_SET;
    }

    static {
        HashSet<Code> result = new HashSet<Code>();
        result.add(new Code("mapinfo", "projection33"));
        CODE_SET = Collections.unmodifiableSet(result);
    }

    private static class EquidistantCylindrical
    extends Projection
    implements Serializable {
        double m_phi;
        double m_phi0;
        double m_cosphi;

        public EquidistantCylindrical(CodeSet codeSet, ProjectionParams projectionParams) {
            super("Equidistant Cylindrical", codeSet, projectionParams);
            this.calcInternals();
        }

        private void calcInternals() {
            ProjectionParams projectionParams = this.getProjectionParams();
            this.m_phi0 = CoordSysUtilities.convertClip(projectionParams.getOriginLatitude(), AngularUnit.RADIAN, -90.0, 90.0);
            this.m_phi = CoordSysUtilities.convertClip(projectionParams.getStandardParallel1(), AngularUnit.RADIAN, -80.0, 80.0);
            this.m_cosphi = Math.cos(this.m_phi);
        }

        @Override
        public DirectPosition fromLongLat(DirectPosition source, DirectPosition destination) {
            ProjectionParams projectionParams = this.getProjectionParams();
            double x = source.getX();
            double y = source.getY();
            x = CoordSysUtilities.convertClip(x, AngularUnit.DEGREE, AngularUnit.RADIAN, -180.0, 180.0);
            y = CoordSysUtilities.convertClip(y, AngularUnit.DEGREE, AngularUnit.RADIAN, -90.0, 90.0);
            x = projectionParams.getEllipsoid().getSemiMajorAxis() * x * this.m_cosphi;
            y = (y - this.m_phi0) * projectionParams.getEllipsoid().getSemiMajorAxis();
            x = LinearUnit.convert((double)x, (LinearUnit)projectionParams.getEllipsoid().getAxisUnit(), (LinearUnit)projectionParams.getLinearUnit());
            y = LinearUnit.convert((double)y, (LinearUnit)projectionParams.getEllipsoid().getAxisUnit(), (LinearUnit)projectionParams.getLinearUnit());
            destination.setXY(x += projectionParams.getFalseEasting().getValue(), y += projectionParams.getFalseNorthing().getValue());
            return destination;
        }

        @Override
        public DirectPosition toLongLat(DirectPosition source, DirectPosition destination) {
            ProjectionParams projectionParams = this.getProjectionParams();
            double x = source.getX() - projectionParams.getFalseEasting().getValue();
            double y = source.getY() - projectionParams.getFalseNorthing().getValue();
            x = LinearUnit.convert((double)x, (LinearUnit)projectionParams.getLinearUnit(), (LinearUnit)projectionParams.getEllipsoid().getAxisUnit());
            y = LinearUnit.convert((double)y, (LinearUnit)projectionParams.getLinearUnit(), (LinearUnit)projectionParams.getEllipsoid().getAxisUnit());
            y = MathUtil.clip((double)y, (double)-1.0E9, (double)1.0E9);
            y = y / projectionParams.getEllipsoid().getSemiMajorAxis() + this.m_phi0;
            destination.setXY(CoordSysUtilities.convertClip(x /= projectionParams.getEllipsoid().getSemiMajorAxis() * this.m_cosphi, AngularUnit.RADIAN, AngularUnit.DEGREE, -360.0, 360.0), CoordSysUtilities.convertClip(y, AngularUnit.RADIAN, AngularUnit.DEGREE, -90.0, 90.0));
            return destination;
        }
    }
}

