/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.midev.coordsys.projection;

import com.mapinfo.midev.coordsys.CodeSet;
import com.mapinfo.midev.coordsys.projection.IProjectionFactory;
import com.mapinfo.midev.coordsys.projection.Projection;
import com.mapinfo.midev.coordsys.projection.ProjectionParamType;
import com.mapinfo.midev.coordsys.projection.ProjectionParams;
import com.mapinfo.midev.coordsys.util.CoordSysUtilities;
import com.mapinfo.midev.geometry.DirectPosition;
import com.mapinfo.midev.unit.AngularUnit;
import com.mapinfo.midev.unit.LinearUnit;
import com.mapinfo.midev.util.Code;
import com.mapinfo.midev.util.MathUtil;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class HotineObliqueMercatorFactory
implements IProjectionFactory {
    private static final ProjectionParamType[] PARAM_INFO = new ProjectionParamType[]{ProjectionParamType.ORIGIN_LONGITUDE, ProjectionParamType.ORIGIN_LATITUDE, ProjectionParamType.AZIMUTH, ProjectionParamType.SCALE_FACTOR, ProjectionParamType.FALSE_EASTING, ProjectionParamType.FALSE_NORTHING};
    private static final Set<Code> CODE_SET;

    @Override
    public ProjectionParamType[] getParamInfo() {
        return PARAM_INFO;
    }

    @Override
    public Set<Code> getSupportedCodes() {
        return CODE_SET;
    }

    @Override
    public Projection createProjection(ProjectionParams projectionParams) {
        return new HotineObliqueMercator(new CodeSet(this.getSupportedCodes()), projectionParams);
    }

    static {
        HashSet<Code> result = new HashSet<Code>();
        result.add(new Code("epsg", "9812"));
        result.add(new Code("mapinfo", "projection7"));
        CODE_SET = Collections.unmodifiableSet(result);
    }

    private static class HotineObliqueMercator
    extends Projection
    implements Serializable {
        private double m_e;
        private double m_lambda0;
        private double m_A;
        private double m_B;
        private double m_E;
        private double m_sinalphac;
        private double m_cosalphac;
        private double m_gamma0;
        private double m_singamma0;
        private double m_cosgamma0;
        private double m_Aprime;
        private double m_Bprime;
        private double m_Cprime;
        private double m_Dprime;

        public HotineObliqueMercator(CodeSet codeSet, ProjectionParams projectionParams) {
            super("Hotine Oblique Mercator", codeSet, projectionParams);
            this.calcInternals();
        }

        private void calcInternals() {
            double d;
            ProjectionParams projectionParams = this.getProjectionParams();
            double lambdac = CoordSysUtilities.convertClip(projectionParams.getOriginLongitude(), AngularUnit.RADIAN, -360.0, 360.0);
            double phi0 = CoordSysUtilities.convertClip(projectionParams.getOriginLatitude(), AngularUnit.RADIAN, -90.0, 90.0);
            double alphac = CoordSysUtilities.convertClip(projectionParams.getAzimuth(), AngularUnit.RADIAN, -360.0, 360.0);
            this.m_sinalphac = Math.sin(alphac);
            this.m_cosalphac = Math.cos(alphac);
            this.m_e = projectionParams.getEllipsoid().getEccentricity();
            double k0 = projectionParams.getScaleFactor();
            if (k0 == 0.0) {
                k0 = 1.0;
            }
            double cosphi0 = Math.cos(phi0);
            double cosphi2 = cosphi0 * cosphi0;
            double sinphi0 = Math.sin(phi0);
            double esinphi0 = this.m_e * sinphi0;
            double esinphi2 = esinphi0 * esinphi0;
            this.m_B = Math.sqrt(1.0 + projectionParams.getEllipsoid().getEccentricitySquared() * cosphi2 * cosphi2 / (1.0 - projectionParams.getEllipsoid().getEccentricitySquared()));
            this.m_A = projectionParams.getEllipsoid().getSemiMajorAxis() * this.m_B * k0 * Math.sqrt(1.0 - projectionParams.getEllipsoid().getEccentricitySquared()) / (1.0 - esinphi2);
            double temp = 1.0 + sinphi0;
            double t0 = temp != 0.0 ? Math.sqrt((1.0 - sinphi0) / temp * Math.pow((1.0 + esinphi0) / (1.0 - esinphi0), this.m_e)) : 1.0E9;
            temp = cosphi0 * Math.sqrt(1.0 - esinphi2);
            double D = temp != 0.0 ? this.m_B * Math.sqrt(1.0 - projectionParams.getEllipsoid().getEccentricitySquared()) / temp : 1.0E9;
            double D2 = D * D;
            if (d < 1.0) {
                D2 = 1.0;
            }
            double F = phi0 > 0.0 ? D + Math.sqrt(D2 - 1.0) : D - Math.sqrt(D2 - 1.0);
            this.m_E = F * Math.pow(t0, this.m_B);
            double G = F != 0.0 ? (F - 1.0 / F) / 2.0 : -1.0E9;
            temp = this.m_sinalphac / D;
            this.m_singamma0 = MathUtil.clip((double)temp, (double)-1.0, (double)1.0);
            this.m_gamma0 = Math.asin(this.m_singamma0);
            this.m_cosgamma0 = Math.cos(this.m_gamma0);
            temp = G * Math.tan(this.m_gamma0);
            this.m_lambda0 = lambdac - Math.asin(MathUtil.clip((double)temp, (double)-1.0, (double)1.0)) / this.m_B;
            double e4 = projectionParams.getEllipsoid().getEccentricitySquared() * projectionParams.getEllipsoid().getEccentricitySquared();
            double e6 = projectionParams.getEllipsoid().getEccentricitySquared() * e4;
            double e8 = e4 * e4;
            double A = projectionParams.getEllipsoid().getEccentricitySquared() / 2.0 + 5.0 * e4 / 24.0 + e6 / 12.0 + 13.0 * e8 / 360.0;
            double B = 7.0 * e4 / 48.0 + 29.0 * e6 / 240.0 + 811.0 * e8 / 11520.0;
            double C = 7.0 * e6 / 120.0 + 81.0 * e8 / 1120.0;
            D = 4279.0 * e8 / 161280.0;
            this.m_Aprime = A - C;
            this.m_Bprime = 2.0 * B - 4.0 * D;
            this.m_Cprime = 4.0 * C;
            this.m_Dprime = 8.0 * D;
        }

        @Override
        public DirectPosition fromLongLat(DirectPosition source, DirectPosition destination) {
            double v;
            double u;
            double y;
            ProjectionParams projectionParams = this.getProjectionParams();
            double x = CoordSysUtilities.convertClip(source.getX(), AngularUnit.DEGREE, AngularUnit.RADIAN, -360.0, 360.0);
            double phi = y = CoordSysUtilities.convertClip(source.getY(), AngularUnit.DEGREE, AngularUnit.RADIAN, -90.0, 90.0);
            double sinphi = Math.sin(phi);
            double esinphi = this.m_e * sinphi;
            if (sinphi == 1.0) {
                double d;
                u = this.m_A * phi / this.m_B;
                double temp = Math.tan(0.7853981633974483 - this.m_gamma0 / 2.0);
                v = d > 0.0 ? this.m_A / this.m_B * Math.log(temp) : -1.0E9;
            } else if (sinphi == -1.0) {
                double d;
                u = this.m_A * phi / this.m_B;
                double temp = Math.tan(0.7853981633974483 + this.m_gamma0 / 2.0);
                v = d > 0.0 ? this.m_A / this.m_B * Math.log(temp) : -1.0E9;
            } else {
                double T;
                double S;
                double temp;
                double t = Math.sqrt((1.0 - sinphi) / (1.0 + sinphi) * Math.pow((1.0 + esinphi) / (1.0 - esinphi), this.m_e));
                double Q = this.m_E / Math.pow(t, this.m_B);
                if (Q != 0.0) {
                    temp = 1.0 / Q;
                    S = (Q - temp) / 2.0;
                    T = (Q + temp) / 2.0;
                } else {
                    S = -1.0E9;
                    T = 1.0E9;
                }
                double Bxdiff = this.m_B * (x - this.m_lambda0);
                double V = Math.sin(Bxdiff);
                double U = (-V * this.m_cosgamma0 + S * this.m_singamma0) / T;
                v = U == 1.0 ? -1.0E9 : (U == -1.0 ? 1.0E9 : this.m_A * Math.log((1.0 - U) / (1.0 + U)) / (2.0 * this.m_B));
                temp = Math.cos(Bxdiff);
                u = temp != 0.0 ? this.m_A * Math.atan2(S * this.m_cosgamma0 + V * this.m_singamma0, temp) / this.m_B : this.m_A * Bxdiff;
            }
            x = v * this.m_cosalphac + u * this.m_sinalphac;
            y = u * this.m_cosalphac - v * this.m_sinalphac;
            destination.setXY(LinearUnit.convert((double)x, (LinearUnit)projectionParams.getEllipsoid().getAxisUnit(), (LinearUnit)projectionParams.getLinearUnit()) + projectionParams.getFalseEasting().getValue(projectionParams.getLinearUnit()), LinearUnit.convert((double)y, (LinearUnit)projectionParams.getEllipsoid().getAxisUnit(), (LinearUnit)projectionParams.getLinearUnit()) + projectionParams.getFalseNorthing().getValue(projectionParams.getLinearUnit()));
            return destination;
        }

        @Override
        public DirectPosition toLongLat(DirectPosition source, DirectPosition destination) {
            ProjectionParams projectionParams = this.getProjectionParams();
            double B_over_A = this.m_B / this.m_A;
            double x = LinearUnit.convert((double)(source.getX() - projectionParams.getFalseEasting().getValue(projectionParams.getLinearUnit())), (LinearUnit)projectionParams.getLinearUnit(), (LinearUnit)projectionParams.getEllipsoid().getAxisUnit());
            double y = LinearUnit.convert((double)(source.getY() - projectionParams.getFalseNorthing().getValue(projectionParams.getLinearUnit())), (LinearUnit)projectionParams.getLinearUnit(), (LinearUnit)projectionParams.getEllipsoid().getAxisUnit());
            x = MathUtil.clip((double)x, (double)-1.0E9, (double)1.0E9);
            y = MathUtil.clip((double)y, (double)-1.0E9, (double)1.0E9);
            double v = x * this.m_cosalphac - y * this.m_sinalphac;
            double u = y * this.m_cosalphac + x * this.m_sinalphac;
            double temp = -B_over_A * v;
            double Qprime = temp < -100.0 ? 1.0E-9 : (temp > 100.0 ? 1.0E9 : Math.exp(temp));
            temp = 1.0 / Qprime;
            double Sprime = (Qprime - temp) / 2.0;
            double Tprime = (Qprime + temp) / 2.0;
            double Vprime = Math.sin(B_over_A * u);
            double Uprime = (Vprime * this.m_cosgamma0 + Sprime * this.m_singamma0) / Tprime;
            if (Math.abs(Uprime) >= 1.0) {
                x = this.m_lambda0;
                y = Uprime > 0.0 ? 1.5707963267948966 : -1.5707963267948966;
            } else {
                double t = Math.pow(this.m_E / Math.sqrt((1.0 + Uprime) / (1.0 - Uprime)), 1.0 / this.m_B);
                double temp1 = Sprime * this.m_cosgamma0 - Vprime * this.m_singamma0;
                double temp2 = Math.cos(B_over_A * u);
                x = temp1 == 0.0 && temp2 == 0.0 ? this.m_lambda0 : this.m_lambda0 - Math.atan2(temp1, temp2) / this.m_B;
                double chi = 1.5707963267948966 - 2.0 * Math.atan(t);
                double chi2 = 2.0 * chi;
                double coschi2 = Math.cos(chi2);
                y = chi + Math.sin(chi2) * (this.m_Aprime + coschi2 * (this.m_Bprime + coschi2 * (this.m_Cprime + coschi2 * this.m_Dprime)));
            }
            destination.setXY(CoordSysUtilities.convertClip(x, AngularUnit.RADIAN, AngularUnit.DEGREE, -360.0, 360.0), CoordSysUtilities.convertClip(y, AngularUnit.RADIAN, AngularUnit.DEGREE, -90.0, 90.0));
            return destination;
        }
    }
}

