/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.midev.coordsys.projection;

import com.mapinfo.midev.coordsys.CodeSet;
import com.mapinfo.midev.coordsys.projection.IProjectionFactory;
import com.mapinfo.midev.coordsys.projection.Projection;
import com.mapinfo.midev.coordsys.projection.ProjectionParamType;
import com.mapinfo.midev.coordsys.projection.ProjectionParams;
import com.mapinfo.midev.coordsys.util.CoordSysUtilities;
import com.mapinfo.midev.geometry.DirectPosition;
import com.mapinfo.midev.unit.AngularUnit;
import com.mapinfo.midev.unit.LinearUnit;
import com.mapinfo.midev.util.Code;
import com.mapinfo.midev.util.MathUtil;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class KrovakFactory
implements IProjectionFactory {
    private static final ProjectionParamType[] PARAM_INFO = new ProjectionParamType[]{ProjectionParamType.ORIGIN_LONGITUDE, ProjectionParamType.ORIGIN_LATITUDE, ProjectionParamType.STANDARD_PARALLEL_1, ProjectionParamType.AZIMUTH, ProjectionParamType.FALSE_EASTING, ProjectionParamType.FALSE_NORTHING};
    private static final Set<Code> CODE_SET;

    @Override
    public Set<Code> getSupportedCodes() {
        return CODE_SET;
    }

    @Override
    public ProjectionParamType[] getParamInfo() {
        return PARAM_INFO;
    }

    @Override
    public Projection createProjection(ProjectionParams projectionParams) {
        return new Krovak(new CodeSet(this.getSupportedCodes()), projectionParams);
    }

    static {
        HashSet<Code> result = new HashSet<Code>();
        result.add(new Code("mapinfo", "projection32"));
        CODE_SET = Collections.unmodifiableSet(result);
    }

    private static class Krovak
    extends Projection
    implements Serializable {
        private static final double DBLS_EPSILON = 1.0E-12;
        private static final int DBLS_MAX_ITERATION = 30;
        private double m_phi1;
        private double m_n;
        private double m_A;
        private double m_B;
        private double m_t0;
        private double m_r0;
        private double m_lambdac;
        private double m_alphac;

        public Krovak(CodeSet codeSet, ProjectionParams projectionParams) {
            super("Krovak", codeSet, projectionParams);
            this.calcInternals();
        }

        private void calcInternals() {
            ProjectionParams projectionParams = this.getProjectionParams();
            this.m_phi1 = CoordSysUtilities.convertClip(projectionParams.getStandardParallel1(), AngularUnit.RADIAN, -90.0, 90.0);
            this.m_n = Math.sin(this.m_phi1);
            double LLOriginX = MathUtil.clip((double)(projectionParams.getOriginLongitude().getValue(AngularUnit.DEGREE) + AngularUnit.convert((double)projectionParams.getPrimeMeridian().getLongitude(), (AngularUnit)projectionParams.getPrimeMeridian().getAngularUnit(), (AngularUnit)AngularUnit.DEGREE)), (double)-360.0, (double)360.0);
            double phic = CoordSysUtilities.convertClip(projectionParams.getOriginLatitude(), AngularUnit.RADIAN, -90.0, 90.0);
            double sinphic = Math.sin(phic);
            double cosphic = Math.cos(phic);
            this.m_B = Math.sqrt(1.0 + projectionParams.getEllipsoid().getEccentricitySquared() * cosphic * cosphic * cosphic * cosphic / (1.0 - projectionParams.getEllipsoid().getEccentricitySquared()));
            double gamma0 = Math.asin(MathUtil.clip((double)(sinphic / this.m_B), (double)-1.0, (double)1.0));
            double temp1 = Math.tan(0.7853981633974483 + gamma0 / 2.0);
            double temp2 = Math.pow((1.0 + projectionParams.getEllipsoid().getEccentricity() * sinphic) / (1.0 - projectionParams.getEllipsoid().getEccentricity() * sinphic), this.m_B * projectionParams.getEllipsoid().getEccentricity() / 2.0);
            double temp3 = Math.pow(Math.tan(0.7853981633974483 + phic / 2.0), this.m_B);
            this.m_t0 = temp1 * temp2 / temp3;
            double temp4 = 1.0 - projectionParams.getEllipsoid().getEccentricitySquared() * sinphic * sinphic;
            this.m_A = projectionParams.getEllipsoid().getSemiMajorAxis() * Math.sqrt(1.0 - projectionParams.getEllipsoid().getEccentricitySquared()) / temp4;
            this.m_r0 = 0.9999 * this.m_A / Math.tan(this.m_phi1);
            this.m_lambdac = Math.toRadians(LLOriginX);
            this.m_alphac = projectionParams.getAzimuth().getValue(AngularUnit.RADIAN);
        }

        public double getScaleFactor(double x, double y) {
            double sinalphac = Math.sin(this.m_alphac);
            double cosalphac = Math.cos(this.m_alphac);
            x = Math.toRadians(x + AngularUnit.convert((double)this.getProjectionParams().getPrimeMeridian().getLongitude(), (AngularUnit)this.getProjectionParams().getPrimeMeridian().getAngularUnit(), (AngularUnit)AngularUnit.DEGREE));
            y = Math.toRadians(y);
            x = this.KrovakEllipsToSphereX(x);
            if ((y = this.KrovakEllipsToSphereY(y)) > 1.5707963267948966 - this.m_alphac) {
                y = 1.5707963267948966 - this.m_alphac;
            }
            double sinU = Math.sin(y);
            double cosU = Math.cos(y);
            double cosV = Math.cos(x);
            double S = Math.asin(MathUtil.clip((double)(cosalphac * sinU + sinalphac * cosU * cosV), (double)-1.0, (double)1.0));
            double temp1 = Math.tan(0.7853981633974483 + this.m_phi1 / 2.0);
            double temp2 = Math.tan(0.7853981633974483 + S / 2.0);
            double temp3 = Math.pow(temp1 / temp2, this.m_n);
            double r = this.m_r0 * temp3;
            double k = Math.cos(S) == 0.0 ? 1.0 : this.m_n * r / (this.m_A * Math.cos(S));
            return k;
        }

        @Override
        public DirectPosition fromLongLat(DirectPosition source, DirectPosition destination) {
            ProjectionParams projectionParams = this.getProjectionParams();
            double sinalphac = Math.sin(this.m_alphac);
            double cosalphac = Math.cos(this.m_alphac);
            double x = CoordSysUtilities.convertClip(source.getX() + AngularUnit.convert((double)projectionParams.getPrimeMeridian().getLongitude(), (AngularUnit)projectionParams.getPrimeMeridian().getAngularUnit(), (AngularUnit)AngularUnit.DEGREE), AngularUnit.DEGREE, AngularUnit.RADIAN, -360.0, 360.0);
            double y = CoordSysUtilities.convertClip(source.getY(), AngularUnit.DEGREE, AngularUnit.RADIAN, -90.0, 90.0);
            x = this.KrovakEllipsToSphereX(x);
            if ((y = this.KrovakEllipsToSphereY(y)) > 1.5707963267948966 - this.m_alphac) {
                y = 1.5707963267948966 - this.m_alphac;
            }
            double sinU = Math.sin(y);
            double cosU = Math.cos(y);
            double sinV = Math.sin(x);
            double cosV = Math.cos(x);
            double S = Math.asin(MathUtil.clip((double)(cosalphac * sinU + sinalphac * cosU * cosV), (double)-1.0, (double)1.0));
            double D = Math.asin(MathUtil.clip((double)(cosU * sinV / Math.cos(S)), (double)-1.0, (double)1.0));
            double theta = this.m_n * D;
            double temp1 = Math.tan(0.7853981633974483 + this.m_phi1 / 2.0);
            double temp2 = Math.tan(0.7853981633974483 + S / 2.0);
            double temp3 = Math.pow(temp1 / temp2, this.m_n);
            double r = this.m_r0 * temp3;
            y = -1.0 * r * Math.cos(theta);
            x = -1.0 * r * Math.sin(theta);
            x = LinearUnit.convert((double)x, (LinearUnit)projectionParams.getEllipsoid().getAxisUnit(), (LinearUnit)projectionParams.getLinearUnit());
            y = LinearUnit.convert((double)y, (LinearUnit)projectionParams.getEllipsoid().getAxisUnit(), (LinearUnit)projectionParams.getLinearUnit());
            destination.setXY(x += projectionParams.getFalseEasting().getValue(projectionParams.getLinearUnit()), y += projectionParams.getFalseNorthing().getValue(projectionParams.getLinearUnit()));
            return destination;
        }

        @Override
        public DirectPosition toLongLat(DirectPosition source, DirectPosition destination) {
            ProjectionParams projectionParams = this.getProjectionParams();
            double sinalphac = Math.sin(this.m_alphac);
            double cosalphac = Math.cos(this.m_alphac);
            double x = LinearUnit.convert((double)source.getX(), (LinearUnit)projectionParams.getLinearUnit(), (LinearUnit)projectionParams.getEllipsoid().getAxisUnit());
            double y = LinearUnit.convert((double)source.getY(), (LinearUnit)projectionParams.getLinearUnit(), (LinearUnit)projectionParams.getEllipsoid().getAxisUnit());
            x -= projectionParams.getFalseEasting().getValue(projectionParams.getEllipsoid().getAxisUnit());
            y -= projectionParams.getFalseNorthing().getValue(projectionParams.getEllipsoid().getAxisUnit());
            x = -x;
            y = -y;
            double rprime = Math.sqrt(x * x + y * y);
            double theta = Math.atan2(x, y);
            double Dprime = theta / this.m_n;
            double temp = Math.pow(this.m_r0 / rprime, 1.0 / this.m_n) * Math.tan(0.7853981633974483 + this.m_phi1 / 2.0);
            double Sprime = 2.0 * (Math.atan(temp) - 0.7853981633974483);
            double Uprime = Math.asin(MathUtil.clip((double)(cosalphac * Math.sin(Sprime) - sinalphac * Math.cos(Sprime) * Math.cos(Dprime)), (double)-1.0, (double)1.0));
            double Vprime = Math.asin(MathUtil.clip((double)(Math.cos(Sprime) * Math.sin(Dprime) / Math.cos(Uprime)), (double)-1.0, (double)1.0));
            y = Uprime;
            x = Vprime;
            x = this.KrovakSphereToEllipseX(x);
            y = this.KrovakSphereToEllipseY(y);
            destination.setXY(CoordSysUtilities.convertClip(x, AngularUnit.RADIAN, AngularUnit.DEGREE, -360.0, 360.0) - AngularUnit.convert((double)projectionParams.getPrimeMeridian().getLongitude(), (AngularUnit)projectionParams.getPrimeMeridian().getAngularUnit(), (AngularUnit)AngularUnit.DEGREE), CoordSysUtilities.convertClip(y, AngularUnit.RADIAN, AngularUnit.DEGREE, -90.0, 90.0));
            return destination;
        }

        private double KrovakEllipsToSphereX(double x) {
            return this.m_B * (this.m_lambdac - x);
        }

        private double KrovakEllipsToSphereY(double y) {
            double esinphi = this.getProjectionParams().getEllipsoid().getEccentricity() * Math.sin(y);
            double temp1 = Math.tan(y / 2.0 + 0.7853981633974483);
            double temp2 = Math.pow((1.0 - esinphi) / (1.0 + esinphi), this.getProjectionParams().getEllipsoid().getEccentricity() / 2.0);
            double temp3 = this.m_t0 * Math.pow(temp1 * temp2, this.m_B);
            return 2.0 * Math.atan(temp3) - 1.5707963267948966;
        }

        private double KrovakSphereToEllipseX(double x) {
            return this.m_lambdac - x / this.m_B;
        }

        private double KrovakSphereToEllipseY(double y) {
            double itval = y;
            double itprev = y;
            double diff = 1.0;
            for (int counter = 1; diff > 1.0E-12 && counter <= 30; ++counter) {
                itval = this.KrovakNextIteration(itprev, y);
                diff = Math.abs(itval - itprev);
                itprev = itval;
            }
            return itval;
        }

        private double KrovakNextIteration(double phicur, double phi) {
            double sinphicur = Math.sin(phicur);
            double temp1 = Math.pow(Math.tan(phi / 2.0 + 0.7853981633974483), 1.0 / this.m_B);
            double temp2 = Math.pow(this.m_t0, 1.0 / this.m_B);
            double temp3 = Math.pow((1.0 + this.getProjectionParams().getEllipsoid().getEccentricity() * sinphicur) / (1.0 - this.getProjectionParams().getEllipsoid().getEccentricity() * sinphicur), this.getProjectionParams().getEllipsoid().getEccentricity() / 2.0);
            return 2.0 * Math.atan(temp1 * temp3 / temp2) - 1.5707963267948966;
        }
    }
}

