/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.midev.coordsys.projection;

import com.mapinfo.midev.coordsys.CodeSet;
import com.mapinfo.midev.coordsys.Ellipsoid;
import com.mapinfo.midev.coordsys.projection.IProjectionFactory;
import com.mapinfo.midev.coordsys.projection.Projection;
import com.mapinfo.midev.coordsys.projection.ProjectionParamType;
import com.mapinfo.midev.coordsys.projection.ProjectionParams;
import com.mapinfo.midev.coordsys.util.CoordSysUtilities;
import com.mapinfo.midev.geometry.DirectPosition;
import com.mapinfo.midev.unit.AngularUnit;
import com.mapinfo.midev.unit.LinearUnit;
import com.mapinfo.midev.util.Code;
import com.mapinfo.midev.util.MathUtil;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class LambertAzimuthalEqualAreaFactory
implements IProjectionFactory {
    private static final ProjectionParamType[] PARAM_INFO = new ProjectionParamType[]{ProjectionParamType.ORIGIN_LONGITUDE, ProjectionParamType.ORIGIN_LATITUDE, ProjectionParamType.RANGE};
    private static final Set<Code> CODE_SET;

    @Override
    public ProjectionParamType[] getParamInfo() {
        return PARAM_INFO;
    }

    @Override
    public Set<Code> getSupportedCodes() {
        return CODE_SET;
    }

    @Override
    public Projection createProjection(ProjectionParams projectionParams) {
        double originLatitude = projectionParams.getOriginLatitude().getValue(AngularUnit.DEGREE);
        CodeSet codeSet = originLatitude == 90.0 || originLatitude == -90.0 ? new CodeSet(new Code("mapinfo", "projection4"), new Code("epsg", "9820")) : new CodeSet(new Code("mapinfo", "projection29"), new Code("epsg", "9820"));
        return new LambertAzimuthalEqualArea(codeSet, projectionParams);
    }

    static {
        HashSet<Code> result = new HashSet<Code>();
        result.add(new Code("epsg", "9820"));
        result.add(new Code("mapinfo", "projection4"));
        result.add(new Code("mapinfo", "projection29"));
        CODE_SET = Collections.unmodifiableSet(result);
    }

    private static class LambertAzimuthalEqualArea
    extends Projection
    implements Serializable {
        private double m_phi1;
        private double m_sinphi1;
        private double m_cosphi1;
        private boolean m_bZeroE;
        private double m_R2;
        private double m_lambda0;
        private double m_radius;
        private double m_MinY;
        private double m_MaxY;
        private int m_polar;
        private double m_qp;
        private double m_beta1;
        private double m_Rq;
        private double m_D;
        private double m_Aprime;
        private double m_Bprime;
        private double m_Cprime;

        public LambertAzimuthalEqualArea(CodeSet codeSet, ProjectionParams projectionParams) {
            super("Lambert Azimuthal Equal-Area", codeSet, projectionParams);
            this.calcInternals();
        }

        private void calcInternals() {
            ProjectionParams projectionParams = this.getProjectionParams();
            this.m_lambda0 = CoordSysUtilities.convertClip(projectionParams.getOriginLongitude(), AngularUnit.RADIAN, -360.0, 360.0);
            this.m_phi1 = MathUtil.clip((double)projectionParams.getOriginLatitude().getValue(AngularUnit.DEGREE), (double)-90.0, (double)90.0);
            this.m_polar = this.m_phi1 == 90.0 ? 1 : (this.m_phi1 == -90.0 ? -1 : 0);
            this.m_phi1 = Math.toRadians(this.m_phi1);
            this.m_sinphi1 = Math.sin(this.m_phi1);
            this.m_cosphi1 = Math.cos(this.m_phi1);
            this.m_R2 = projectionParams.getEllipsoid().getSemiMajorAxis() * 2.0;
            this.m_bZeroE = projectionParams.getEllipsoid().getEccentricitySquared() == 0.0;
            double m1 = LambertAzimuthalEqualArea.MfromPhi(this.m_phi1, projectionParams.getEllipsoid());
            double q1 = LambertAzimuthalEqualArea.QfromPhi(this.m_phi1, projectionParams.getEllipsoid());
            this.m_qp = LambertAzimuthalEqualArea.QfromPhi(1.5707963267948966, projectionParams.getEllipsoid());
            this.m_beta1 = Math.asin(MathUtil.clip((double)(q1 / this.m_qp), (double)-1.0, (double)1.0));
            this.m_Rq = projectionParams.getEllipsoid().getSemiMajorAxis() * Math.sqrt(this.m_qp / 2.0);
            this.m_D = this.m_bZeroE ? 1.0 : projectionParams.getEllipsoid().getSemiMajorAxis() * m1 / (this.m_Rq * Math.cos(this.m_beta1));
            double range = CoordSysUtilities.convertClip(projectionParams.getRange(), AngularUnit.RADIAN, 1.0, 180.0);
            this.m_radius = this.m_R2 * Math.sin(range / 2.0);
            this.m_MinY = MathUtil.clip((double)(this.m_phi1 - range), (double)-1.5707963267948966, (double)1.5707963267948966);
            this.m_MaxY = MathUtil.clip((double)(this.m_phi1 + range), (double)-1.5707963267948966, (double)1.5707963267948966);
            double e4 = projectionParams.getEllipsoid().getEccentricitySquared() * projectionParams.getEllipsoid().getEccentricitySquared();
            double e6 = projectionParams.getEllipsoid().getEccentricitySquared() * e4;
            double A = projectionParams.getEllipsoid().getEccentricitySquared() / 3.0 + 31.0 * e4 / 180.0 + 517.0 * e6 / 5040.0;
            double B = 23.0 * e4 / 360.0 + 251.0 * e6 / 3780.0;
            double C = 761.0 * e6 / 45360.0;
            this.m_Aprime = A - C;
            this.m_Bprime = 2.0 * B;
            this.m_Cprime = 4.0 * C;
        }

        @Override
        public DirectPosition fromLongLat(DirectPosition source, DirectPosition destination) {
            double temp;
            ProjectionParams projectionParams = this.getProjectionParams();
            double x = CoordSysUtilities.convertClip(source.getX(), AngularUnit.DEGREE, AngularUnit.RADIAN, -360.0, 360.0);
            double y = CoordSysUtilities.convertClip(source.getY(), AngularUnit.DEGREE, AngularUnit.RADIAN, -90.0, 90.0);
            double lambdadiff = x - this.m_lambda0;
            double q = LambertAzimuthalEqualArea.QfromPhi(y, projectionParams.getEllipsoid());
            if (1 == this.m_polar) {
                temp = this.m_qp - q;
                if (temp < 0.0) {
                    temp = 0.0;
                }
                temp = projectionParams.getEllipsoid().getSemiMajorAxis() * Math.sqrt(temp);
                x = temp * Math.sin(lambdadiff);
                y = -temp * Math.cos(lambdadiff);
            } else if (-1 == this.m_polar) {
                temp = q + this.m_qp;
                if (temp < 0.0) {
                    temp = 0.0;
                }
                temp = projectionParams.getEllipsoid().getSemiMajorAxis() * Math.sqrt(temp);
                x = temp * Math.sin(lambdadiff);
                y = temp * Math.cos(lambdadiff);
            } else {
                double beta = Math.asin(MathUtil.clip((double)(q / this.m_qp), (double)-1.0, (double)1.0));
                double sinbeta = Math.sin(beta);
                double cosbeta = Math.cos(beta);
                double coslambdadiff = Math.cos(lambdadiff);
                double B = this.m_Rq * Math.sqrt(2.0 / (1.0 + Math.sin(this.m_beta1) * sinbeta + Math.cos(this.m_beta1) * cosbeta * coslambdadiff));
                x = B * this.m_D * cosbeta * Math.sin(lambdadiff);
                y = B / this.m_D * (Math.cos(this.m_beta1) * sinbeta - Math.sin(this.m_beta1) * cosbeta * coslambdadiff);
            }
            temp = Math.sqrt(x * x + y * y);
            if (temp > this.m_radius) {
                temp = this.m_radius / temp;
                x *= temp;
                y *= temp;
            }
            destination.setXY(LinearUnit.convert((double)x, (LinearUnit)projectionParams.getEllipsoid().getAxisUnit(), (LinearUnit)projectionParams.getLinearUnit()), LinearUnit.convert((double)y, (LinearUnit)projectionParams.getEllipsoid().getAxisUnit(), (LinearUnit)projectionParams.getLinearUnit()));
            return destination;
        }

        @Override
        public DirectPosition toLongLat(DirectPosition source, DirectPosition destination) {
            ProjectionParams projectionParams = this.getProjectionParams();
            double x = LinearUnit.convert((double)source.getX(), (LinearUnit)projectionParams.getLinearUnit(), (LinearUnit)projectionParams.getEllipsoid().getAxisUnit());
            double y = LinearUnit.convert((double)source.getY(), (LinearUnit)projectionParams.getLinearUnit(), (LinearUnit)projectionParams.getEllipsoid().getAxisUnit());
            if (this.m_bZeroE) {
                double rho = Math.sqrt(x * x + y * y);
                if (0.0 != rho) {
                    double temp = rho / this.m_R2;
                    double c = 2.0 * Math.asin(MathUtil.clip((double)temp, (double)-1.0, (double)1.0));
                    double cosc = Math.cos(c);
                    if (0 != this.m_polar) {
                        x = this.m_lambda0 + Math.atan2(x, (double)(-this.m_polar) * y);
                        y = Math.asin(MathUtil.clip((double)(cosc * this.m_sinphi1), (double)-1.0, (double)1.0));
                    } else {
                        double sinc = Math.sin(c);
                        x = this.m_lambda0 + Math.atan2(x * sinc, rho * this.m_cosphi1 * cosc - y * this.m_sinphi1 * sinc);
                        y = Math.asin(MathUtil.clip((double)(cosc * this.m_sinphi1 + y * sinc * this.m_cosphi1 / rho), (double)-1.0, (double)1.0));
                    }
                    y = MathUtil.clip((double)y, (double)this.m_MinY, (double)this.m_MaxY);
                } else {
                    x = this.m_lambda0;
                    y = this.m_phi1;
                }
            } else {
                double beta;
                double rho = Math.sqrt(x / this.m_D * (x / this.m_D) + this.m_D * y * (this.m_D * y));
                double ce = 2.0 * Math.asin(MathUtil.clip((double)(rho / (2.0 * this.m_Rq)), (double)-1.0, (double)1.0));
                if (0.0 != rho) {
                    if (1 == this.m_polar) {
                        rho = Math.sqrt(x * x + y * y);
                        double temp = 1.0 - (1.0 - projectionParams.getEllipsoid().getEccentricitySquared()) / (2.0 * projectionParams.getEllipsoid().getEccentricity()) * Math.log((1.0 - projectionParams.getEllipsoid().getEccentricity()) / (1.0 + projectionParams.getEllipsoid().getEccentricity()));
                        temp = 1.0 - rho * rho / (projectionParams.getEllipsoid().getSemiMajorAxis() * projectionParams.getEllipsoid().getSemiMajorAxis() * temp);
                        beta = Math.asin(MathUtil.clip((double)temp, (double)-1.0, (double)1.0));
                        x = this.m_lambda0 + Math.atan2(x, -y);
                    } else if (-1 == this.m_polar) {
                        rho = Math.sqrt(x * x + y * y);
                        double temp = 1.0 - (1.0 - projectionParams.getEllipsoid().getEccentricitySquared()) / (2.0 * projectionParams.getEllipsoid().getEccentricity()) * Math.log((1.0 - projectionParams.getEllipsoid().getEccentricity()) / (1.0 + projectionParams.getEllipsoid().getEccentricity()));
                        temp = 1.0 - rho * rho / (projectionParams.getEllipsoid().getSemiMajorAxis() * projectionParams.getEllipsoid().getSemiMajorAxis() * temp);
                        beta = -Math.asin(MathUtil.clip((double)temp, (double)-1.0, (double)1.0));
                        x = this.m_lambda0 + Math.atan2(x, y);
                    } else {
                        double temp = Math.cos(ce) * Math.sin(this.m_beta1) + this.m_D * y * Math.sin(ce) * Math.cos(this.m_beta1) / rho;
                        beta = Math.asin(MathUtil.clip((double)temp, (double)-1.0, (double)1.0));
                        temp = this.m_D * rho * Math.cos(this.m_beta1) * Math.cos(ce) - this.m_D * this.m_D * y * Math.sin(this.m_beta1) * Math.sin(ce);
                        x = this.m_lambda0 + Math.atan2(x * Math.sin(ce), temp);
                    }
                } else {
                    x = this.m_lambda0;
                    beta = this.m_beta1;
                }
                double beta2 = 2.0 * beta;
                double cosbeta2 = Math.cos(beta2);
                y = beta + Math.sin(beta2) * (this.m_Aprime + cosbeta2 * (this.m_Bprime + cosbeta2 * this.m_Cprime));
                y = MathUtil.clip((double)y, (double)this.m_MinY, (double)this.m_MaxY);
            }
            if (x > Math.PI) {
                x -= Math.PI * 2;
            }
            if (x < -Math.PI) {
                x += Math.PI * 2;
            }
            destination.setXY(CoordSysUtilities.convertClip(x, AngularUnit.RADIAN, AngularUnit.DEGREE, -360.0, 360.0), CoordSysUtilities.convertClip(y, AngularUnit.RADIAN, AngularUnit.DEGREE, -90.0, 90.0));
            return destination;
        }

        private static double QfromPhi(double phi, Ellipsoid ellipsoid) {
            double sinphi = Math.sin(phi);
            double sinphi2 = sinphi * sinphi;
            double e = ellipsoid.getEccentricity();
            if (0.0 == ellipsoid.getEccentricitySquared()) {
                return 2.0 * sinphi;
            }
            return (1.0 - ellipsoid.getEccentricitySquared()) * (sinphi / (1.0 - ellipsoid.getEccentricitySquared() * sinphi2) - 1.0 / (2.0 * e) * Math.log((1.0 - e * sinphi) / (1.0 + e * sinphi)));
        }

        private static double MfromPhi(double phi, Ellipsoid ellipsoid) {
            double sinphi2 = Math.sin(phi) * Math.sin(phi);
            return Math.cos(phi) / Math.sqrt(1.0 - ellipsoid.getEccentricitySquared() * sinphi2);
        }
    }
}

