/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.midev.coordsys.projection;

import com.mapinfo.midev.coordsys.CodeSet;
import com.mapinfo.midev.coordsys.projection.IProjectionFactory;
import com.mapinfo.midev.coordsys.projection.Projection;
import com.mapinfo.midev.coordsys.projection.ProjectionParamType;
import com.mapinfo.midev.coordsys.projection.ProjectionParams;
import com.mapinfo.midev.coordsys.util.CoordSysUtilities;
import com.mapinfo.midev.geometry.DirectPosition;
import com.mapinfo.midev.unit.AngularUnit;
import com.mapinfo.midev.unit.LinearUnit;
import com.mapinfo.midev.util.Code;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class LambertConformalConicFactory
implements IProjectionFactory {
    private static final ProjectionParamType[] PARAM_INFO = new ProjectionParamType[]{ProjectionParamType.ORIGIN_LONGITUDE, ProjectionParamType.ORIGIN_LATITUDE, ProjectionParamType.STANDARD_PARALLEL_1, ProjectionParamType.STANDARD_PARALLEL_2, ProjectionParamType.FALSE_EASTING, ProjectionParamType.FALSE_NORTHING};
    private static final Set<Code> CODE_SET;
    private final Modification m_modification;

    public LambertConformalConicFactory() {
        this(Modification.NONE);
    }

    protected LambertConformalConicFactory(Modification modification) {
        this.m_modification = modification;
    }

    @Override
    public ProjectionParamType[] getParamInfo() {
        return PARAM_INFO;
    }

    @Override
    public Set<Code> getSupportedCodes() {
        return CODE_SET;
    }

    @Override
    public Projection createProjection(ProjectionParams projectionParams) {
        return new LambertConformalConic(new CodeSet(this.getSupportedCodes()), projectionParams, this.m_modification);
    }

    static {
        HashSet<Code> result = new HashSet<Code>();
        result.add(new Code("epsg", "9802"));
        result.add(new Code("mapinfo", "projection3"));
        CODE_SET = Collections.unmodifiableSet(result);
    }

    protected static enum Modification {
        NONE,
        Belgium1972;

    }

    private static class LambertConformalConic
    extends Projection
    implements Serializable {
        private final Modification m_modification;
        private double m_e;
        private double m_lambda0;
        private double m_n;
        private double m_one_over_n;
        private double m_aF;
        private double m_rho0;
        private double m_Aprime;
        private double m_Bprime;
        private double m_Cprime;
        private double m_Dprime;
        private boolean m_bNegativeN;

        public LambertConformalConic(CodeSet codeSet, ProjectionParams projectionParams, Modification modification) {
            super(LambertConformalConic.getDisplayNameWithModification(modification), codeSet, projectionParams);
            this.m_modification = modification;
            this.calcInternals();
        }

        private static String getDisplayNameWithModification(Modification modification) {
            String result = "Lambert Conformal Conic";
            if (Modification.Belgium1972.equals((Object)modification)) {
                result = result + " modified for Belgium 1972";
            }
            return result;
        }

        private void calcInternals() {
            double temp2;
            ProjectionParams projectionParams = this.getProjectionParams();
            this.m_lambda0 = CoordSysUtilities.convertClip(projectionParams.getOriginLongitude(), AngularUnit.RADIAN, -360.0, 360.0);
            this.m_e = projectionParams.getEllipsoid().getEccentricity();
            double phi0 = CoordSysUtilities.convertClip(projectionParams.getOriginLatitude(), AngularUnit.RADIAN, -90.0, 90.0);
            double phi1 = CoordSysUtilities.convertClip(projectionParams.getStandardParallel1(), AngularUnit.RADIAN, -90.0, 90.0);
            double phi2 = CoordSysUtilities.convertClip(projectionParams.getStandardParallel2(), AngularUnit.RADIAN, -90.0, 90.0);
            double sinphi0 = Math.sin(phi0);
            double esinphi0 = this.m_e * sinphi0;
            double sinphi1 = Math.sin(phi1);
            double esinphi1 = this.m_e * sinphi1;
            double sinphi2 = Math.sin(phi2);
            double esinphi2 = this.m_e * sinphi2;
            double m1 = Math.cos(phi1) / Math.sqrt(1.0 - esinphi1 * esinphi1);
            double m2 = Math.cos(phi2) / Math.sqrt(1.0 - esinphi2 * esinphi2);
            double temp = 1.0 + sinphi0;
            double t0 = temp != 0.0 && (temp2 = 1.0 - esinphi0) != 0.0 ? Math.sqrt((1.0 - sinphi0) / temp * Math.pow((1.0 + esinphi0) / temp2, this.m_e)) : 1.0E9;
            temp = 1.0 + sinphi1;
            double t1 = temp != 0.0 && (temp2 = 1.0 - esinphi1) != 0.0 ? Math.sqrt((1.0 - sinphi1) / temp * Math.pow((1.0 + esinphi1) / temp2, this.m_e)) : 1.0E9;
            temp = 1.0 + sinphi2;
            double t2 = temp != 0.0 && (temp2 = 1.0 - esinphi2) != 0.0 ? Math.sqrt((1.0 - sinphi2) / temp * Math.pow((1.0 + esinphi2) / temp2, this.m_e)) : 1.0E9;
            this.m_n = m1 != 0.0 && m2 != 0.0 && t1 != 0.0 && t2 != 0.0 && (temp = Math.log(t1) - Math.log(t2)) != 0.0 ? (Math.log(m1) - Math.log(m2)) / temp : sinphi1;
            if (this.m_n == 0.0) {
                this.m_n = 1.0;
            }
            this.m_one_over_n = 1.0 / this.m_n;
            this.m_bNegativeN = this.m_n < 0.0;
            temp = this.m_bNegativeN && t1 == 0.0 ? this.m_n * 1.0E9 : this.m_n * Math.pow(t1, this.m_n);
            double F = temp != 0.0 ? m1 / temp : 1.0;
            this.m_aF = projectionParams.getEllipsoid().getSemiMajorAxis() * F;
            this.m_rho0 = this.m_bNegativeN && t0 == 0.0 ? this.m_aF * 1.0E9 : this.m_aF * Math.pow(t0, this.m_n);
            double e2 = projectionParams.getEllipsoid().getEccentricitySquared();
            double e4 = e2 * e2;
            double e6 = e2 * e4;
            double e8 = e4 * e4;
            double A = e2 / 2.0 + 5.0 * e4 / 24.0 + e6 / 12.0 + 13.0 * e8 / 360.0;
            double B = 7.0 * e4 / 48.0 + 29.0 * e6 / 240.0 + 811.0 * e8 / 11520.0;
            double C = 7.0 * e6 / 120.0 + 81.0 * e8 / 1120.0;
            double D = 4279.0 * e8 / 161280.0;
            this.m_Aprime = A - C;
            this.m_Bprime = 2.0 * B - 4.0 * D;
            this.m_Cprime = 4.0 * C;
            this.m_Dprime = 8.0 * D;
        }

        @Override
        public DirectPosition fromLongLat(DirectPosition source, DirectPosition destination) {
            double t;
            ProjectionParams projectionParams = this.getProjectionParams();
            double lambda = CoordSysUtilities.convertClip(source.getX(), AngularUnit.DEGREE, AngularUnit.RADIAN, -360.0, 360.0);
            double phi = CoordSysUtilities.convertClip(source.getY(), AngularUnit.DEGREE, AngularUnit.RADIAN, -90.0, 90.0);
            double sinphi = Math.sin(phi);
            double temp = 1.0 + sinphi;
            if (temp == 0.0) {
                t = 1.0E9;
            } else {
                double esinphi = this.m_e * sinphi;
                t = Math.sqrt((1.0 - sinphi) / temp * Math.pow((1.0 + esinphi) / (1.0 - esinphi), this.m_e));
            }
            double rho = this.m_bNegativeN && t == 0.0 ? this.m_aF * 1.0E9 : this.m_aF * Math.pow(t, this.m_n);
            double theta = this.m_n * (lambda - this.m_lambda0);
            if (this.m_modification.equals((Object)Modification.Belgium1972)) {
                theta -= AngularUnit.convert((double)29.2985, (AngularUnit)AngularUnit.SECOND, (AngularUnit)AngularUnit.RADIAN);
            }
            double x = rho * Math.sin(theta);
            double y = this.m_rho0 - rho * Math.cos(theta);
            x = LinearUnit.convert((double)x, (LinearUnit)projectionParams.getEllipsoid().getAxisUnit(), (LinearUnit)projectionParams.getLinearUnit());
            y = LinearUnit.convert((double)y, (LinearUnit)projectionParams.getEllipsoid().getAxisUnit(), (LinearUnit)projectionParams.getLinearUnit());
            destination.setXY(x + projectionParams.getFalseEasting().getValue(projectionParams.getLinearUnit()), y + projectionParams.getFalseNorthing().getValue(projectionParams.getLinearUnit()));
            return destination;
        }

        @Override
        public DirectPosition toLongLat(DirectPosition source, DirectPosition destination) {
            double chi;
            double theta;
            ProjectionParams projectionParams = this.getProjectionParams();
            double x = source.getX() - projectionParams.getFalseEasting().getValue(projectionParams.getLinearUnit());
            double y = source.getY() - projectionParams.getFalseNorthing().getValue(projectionParams.getLinearUnit());
            x = LinearUnit.convert((double)x, (LinearUnit)projectionParams.getLinearUnit(), (LinearUnit)projectionParams.getEllipsoid().getAxisUnit());
            y = LinearUnit.convert((double)y, (LinearUnit)projectionParams.getLinearUnit(), (LinearUnit)projectionParams.getEllipsoid().getAxisUnit());
            double ydiff = this.m_rho0 - y;
            double rho = Math.sqrt(x * x + ydiff * ydiff);
            if (this.m_bNegativeN) {
                rho = -rho;
                x = -x;
                ydiff = -ydiff;
            }
            double d = theta = x != 0.0 || ydiff != 0.0 ? Math.atan2(x, ydiff) : 0.0;
            if (this.m_modification.equals((Object)Modification.Belgium1972)) {
                theta += AngularUnit.convert((double)29.2985, (AngularUnit)AngularUnit.SECOND, (AngularUnit)AngularUnit.RADIAN);
            }
            double temp = rho / this.m_aF;
            if (this.m_bNegativeN && temp == 0.0) {
                chi = -1.5707963267948966;
            } else {
                double t = Math.pow(temp, this.m_one_over_n);
                chi = 1.5707963267948966 - 2.0 * Math.atan(t);
            }
            x = theta / this.m_n + this.m_lambda0;
            double chi2 = 2.0 * chi;
            double coschi2 = Math.cos(chi2);
            y = chi + Math.sin(chi2) * (this.m_Aprime + coschi2 * (this.m_Bprime + coschi2 * (this.m_Cprime + coschi2 * this.m_Dprime)));
            destination.setXY(CoordSysUtilities.convertClip(x, AngularUnit.RADIAN, AngularUnit.DEGREE, -360.0, 360.0), CoordSysUtilities.convertClip(y, AngularUnit.RADIAN, AngularUnit.DEGREE, -90.0, 90.0));
            return destination;
        }
    }
}

