/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.midev.coordsys.projection;

import com.mapinfo.midev.coordsys.CodeSet;
import com.mapinfo.midev.coordsys.projection.IProjectionFactory;
import com.mapinfo.midev.coordsys.projection.Projection;
import com.mapinfo.midev.coordsys.projection.ProjectionParamType;
import com.mapinfo.midev.coordsys.projection.ProjectionParams;
import com.mapinfo.midev.coordsys.util.CoordSysUtilities;
import com.mapinfo.midev.geometry.DirectPosition;
import com.mapinfo.midev.unit.AngularUnit;
import com.mapinfo.midev.unit.LinearUnit;
import com.mapinfo.midev.util.Code;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class MercatorFactory
implements IProjectionFactory {
    private static final ProjectionParamType[] PARAM_INFO = new ProjectionParamType[]{ProjectionParamType.ORIGIN_LONGITUDE};
    private static final Set<Code> CODE_SET;

    @Override
    public ProjectionParamType[] getParamInfo() {
        return PARAM_INFO;
    }

    @Override
    public Set<Code> getSupportedCodes() {
        return CODE_SET;
    }

    @Override
    public Projection createProjection(ProjectionParams projectionParams) {
        return this.createProjection("Mercator", new CodeSet(CODE_SET), projectionParams);
    }

    protected Projection createProjection(String name, CodeSet codeSet, ProjectionParams projectionParams) {
        return new Mercator(name, codeSet, projectionParams);
    }

    static {
        HashSet<Code> result = new HashSet<Code>();
        result.add(new Code("mapinfo", "projection10"));
        CODE_SET = Collections.unmodifiableSet(result);
    }

    private static class Mercator
    extends Projection
    implements Serializable {
        private double m_Lambda0;
        private double m_MultY;
        private double m_Aprime;
        private double m_Bprime;
        private double m_Cprime;
        private double m_Dprime;
        private double m_MultDivStdParl;

        public Mercator(String name, CodeSet codeSet, ProjectionParams projectionParams) {
            super(name, codeSet, projectionParams);
            this.calcInternals();
        }

        private void calcInternals() {
            ProjectionParams projectionParams = this.getProjectionParams();
            this.m_MultY = projectionParams.getEllipsoid().getSemiMajorAxis() / 2.0;
            this.m_Lambda0 = CoordSysUtilities.convertClip(projectionParams.getOriginLongitude(), AngularUnit.RADIAN, -360.0, 360.0);
            double e4 = projectionParams.getEllipsoid().getEccentricitySquared() * projectionParams.getEllipsoid().getEccentricitySquared();
            double e6 = projectionParams.getEllipsoid().getEccentricitySquared() * e4;
            double e8 = e4 * e4;
            double A = projectionParams.getEllipsoid().getEccentricitySquared() / 2.0 + 5.0 * e4 / 24.0 + e6 / 12.0 + 13.0 * e8 / 360.0;
            double B = 7.0 * e4 / 48.0 + 29.0 * e6 / 240.0 + 811.0 * e8 / 11520.0;
            double C = 7.0 * e6 / 120.0 + 81.0 * e8 / 1120.0;
            double D = 4279.0 * e8 / 161280.0;
            this.m_Aprime = A - C;
            this.m_Bprime = 2.0 * B - 4.0 * D;
            this.m_Cprime = 4.0 * C;
            this.m_Dprime = 8.0 * D;
            if (0.0 == projectionParams.getStandardParallel1().getValue(AngularUnit.DEGREE)) {
                this.m_MultDivStdParl = 1.0;
            } else {
                double phi1 = CoordSysUtilities.convertClip(projectionParams.getStandardParallel1(), AngularUnit.RADIAN, -90.0, 90.0);
                double sinphi1 = Math.sin(phi1);
                this.m_MultDivStdParl = Math.cos(phi1) / Math.sqrt(1.0 - projectionParams.getEllipsoid().getEccentricitySquared() * sinphi1 * sinphi1);
            }
        }

        @Override
        public DirectPosition fromLongLat(DirectPosition source, DirectPosition destination) {
            ProjectionParams projectionParams = this.getProjectionParams();
            double destX = Math.toRadians(source.getX());
            double destY = Math.toRadians(source.getY());
            destX = projectionParams.getEllipsoid().getSemiMajorAxis() * (destX - this.m_Lambda0) * this.m_MultDivStdParl;
            double sinphi = Math.sin(destY);
            double temp1 = 1.0 + sinphi;
            if (temp1 == 0.0) {
                destY = -1.0E9;
            } else {
                double temp2 = 1.0 - sinphi;
                if (temp2 == 0.0) {
                    destY = 1.0E9;
                } else {
                    double esinphi = projectionParams.getEllipsoid().getEccentricity() * sinphi;
                    destY = this.m_MultY * Math.log(temp1 / temp2 * Math.pow((1.0 - esinphi) / (1.0 + esinphi), projectionParams.getEllipsoid().getEccentricity())) * this.m_MultDivStdParl;
                }
            }
            destination.setXY(LinearUnit.convert((double)destX, (LinearUnit)projectionParams.getEllipsoid().getAxisUnit(), (LinearUnit)projectionParams.getLinearUnit()), LinearUnit.convert((double)destY, (LinearUnit)projectionParams.getEllipsoid().getAxisUnit(), (LinearUnit)projectionParams.getLinearUnit()));
            return destination;
        }

        @Override
        public DirectPosition toLongLat(DirectPosition source, DirectPosition destination) {
            ProjectionParams projectionParams = this.getProjectionParams();
            double x = LinearUnit.convert((double)source.getX(), (LinearUnit)projectionParams.getLinearUnit(), (LinearUnit)projectionParams.getEllipsoid().getAxisUnit());
            double y = LinearUnit.convert((double)source.getY(), (LinearUnit)projectionParams.getLinearUnit(), (LinearUnit)projectionParams.getEllipsoid().getAxisUnit());
            x = x / this.m_MultDivStdParl / projectionParams.getEllipsoid().getSemiMajorAxis() + this.m_Lambda0;
            double temp = -(y /= this.m_MultDivStdParl) / projectionParams.getEllipsoid().getSemiMajorAxis();
            double chi = temp < -1000.0 ? 1.5707963267948966 : (temp > 1000.0 ? -1.5707963267948966 : 1.5707963267948966 - 2.0 * Math.atan(Math.exp(temp)));
            double chi2 = 2.0 * chi;
            double coschi2 = Math.cos(chi2);
            y = chi + Math.sin(chi2) * (this.m_Aprime + coschi2 * (this.m_Bprime + coschi2 * (this.m_Cprime + coschi2 * this.m_Dprime)));
            destination.setXY(CoordSysUtilities.convertClip(x, AngularUnit.RADIAN, AngularUnit.DEGREE, -360.0, 360.0), CoordSysUtilities.convertClip(y, AngularUnit.RADIAN, AngularUnit.DEGREE, -90.0, 90.0));
            return destination;
        }
    }
}

