/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.midev.coordsys.projection;

import com.mapinfo.midev.coordsys.CodeSet;
import com.mapinfo.midev.coordsys.projection.IProjectionFactory;
import com.mapinfo.midev.coordsys.projection.Projection;
import com.mapinfo.midev.coordsys.projection.ProjectionParamType;
import com.mapinfo.midev.coordsys.projection.ProjectionParams;
import com.mapinfo.midev.coordsys.util.CoordSysUtilities;
import com.mapinfo.midev.geometry.DirectPosition;
import com.mapinfo.midev.unit.AngularUnit;
import com.mapinfo.midev.unit.LinearUnit;
import com.mapinfo.midev.util.Code;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class RobinsonFactory
implements IProjectionFactory {
    private static final ProjectionParamType[] PARAM_INFO = new ProjectionParamType[]{ProjectionParamType.ORIGIN_LONGITUDE};
    private static final Set<Code> CODE_SET;

    @Override
    public ProjectionParamType[] getParamInfo() {
        return PARAM_INFO;
    }

    @Override
    public Set<Code> getSupportedCodes() {
        return CODE_SET;
    }

    @Override
    public Projection createProjection(ProjectionParams projectionParams) {
        return new Robinson(new CodeSet(this.getSupportedCodes()), projectionParams);
    }

    static {
        HashSet<Code> result = new HashSet<Code>();
        result.add(new Code("mapinfo", "projection12"));
        CODE_SET = Collections.unmodifiableSet(result);
    }

    private static class Robinson
    extends Projection
    implements Serializable {
        private double m_lambda0;
        private double m_MultX;
        private double m_MultY;
        private static final double[][] m_Constants = new double[][]{{1.0, 0.0}, {0.9986, 0.062}, {0.9954, 0.124}, {0.99, 0.186}, {0.9822, 0.248}, {0.973, 0.31}, {0.96, 0.372}, {0.9427, 0.434}, {0.9216, 0.4958}, {0.8962, 0.5571}, {0.8679, 0.6176}, {0.835, 0.6769}, {0.7986, 0.7346}, {0.7597, 0.7903}, {0.7186, 0.8435}, {0.6732, 0.8936}, {0.6213, 0.9394}, {0.5722, 0.9761}, {0.5322, 1.0}, {0.5322, 1.0}};

        public Robinson(CodeSet codeSet, ProjectionParams projectionParams) {
            super("Robinson", codeSet, projectionParams);
            this.calcInternals();
        }

        private void calcInternals() {
            ProjectionParams projectionParams = this.getProjectionParams();
            double R = projectionParams.getEllipsoid().getSemiMajorAxis();
            this.m_MultX = 0.8487 * R;
            this.m_MultY = 1.3523 * R;
            this.m_lambda0 = CoordSysUtilities.convertClip(projectionParams.getOriginLongitude(), AngularUnit.RADIAN, -360.0, 360.0);
        }

        @Override
        public DirectPosition fromLongLat(DirectPosition source, DirectPosition destination) {
            ProjectionParams projectionParams = this.getProjectionParams();
            AngularUnit angularUnit = AngularUnit.DEGREE;
            double[][] constants = m_Constants;
            double multX = this.m_MultX;
            double multY = this.m_MultY;
            double lambda = CoordSysUtilities.convertClip(source.getX(), angularUnit, AngularUnit.RADIAN, -360.0, 360.0);
            double phi = CoordSysUtilities.convertClip(source.getY(), angularUnit, AngularUnit.DEGREE, -90.0, 90.0);
            double index = Math.abs(phi) / 5.0;
            int iConst = (int)index;
            double fraction = index - (double)iConst;
            double constI00 = constants[iConst][0];
            double constI01 = constants[iConst][1];
            double constI10 = constants[iConst + 1][0];
            double constI11 = constants[iConst + 1][1];
            double x = multX * (constI00 + fraction * (constI10 - constI00)) * (lambda - this.m_lambda0);
            double y = multY * (constI01 + fraction * (constI11 - constI01));
            if (phi < 0.0) {
                y = -y;
            }
            destination.setXY(LinearUnit.convert((double)x, (LinearUnit)projectionParams.getEllipsoid().getAxisUnit(), (LinearUnit)projectionParams.getLinearUnit()), LinearUnit.convert((double)y, (LinearUnit)projectionParams.getEllipsoid().getAxisUnit(), (LinearUnit)projectionParams.getLinearUnit()));
            return destination;
        }

        @Override
        public DirectPosition toLongLat(DirectPosition source, DirectPosition destination) {
            double X;
            double phi;
            double d;
            ProjectionParams projectionParams = this.getProjectionParams();
            double x = LinearUnit.convert((double)source.getX(), (LinearUnit)projectionParams.getLinearUnit(), (LinearUnit)projectionParams.getEllipsoid().getAxisUnit());
            double y = LinearUnit.convert((double)source.getY(), (LinearUnit)projectionParams.getLinearUnit(), (LinearUnit)projectionParams.getEllipsoid().getAxisUnit());
            double Y = Math.abs(y / this.m_MultY);
            if (d >= 1.0) {
                phi = 90.0;
                X = m_Constants[18][0];
            } else {
                int i = 0;
                for (int j = 0; j < 19; ++j) {
                    if (!(m_Constants[j + 1][1] > Y)) continue;
                    i = j;
                    break;
                }
                double fraction = (Y - m_Constants[i][1]) / (m_Constants[i + 1][1] - m_Constants[i][1]);
                phi = ((double)i + fraction) * 5.0;
                X = m_Constants[i][0] + fraction * (m_Constants[i + 1][0] - m_Constants[i][0]);
            }
            x = CoordSysUtilities.convertClip(x / (X * this.m_MultX) + this.m_lambda0, AngularUnit.RADIAN, AngularUnit.DEGREE, -360.0, 360.0);
            y = y < 0.0 ? -phi : phi;
            destination.setXY(x, y);
            return destination;
        }
    }
}

